/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pattern;

import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.TraceabilityPredicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PatternError {
    protected BlockWorldState worldState;

    public void setWorldState(BlockWorldState worldState) {
        this.worldState = worldState;
    }

    public World getWorld() {
        return this.worldState.getWorld();
    }

    public BlockPos getPos() {
        return this.worldState.getPos();
    }

    public List<List<ItemStack>> getCandidates() {
        TraceabilityPredicate predicate = this.worldState.predicate;
        ArrayList<List<ItemStack>> candidates = new ArrayList<List<ItemStack>>();
        for (TraceabilityPredicate.SimplePredicate common : predicate.common) {
            candidates.add(common.getCandidates());
        }
        for (TraceabilityPredicate.SimplePredicate limited : predicate.limited) {
            candidates.add(limited.getCandidates());
        }
        return candidates;
    }

    @SideOnly(value=Side.CLIENT)
    public String getErrorInfo() {
        List<List<ItemStack>> candidates = this.getCandidates();
        StringBuilder builder = new StringBuilder();
        for (List<ItemStack> candidate : candidates) {
            if (candidate.isEmpty()) continue;
            builder.append(candidate.get(0).func_82833_r());
            builder.append(", ");
        }
        builder.append("...");
        return I18n.func_135052_a((String)"gregtech.multiblock.pattern.error", (Object[])new Object[]{builder.toString(), this.worldState.pos});
    }
}

