/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet;

import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GTLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class PipeNetWalker {
    private PipeNetWalker root;
    private final World world;
    private final Set<Long> walked = new HashSet<Long>();
    private final List<EnumFacing> pipes = new ArrayList<EnumFacing>();
    private List<PipeNetWalker> walkers;
    private final BlockPos.MutableBlockPos currentPos;
    private int walkedBlocks;
    private boolean invalid;
    private boolean running;
    private boolean failed = false;

    protected PipeNetWalker(World world, BlockPos sourcePipe, int walkedBlocks) {
        this.world = Objects.requireNonNull(world);
        this.walkedBlocks = walkedBlocks;
        this.currentPos = new BlockPos.MutableBlockPos(Objects.requireNonNull(sourcePipe));
        this.root = this;
    }

    protected abstract PipeNetWalker createSubWalker(World var1, EnumFacing var2, BlockPos var3, int var4);

    protected abstract void checkPipe(IPipeTile<?, ?> var1, BlockPos var2);

    protected abstract void checkNeighbour(IPipeTile<?, ?> var1, BlockPos var2, EnumFacing var3, @Nullable TileEntity var4);

    protected abstract boolean isValidPipe(IPipeTile<?, ?> var1, IPipeTile<?, ?> var2, BlockPos var3, EnumFacing var4);

    protected void onRemoveSubWalker(PipeNetWalker subWalker) {
    }

    public void traversePipeNet() {
        this.traversePipeNet(32768);
    }

    public void traversePipeNet(int maxWalks) {
        if (this.invalid) {
            throw new IllegalStateException("This walker already walked. Create a new one if you want to walk again");
        }
        int i = 0;
        this.running = true;
        while (this.running && !this.walk() && i++ < maxWalks) {
        }
        this.running = false;
        this.root.walked.clear();
        if (i >= maxWalks) {
            GTLog.logger.fatal("The walker reached the maximum amount of walks {}", (Object)i);
        }
        this.invalid = true;
    }

    private boolean walk() {
        if (this.walkers == null) {
            this.checkPos();
            if (this.pipes.size() == 0) {
                return true;
            }
            if (this.pipes.size() == 1) {
                this.currentPos.func_189536_c(this.pipes.get(0));
                ++this.walkedBlocks;
                return !this.isRunning();
            }
            this.walkers = new ArrayList<PipeNetWalker>();
            for (EnumFacing side : this.pipes) {
                PipeNetWalker walker = Objects.requireNonNull(this.createSubWalker(this.world, side, this.currentPos.func_177972_a(side), this.walkedBlocks + 1), "Walker can't be null");
                walker.root = this.root;
                this.walkers.add(walker);
            }
        }
        Iterator<PipeNetWalker> iterator = this.walkers.iterator();
        while (iterator.hasNext()) {
            PipeNetWalker walker = iterator.next();
            if (!walker.walk()) continue;
            this.onRemoveSubWalker(walker);
            iterator.remove();
        }
        return !this.isRunning() || this.walkers.size() == 0;
    }

    private void checkPos() {
        this.pipes.clear();
        TileEntity thisPipe = this.world.func_175625_s((BlockPos)this.currentPos);
        IPipeTile pipeTile = (IPipeTile)thisPipe;
        if (pipeTile == null) {
            if (this.walkedBlocks == 1) {
                GTLog.logger.error("First PipeTile is null during walk at {}", (Object)this.currentPos);
                this.failed = true;
                return;
            }
            throw new IllegalStateException("PipeTile was not null last walk, but now is");
        }
        this.checkPipe(pipeTile, (BlockPos)this.currentPos);
        this.root.walked.add(pipeTile.getPipePos().func_177986_g());
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing accessSide : EnumFacing.field_82609_l) {
            if (!pipeTile.isConnected(accessSide)) continue;
            pos.func_189533_g((Vec3i)this.currentPos).func_189536_c(accessSide);
            TileEntity tile = this.world.func_175625_s((BlockPos)pos);
            if (tile instanceof IPipeTile) {
                IPipeTile otherPipe = (IPipeTile)tile;
                if (!otherPipe.isConnected(accessSide.func_176734_d()) || otherPipe.isFaceBlocked(accessSide.func_176734_d()) || this.isWalked(otherPipe)) continue;
                if (this.isValidPipe(pipeTile, otherPipe, (BlockPos)this.currentPos, accessSide)) {
                    this.pipes.add(accessSide);
                    continue;
                }
            }
            this.checkNeighbour(pipeTile, (BlockPos)this.currentPos, accessSide, tile);
        }
        pos.func_185344_t();
    }

    protected boolean isWalked(IPipeTile<?, ?> pipe) {
        return this.root.walked.contains(pipe.getPipePos().func_177986_g());
    }

    public void stop() {
        this.root.running = false;
    }

    public boolean isRunning() {
        return this.root.running;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getCurrentPos() {
        return this.currentPos;
    }

    public int getWalkedBlocks() {
        return this.walkedBlocks;
    }

    public boolean isRoot() {
        return this.root == this;
    }

    public boolean isFailed() {
        return this.failed;
    }
}

