/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.logic;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.metatileentity.IVoidable;
import gregtech.api.recipes.FluidKey;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.util.GTHashMaps;
import gregtech.api.util.ItemStackKey;
import gregtech.api.util.OverlayedFluidHandler;
import gregtech.api.util.OverlayedItemHandler;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ParallelLogic {
    public static int getMaxRecipeMultiplier(@Nonnull Recipe recipe, @Nonnull IItemHandlerModifiable inputs, @Nonnull IMultipleTankHandler fluidInputs, int parallelAmount) {
        Map<ItemStackKey, Integer> ingredientStacks = GTHashMaps.fromItemHandler((IItemHandler)inputs);
        Map<FluidKey, Integer> fluidStacks = GTHashMaps.fromFluidHandler(fluidInputs);
        int itemMultiplier = ParallelLogic.getMaxRatioItem(ingredientStacks, recipe, parallelAmount);
        int fluidMultiplier = ParallelLogic.getMaxRatioFluid(fluidStacks, recipe, parallelAmount);
        if (itemMultiplier == Integer.MAX_VALUE && fluidMultiplier == Integer.MAX_VALUE) {
            return 0;
        }
        return Math.min(itemMultiplier, fluidMultiplier);
    }

    public static int limitByOutputMerging(@Nonnull Recipe recipe, @Nonnull IItemHandlerModifiable outputs, @Nonnull IMultipleTankHandler fluidOutputs, int parallelAmount, boolean voidItems, boolean voidFluids) {
        int modifiedItemParallelAmount = Integer.MAX_VALUE;
        int modifiedFluidParallelAmount = Integer.MAX_VALUE;
        if (voidItems && voidFluids) {
            return parallelAmount;
        }
        if (!(recipe.getOutputs().size() <= 0 && recipe.getChancedOutputs().size() <= 0 || (modifiedItemParallelAmount = voidItems ? parallelAmount : ParallelLogic.limitParallelByItems(recipe, new OverlayedItemHandler((IItemHandler)outputs), parallelAmount)) != 0 || voidItems)) {
            return 0;
        }
        if (recipe.getFluidOutputs().size() > 0 && (modifiedFluidParallelAmount = voidFluids ? parallelAmount : ParallelLogic.limitParallelByFluids(recipe, new OverlayedFluidHandler(fluidOutputs), modifiedItemParallelAmount)) == 0 && !voidFluids) {
            return 0;
        }
        return Math.min(modifiedFluidParallelAmount, modifiedItemParallelAmount);
    }

    public static int limitParallelByItems(@Nonnull Recipe recipe, @Nonnull OverlayedItemHandler overlayedItemHandler, int multiplier) {
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        Map<ItemStackKey, Integer> recipeOutputs = GTHashMaps.fromItemStackCollection(recipe.getAllItemOutputs());
        while (minMultiplier != maxMultiplier) {
            overlayedItemHandler.reset();
            int returnedAmount = 0;
            int amountToInsert = 0;
            for (Map.Entry<ItemStackKey, Integer> entry : recipeOutputs.entrySet()) {
                amountToInsert = entry.getValue() != 0 && multiplier > Integer.MAX_VALUE / entry.getValue() ? Integer.MAX_VALUE : entry.getValue() * multiplier;
                returnedAmount = overlayedItemHandler.insertStackedItemStackKey(entry.getKey(), amountToInsert);
                if (returnedAmount <= 0) continue;
                break;
            }
            int[] bin = ParallelLogic.adjustMultiplier(returnedAmount == 0, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = bin[0];
            multiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return multiplier;
    }

    public static int limitParallelByItemsIncremental(@Nonnull List<ItemStack> recipeOutputList, @Nonnull List<ItemStack> outputsToAppend, @Nonnull OverlayedItemHandler overlayedItemHandler, int multiplier) {
        int minMultiplier = 0;
        int currentMultiplier = multiplier;
        int maxMultiplier = multiplier;
        int previousMultiplier = multiplier;
        Map<ItemStackKey, Integer> recipeOutputs = GTHashMaps.fromItemStackCollection(recipeOutputList);
        Map<ItemStackKey, Integer> recipeOutputsToAppend = GTHashMaps.fromItemStackCollection(outputsToAppend);
        HashMap<ItemStackKey, Integer> appendedResultMap = new HashMap<ItemStackKey, Integer>(recipeOutputs);
        recipeOutputsToAppend.forEach((stackKey, amt) -> appendedResultMap.merge((ItemStackKey)stackKey, amt * multiplier, Integer::sum));
        while (minMultiplier != maxMultiplier) {
            overlayedItemHandler.reset();
            if (currentMultiplier != previousMultiplier) {
                int diff = currentMultiplier - previousMultiplier;
                recipeOutputsToAppend.forEach((sk, amt) -> appendedResultMap.put((ItemStackKey)sk, (Integer)appendedResultMap.get(sk) + amt * diff));
                previousMultiplier = currentMultiplier;
            }
            int returnedAmount = 0;
            for (Map.Entry entry : appendedResultMap.entrySet()) {
                int amountToInsert = (Integer)entry.getValue();
                returnedAmount = overlayedItemHandler.insertStackedItemStackKey((ItemStackKey)entry.getKey(), amountToInsert);
                if (returnedAmount <= 0) continue;
                break;
            }
            int[] bin = ParallelLogic.adjustMultiplier(returnedAmount == 0, minMultiplier, currentMultiplier, maxMultiplier);
            minMultiplier = bin[0];
            currentMultiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return currentMultiplier;
    }

    @Nonnull
    public static int[] adjustMultiplier(boolean mergedAll, int minMultiplier, int multiplier, int maxMultiplier) {
        if (mergedAll) {
            minMultiplier = multiplier;
            int remainder = (maxMultiplier - multiplier) % 2;
            multiplier = multiplier + remainder + (maxMultiplier - multiplier) / 2;
        } else {
            maxMultiplier = multiplier;
            multiplier = (multiplier + minMultiplier) / 2;
        }
        if (maxMultiplier - minMultiplier <= 1) {
            multiplier = maxMultiplier = minMultiplier;
        }
        return new int[]{minMultiplier, multiplier, maxMultiplier};
    }

    public static int limitParallelByFluids(@Nonnull Recipe recipe, @Nonnull OverlayedFluidHandler overlayedFluidHandler, int multiplier) {
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        Map<FluidKey, Integer> recipeFluidOutputs = GTHashMaps.fromFluidCollection(recipe.getFluidOutputs());
        while (minMultiplier != maxMultiplier) {
            overlayedFluidHandler.reset();
            int amountLeft = 0;
            for (Map.Entry<FluidKey, Integer> entry : recipeFluidOutputs.entrySet()) {
                amountLeft = entry.getValue() != 0 && multiplier > Integer.MAX_VALUE / entry.getValue() ? Integer.MAX_VALUE : entry.getValue() * multiplier;
                int inserted = overlayedFluidHandler.insertStackedFluidKey(entry.getKey(), amountLeft);
                if (inserted > 0) {
                    amountLeft -= inserted;
                }
                if (amountLeft <= 0) continue;
                break;
            }
            int[] bin = ParallelLogic.adjustMultiplier(amountLeft == 0, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = bin[0];
            multiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return multiplier;
    }

    protected static int getMaxRatioItem(@Nonnull Map<ItemStackKey, Integer> countIngredients, @Nonnull Recipe recipe, int parallelAmount) {
        int available;
        int needed;
        int minMultiplier = Integer.MAX_VALUE;
        Object2IntOpenHashMap notConsumableMap = new Object2IntOpenHashMap();
        Object2IntOpenHashMap countableMap = new Object2IntOpenHashMap();
        for (GTRecipeInput recipeIngredient : recipe.getInputs()) {
            int ingredientCount = recipeIngredient.getAmount();
            if (recipeIngredient.isNonConsumable()) {
                notConsumableMap.computeIfPresent((Object)recipeIngredient, (k, v) -> v + ingredientCount);
                notConsumableMap.putIfAbsent((Object)recipeIngredient, (Object)ingredientCount);
                continue;
            }
            countableMap.computeIfPresent((Object)recipeIngredient, (k, v) -> v + ingredientCount);
            countableMap.putIfAbsent((Object)recipeIngredient, (Object)ingredientCount);
        }
        for (Map.Entry recipeInputEntry : notConsumableMap.entrySet()) {
            needed = (Integer)recipeInputEntry.getValue();
            available = 0;
            for (Map.Entry<ItemStackKey, Integer> inventoryEntry : countIngredients.entrySet()) {
                if (!((GTRecipeInput)recipeInputEntry.getKey()).acceptsStack(inventoryEntry.getKey().getItemStackRaw())) continue;
                available = inventoryEntry.getValue();
                if (available > needed) {
                    inventoryEntry.setValue(available - needed);
                    needed -= available;
                    break;
                }
                inventoryEntry.setValue(0);
                recipeInputEntry.setValue(needed - available);
                needed -= available;
            }
            if (needed < available) continue;
            return 0;
        }
        if (countableMap.isEmpty() && !notConsumableMap.isEmpty()) {
            return parallelAmount;
        }
        for (Map.Entry recipeInputEntry : countableMap.entrySet()) {
            needed = (Integer)recipeInputEntry.getValue();
            available = 0;
            for (Map.Entry<ItemStackKey, Integer> inventoryEntry : countIngredients.entrySet()) {
                if (!((GTRecipeInput)recipeInputEntry.getKey()).acceptsStack(inventoryEntry.getKey().getItemStackRaw())) continue;
                available += inventoryEntry.getValue().intValue();
            }
            if (available >= needed) {
                int ratio = Math.min(parallelAmount, available / needed);
                if (ratio >= minMultiplier) continue;
                minMultiplier = ratio;
                continue;
            }
            return 0;
        }
        return minMultiplier;
    }

    protected static int getMaxRatioFluid(@Nonnull Map<FluidKey, Integer> countFluid, @Nonnull Recipe recipe, int parallelAmount) {
        int available;
        int needed;
        int minMultiplier = Integer.MAX_VALUE;
        HashMap<FluidKey, Integer> fluidCountMap = new HashMap<FluidKey, Integer>();
        HashMap<FluidKey, Integer> notConsumableMap = new HashMap<FluidKey, Integer>();
        for (GTRecipeInput gTRecipeInput : recipe.getFluidInputs()) {
            int fluidAmount = gTRecipeInput.getAmount();
            if (gTRecipeInput.isNonConsumable()) {
                notConsumableMap.computeIfPresent(new FluidKey(gTRecipeInput.getInputFluidStack()), (k, v) -> v + fluidAmount);
                notConsumableMap.putIfAbsent(new FluidKey(gTRecipeInput.getInputFluidStack()), fluidAmount);
                continue;
            }
            fluidCountMap.computeIfPresent(new FluidKey(gTRecipeInput.getInputFluidStack()), (k, v) -> v + fluidAmount);
            fluidCountMap.putIfAbsent(new FluidKey(gTRecipeInput.getInputFluidStack()), fluidAmount);
        }
        for (Map.Entry entry : notConsumableMap.entrySet()) {
            needed = (Integer)entry.getValue();
            available = 0;
            for (Map.Entry<FluidKey, Integer> inputFluid : countFluid.entrySet()) {
                if (!((FluidKey)entry.getKey()).equals(inputFluid.getKey())) continue;
                available = inputFluid.getValue();
                if (available > needed) {
                    inputFluid.setValue(available - needed);
                    needed -= available;
                    break;
                }
                inputFluid.setValue(0);
                entry.setValue(needed - available);
                needed -= available;
            }
            if (needed < available) continue;
            return 0;
        }
        if (fluidCountMap.isEmpty() && !notConsumableMap.isEmpty()) {
            return parallelAmount;
        }
        for (Map.Entry entry : fluidCountMap.entrySet()) {
            needed = (Integer)entry.getValue();
            available = 0;
            for (Map.Entry<FluidKey, Integer> inputFluid : countFluid.entrySet()) {
                if (!((FluidKey)entry.getKey()).equals(inputFluid.getKey())) continue;
                available += inputFluid.getValue().intValue();
            }
            if (available >= needed) {
                int ratio = Math.min(parallelAmount, available / needed);
                if (ratio >= minMultiplier) continue;
                minMultiplier = ratio;
                continue;
            }
            return 0;
        }
        return minMultiplier;
    }

    public static RecipeBuilder<?> doParallelRecipes(@Nonnull Recipe currentRecipe, @Nonnull RecipeMap<?> recipeMap, @Nonnull IItemHandlerModifiable importInventory, @Nonnull IMultipleTankHandler importFluids, @Nonnull IItemHandlerModifiable exportInventory, @Nonnull IMultipleTankHandler exportFluids, int parallelAmount, long maxVoltage, @Nonnull IVoidable voidable) {
        int multiplierByInputs = ParallelLogic.getMaxRecipeMultiplier(currentRecipe, importInventory, importFluids, parallelAmount);
        if (multiplierByInputs == 0) {
            return null;
        }
        Object recipeBuilder = recipeMap.recipeBuilder();
        boolean voidItems = voidable.canVoidRecipeItemOutputs();
        boolean voidFluids = voidable.canVoidRecipeFluidOutputs();
        int limitByOutput = ParallelLogic.limitByOutputMerging(currentRecipe, exportInventory, exportFluids, multiplierByInputs, voidItems, voidFluids);
        int recipeEUt = currentRecipe.getEUt();
        if (recipeEUt != 0) {
            int limitByVoltage = Math.abs((int)(maxVoltage / (long)recipeEUt));
            int parallelizable = Math.min(limitByVoltage, limitByOutput);
            if (parallelizable != 0) {
                ((RecipeBuilder)recipeBuilder).append(currentRecipe, Math.min(parallelizable, multiplierByInputs), false);
            }
        } else if (limitByOutput > 0) {
            ((RecipeBuilder)recipeBuilder).append(currentRecipe, limitByOutput, false);
        }
        return recipeBuilder;
    }

    public static RecipeBuilder<?> appendItemRecipes(@Nonnull RecipeMap<?> recipeMap, @Nonnull IItemHandlerModifiable importInventory, @Nonnull IItemHandlerModifiable exportInventory, int parallelAmount, long maxVoltage, IVoidable voidable) {
        RecipeBuilder recipeBuilder = null;
        OverlayedItemHandler overlayedItemHandler = new OverlayedItemHandler((IItemHandler)exportInventory);
        int engagedItems = 0;
        for (int index = 0; index < importInventory.getSlots(); ++index) {
            int multiplierRecipeAmount;
            Recipe matchingRecipe;
            ItemStack currentInputItem = importInventory.getStackInSlot(index);
            if (currentInputItem.func_190926_b() || (matchingRecipe = recipeMap.findRecipe(maxVoltage, Collections.singletonList(currentInputItem), Collections.emptyList(), 0)) == null) continue;
            GTRecipeInput inputIngredient = matchingRecipe.getInputs().get(0);
            if (recipeBuilder == null) {
                recipeBuilder = (RecipeBuilder)((RecipeBuilder)((RecipeBuilder)recipeMap.recipeBuilder()).EUt(0)).duration(0);
            }
            if (inputIngredient == null) {
                throw new IllegalStateException(String.format("Got recipe with null ingredient %s", matchingRecipe));
            }
            matchingRecipe = matchingRecipe.trimRecipeOutputs(matchingRecipe, recipeMap, voidable.getItemOutputLimit(), voidable.getFluidOutputLimit());
            int ingredientRatio = Math.min(parallelAmount - engagedItems, currentInputItem.func_190916_E() / Math.max(matchingRecipe.getInputs().get(0).getAmount(), 1));
            int limitByOutput = Integer.MAX_VALUE;
            if (!voidable.canVoidRecipeItemOutputs()) {
                limitByOutput = ParallelLogic.limitParallelByItemsIncremental(recipeBuilder.getAllItemOutputs(), matchingRecipe.getOutputs(), overlayedItemHandler, ingredientRatio);
            }
            if ((multiplierRecipeAmount = Math.min(ingredientRatio, limitByOutput)) > 0) {
                recipeBuilder.append(matchingRecipe, multiplierRecipeAmount, true);
                engagedItems += multiplierRecipeAmount;
            }
            if (engagedItems == parallelAmount) break;
        }
        return recipeBuilder;
    }
}

