/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.os;

import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.util.function.TriConsumer;

public enum SystemCall {
    CALL_MENU("call_menu", 0, (os, side, args) -> os.callMenu((boolean)side)),
    FULL_SCREEN("full_screen", 1, (os, side, args) -> os.maximize((boolean)side)),
    MINIMIZE_FOCUS_APP("minimize_focus_app", 2, (os, side, args) -> os.minimizeApplication(os.getFocusApp(), (boolean)side)),
    CLOSE_FOCUS_APP("close_focus_app", 3, (os, side, args) -> os.closeApplication(os.getFocusApp(), (boolean)side)),
    SHUT_DOWN("shutdown", 4, (os, side, args) -> os.shutdown((boolean)side)),
    OPEN_APP("open_app", 5, (os, side, args) -> {
        AbstractApplication app;
        if (((String[])args).length > 0 && args[0] != null && (app = TerminalRegistry.getApplication(args[0])) != null) {
            os.openApplication(app, (boolean)side);
        }
    });

    TriConsumer<TerminalOSWidget, Boolean, String[]> action;
    String name;
    int index;

    private SystemCall(String name, int index, TriConsumer<TerminalOSWidget, Boolean, String[]> action) {
        this.action = action;
        this.name = name;
        this.index = index;
    }

    public void call(TerminalOSWidget os, boolean isClient, String ... args) {
        this.action.accept(os, isClient, args);
    }

    public String getTranslateKey() {
        return "terminal.system_call." + this.name;
    }

    public static SystemCall getFromName(String name) {
        for (SystemCall value : SystemCall.values()) {
            if (value.name.toLowerCase().equals(name.toLowerCase())) {
                return value;
            }
            if (!value.getTranslateKey().equals(name)) continue;
            return value;
        }
        return null;
    }

    public static SystemCall getFromIndex(int index) {
        for (SystemCall value : SystemCall.values()) {
            if (value.index != index) continue;
            return value;
        }
        return null;
    }
}

