/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.os;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.terminal.hardware.HardwareProvider;
import gregtech.api.terminal.os.TerminalDesktopWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalHomeButtonWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.terminal.os.menu.TerminalMenuWidget;
import gregtech.api.util.GTLog;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import gregtech.common.items.behaviors.TerminalBehaviour;
import gregtech.common.terminal.app.settings.widgets.OsSettings;
import gregtech.common.terminal.hardware.BatteryHardware;
import gregtech.common.terminal.hardware.DeviceHardware;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class TerminalOSWidget
extends AbstractWidgetGroup {
    public static final TextureArea TERMINAL_FRAME = TextureArea.fullImage("textures/gui/terminal/terminal_frame.png");
    public static final TextureArea TERMINAL_HOME = TextureArea.fullImage("textures/gui/terminal/terminal_home.png");
    public static final int DEFAULT_WIDTH = 333;
    public static final int DEFAULT_HEIGHT = 232;
    private IGuiTexture background = TerminalTheme.WALL_PAPER;
    private AbstractApplication focusApp;
    public final NBTTagCompound tabletNBT;
    public final List<AbstractApplication> openedApps = new ArrayList<AbstractApplication>();
    public final List<AbstractApplication> installedApps = new ArrayList<AbstractApplication>();
    public final TerminalMenuWidget menu;
    public final TerminalDesktopWidget desktop = new TerminalDesktopWidget(Position.ORIGIN, new Size(333, 232), this);
    public final TerminalHomeButtonWidget home;
    public final BlockPos clickPos;
    public final ItemStack itemStack;
    public final HardwareProvider hardwareProvider;
    private int tickCounter;
    private long lastCharge;
    private boolean maximize;
    private boolean showMenuHover = false;
    boolean waitShutdown;

    public TerminalOSWidget(int xPosition, int yPosition, ItemStack itemStack) {
        super(new Position(xPosition, yPosition), new Size(333, 232));
        this.menu = new TerminalMenuWidget(Position.ORIGIN, new Size(31, 232), this).setBackground(TerminalTheme.COLOR_B_2);
        this.home = new TerminalHomeButtonWidget(this);
        this.addWidget(this.desktop);
        this.addWidget(this.menu);
        this.addWidget(this.home);
        this.itemStack = itemStack;
        this.tabletNBT = itemStack.func_190925_c("terminal");
        this.tabletNBT.func_82580_o("_ar");
        this.hardwareProvider = (HardwareProvider)itemStack.getCapability(GregtechCapabilities.CAPABILITY_HARDWARE_PROVIDER, null);
        if (TerminalBehaviour.isCreative(itemStack)) {
            TerminalRegistry.getAllApps().forEach(this::installApplication);
        } else {
            TerminalRegistry.getDefaultApps().forEach(this::installApplication);
            NBTTagList installed = this.tabletNBT.func_150295_c("_installed", 8);
            for (NBTBase nbtBase : installed) {
                AbstractApplication app;
                if (!(nbtBase instanceof NBTTagString) || (app = TerminalRegistry.getApplication(((NBTTagString)nbtBase).func_150285_a_())) == null) continue;
                this.installApplication(app);
            }
        }
        this.clickPos = this.tabletNBT.func_74764_b("_click") ? NBTUtil.func_186861_c((NBTTagCompound)this.tabletNBT.func_74775_l("_click")) : null;
    }

    public ModularUI getModularUI() {
        return this.gui;
    }

    public TerminalOSWidget setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public AbstractApplication getFocusApp() {
        return this.focusApp;
    }

    public List<Hardware> getHardware() {
        if (this.hardwareProvider == null) {
            return Collections.emptyList();
        }
        return this.hardwareProvider.getHardware();
    }

    public <T extends Hardware> List<T> getHardware(Class<T> clazz) {
        return this.getHardware().stream().filter(hw -> hw.getClass() == clazz).map(hw -> hw).collect(Collectors.toList());
    }

    public void installApplication(AbstractApplication application) {
        this.desktop.installApplication(application);
        this.installedApps.add(application);
    }

    public void openApplication(AbstractApplication application, boolean isClient) {
        Object hwDemand;
        List unMatch;
        this.desktop.removeAllDialogs();
        NBTTagCompound nbt = this.tabletNBT.func_74775_l(application.getRegistryName());
        if (!TerminalBehaviour.isCreative(this.itemStack) && (unMatch = (hwDemand = TerminalRegistry.getAppHardwareDemand(application.getRegistryName(), Math.min(nbt.func_74762_e("_tier"), application.getMaxTier()))).stream().filter(demand -> this.getHardware().stream().noneMatch(hw -> hw.isHardwareAdequate((Hardware)demand))).collect(Collectors.toList())).size() > 0) {
            if (isClient) {
                StringBuilder tooltips = new StringBuilder("\n");
                for (Hardware match : unMatch) {
                    String info = match.addInformation();
                    String name = match.getLocalizedName();
                    if (info == null) {
                        tooltips.append(name);
                    } else if (match instanceof BatteryHardware) {
                        IElectricItem energyItem = (IElectricItem)this.itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                        if (energyItem != null && energyItem.getCharge() <= 0L) {
                            tooltips.append(I18n.func_135052_a((String)"terminal.battery.low_energy", (Object[])new Object[0]));
                        } else {
                            tooltips.append(String.format("%s (%s+)", name, info));
                        }
                    } else {
                        tooltips.append(String.format("%s (%s)", name, info));
                    }
                    tooltips.append(" ");
                }
                TerminalDialogWidget.showInfoDialog(this, "terminal.component.error", I18n.func_135052_a((String)"terminal.os.hw_demand", (Object[])new Object[0]) + tooltips).setClientSide().open();
            }
            return;
        }
        if (!application.canPlayerUse(this.gui.entityPlayer)) {
            return;
        }
        if (this.focusApp != null) {
            this.closeApplication(this.focusApp, isClient);
        }
        for (AbstractApplication app : this.openedApps) {
            if (!app.getRegistryName().equals(application.getRegistryName()) || !application.canLaunchConcurrently(app)) continue;
            app.onOSSizeUpdate(this.getSize().width, this.getSize().height);
            this.maximizeApplication(app, isClient);
            return;
        }
        AbstractApplication app = application.createAppInstance(this, isClient, nbt);
        if (app != null) {
            this.desktop.addWidget(app);
            app.setOs(this).initApp();
            app.onOSSizeUpdate(this.getSize().width, this.getSize().height);
            this.openedApps.add(app);
            this.maximizeApplication(app, isClient);
        }
    }

    public void maximizeApplication(AbstractApplication application, boolean isClient) {
        application.setActive(true);
        if (isClient) {
            application.maximizeWidget(app -> this.desktop.hideDesktop());
            if (!this.menu.isHide) {
                this.menu.hideMenu();
            }
        }
        this.focusApp = application;
        this.menu.loadComponents(this.focusApp);
        this.desktop.hideDesktop();
    }

    public void minimizeApplication(AbstractApplication application, boolean isClient) {
        this.desktop.removeAllDialogs();
        if (application != null) {
            if (this.focusApp == application) {
                if (isClient) {
                    application.minimizeWidget(app -> {
                        if (!application.isBackgroundApp()) {
                            application.setActive(false);
                        }
                    });
                } else if (!application.isBackgroundApp()) {
                    application.setActive(false);
                }
                this.focusApp = null;
            }
            this.menu.removeComponents();
            this.desktop.showDesktop();
        }
    }

    public void closeApplication(AbstractApplication application, boolean isClient) {
        this.desktop.removeAllDialogs();
        if (application != null) {
            String appName = application.getRegistryName();
            NBTTagCompound synced = application.closeApp();
            if (synced != null && !synced.func_82582_d()) {
                this.tabletNBT.func_74782_a(appName, (NBTBase)synced);
                if (application.isClientSideApp() && isClient) {
                    this.writeClientAction(-2, buffer -> {
                        buffer.func_180714_a(appName);
                        buffer.func_150786_a(synced);
                    });
                }
            }
            if (isClient && this.focusApp == application) {
                application.minimizeWidget(this.desktop::waitToRemoved);
            } else {
                this.desktop.waitToRemoved(application);
            }
            this.openedApps.remove(application);
            if (this.focusApp == application) {
                this.focusApp = null;
            }
            this.menu.removeComponents();
            this.desktop.showDesktop();
        }
    }

    public void callMenu(boolean isClient) {
        if (isClient) {
            if (this.menu.isHide) {
                this.menu.showMenu();
            } else {
                this.menu.hideMenu();
            }
        }
    }

    public void shutdown(boolean isClient) {
        if (isClient) {
            NBTTagCompound nbt = new NBTTagCompound();
            for (AbstractApplication openedApp : this.openedApps) {
                String appName = openedApp.getRegistryName();
                NBTTagCompound synced = openedApp.closeApp();
                if (synced == null || synced.func_82582_d()) continue;
                this.tabletNBT.func_74782_a(appName, (NBTBase)synced);
                if (!openedApp.isClientSideApp()) continue;
                nbt.func_74782_a(appName, (NBTBase)synced);
            }
            this.writeClientAction(-1, buffer -> buffer.func_150786_a(nbt));
        } else {
            this.writeUpdateInfo(-2, packetBuffer -> {});
        }
    }

    protected void openDialog(TerminalDialogWidget widget) {
        if (this.isRemote()) {
            widget.onOSSizeUpdate(this.getSize().width, this.getSize().height);
            widget.maximizeWidget(null);
        } else if (widget.isClient()) {
            return;
        }
        this.desktop.addWidget(widget);
    }

    protected void closeDialog(TerminalDialogWidget widget) {
        if (this.isRemote()) {
            widget.minimizeWidget(this.desktop::waitToRemoved);
        } else if (!widget.isClient()) {
            this.desktop.waitToRemoved(widget);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            NBTTagCompound nbt = null;
            try {
                nbt = buffer.func_150793_b();
            }
            catch (IOException e) {
                GTLog.logger.error("TerminalOSWidget Shutdown could not read NBT tag from buffer", (Throwable)e);
            }
            for (AbstractApplication openedApp : this.openedApps) {
                String appName = openedApp.getRegistryName();
                NBTTagCompound data = openedApp.closeApp();
                if (data != null && !data.func_82582_d()) {
                    this.tabletNBT.func_74782_a(appName, (NBTBase)data);
                    continue;
                }
                if (nbt == null || !openedApp.isClientSideApp() || !nbt.func_74764_b(appName)) continue;
                this.tabletNBT.func_74782_a(appName, (NBTBase)nbt.func_74775_l(appName));
            }
            this.getModularUI().entityPlayer.func_71053_j();
        } else if (id == -2) {
            String appName = buffer.func_150789_c(Short.MAX_VALUE);
            NBTTagCompound nbt = null;
            try {
                nbt = buffer.func_150793_b();
            }
            catch (IOException e) {
                GTLog.logger.error("TerminalOSWidget CloseApp could not read NBT tag from buffer", (Throwable)e);
            }
            if (nbt != null) {
                this.tabletNBT.func_74782_a(appName, (NBTBase)nbt);
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == -1) {
            long charge = buffer.readLong();
            IElectricItem electricItem = (IElectricItem)this.itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem instanceof BatteryHardware) {
                ((BatteryHardware)electricItem).setCharge(charge);
            }
            if (charge <= 0L) {
                LinkedList toClosed = new LinkedList();
                for (AbstractApplication openedApp : this.openedApps) {
                    TerminalRegistry.getAppHardwareDemand(openedApp.getRegistryName(), openedApp.getAppTier()).stream().filter(i -> i instanceof BatteryHardware).findFirst().ifPresent(x -> toClosed.add(openedApp));
                }
                for (AbstractApplication close : toClosed) {
                    this.closeApplication(close, true);
                }
                TerminalDialogWidget.showInfoDialog(this, "terminal.component.warning", "terminal.battery.low_energy").setClientSide().open();
            }
        } else if (id == -2) {
            this.shutdown(true);
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        ++this.tickCounter;
        if (this.background != null) {
            this.background.updateTick();
        }
    }

    @Override
    public void detectAndSendChanges() {
        long energyStore;
        super.detectAndSendChanges();
        ++this.tickCounter;
        if (this.tickCounter % 20 == 0 && this.lastCharge != (energyStore = this.disCharge())) {
            this.lastCharge = energyStore;
            this.writeUpdateInfo(-1, packetBuffer -> packetBuffer.writeLong(this.lastCharge));
        }
    }

    private long disCharge() {
        IElectricItem electricItem = this.hardwareProvider.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null && !TerminalBehaviour.isCreative(this.itemStack)) {
            AtomicLong costs = new AtomicLong(0L);
            ArrayList charged = new ArrayList();
            for (AbstractApplication openedApp : this.openedApps) {
                TerminalRegistry.getAppHardwareDemand(openedApp.getRegistryName(), openedApp.getAppTier()).stream().filter(i -> i instanceof BatteryHardware).findFirst().ifPresent(battery -> {
                    costs.addAndGet(((BatteryHardware)battery).getCharge());
                    charged.add(openedApp);
                });
            }
            for (DeviceHardware hardware : this.getHardware(DeviceHardware.class)) {
                if (hardware.getDevice() != DeviceHardware.DEVICE.SOLAR_LV) continue;
                costs.addAndGet(-200L);
            }
            if (costs.get() > 0L && electricItem.discharge(costs.get(), 999, true, false, false) != costs.get()) {
                charged.forEach(app -> this.closeApplication((AbstractApplication)app, false));
            } else if (costs.get() < 0L) {
                electricItem.charge(-costs.get(), 999, true, false);
            }
            return electricItem.getCharge();
        }
        return this.lastCharge;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if ((this.focusApp == null || this.focusApp.canOpenMenuOnEdge()) && TerminalOSWidget.isMouseOver(position.x, position.y, 7, size.height, mouseX, mouseY)) {
            if (this.menu.isHide && !this.showMenuHover) {
                this.menu.showMenu();
                this.showMenuHover = true;
            }
        } else if (!this.menu.isHide && this.showMenuHover && !TerminalOSWidget.isMouseOver(position.x - 10, position.y, 41, size.height, mouseX, mouseY)) {
            this.menu.hideMenu();
            this.showMenuHover = false;
        }
        if (this.background != null) {
            this.background.draw(position.x, position.y, size.width, size.height);
        } else {
            TerminalOSWidget.drawGradientRect(position.x, position.y, size.width, size.height, -1, -1);
        }
        if (this.maximize) {
            this.desktop.drawInBackground(mouseX, mouseY, partialTicks, context);
            if (this.menu.isVisible()) {
                this.menu.drawInBackground(mouseX, mouseY, partialTicks, context);
            }
        } else {
            RenderUtil.useScissor(position.x, position.y, size.width, size.height, () -> {
                this.desktop.drawInBackground(mouseX, mouseY, partialTicks, context);
                if (this.menu.isVisible()) {
                    this.menu.drawInBackground(mouseX, mouseY, partialTicks, context);
                }
            });
            TERMINAL_FRAME.draw(position.x - 12, position.y - 11, 380, 256);
        }
        this.home.drawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        if (this.waitShutdown && (keyCode == 1 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode))) {
            this.shutdown(true);
            return true;
        }
        if (super.keyTyped(charTyped, keyCode)) {
            return true;
        }
        if (keyCode == 1 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.waitShutdown = true;
            if (!OsSettings.DOUBLE_CHECK) {
                this.shutdown(true);
                return true;
            }
            TerminalDialogWidget.showConfirmDialog(this, "terminal.component.warning", "terminal.os.shutdown_confirm", result -> {
                if (result.booleanValue()) {
                    this.shutdown(true);
                } else {
                    this.waitShutdown = false;
                }
            }).setClientSide().open();
            return true;
        }
        this.waitShutdown = false;
        return false;
    }

    public boolean isMaximize() {
        return this.maximize;
    }

    private void updateOSSize() {
        int osWidth = this.getSize().width;
        int osHeight = this.getSize().height;
        if (this.maximize && (osWidth != this.gui.getScreenWidth() || osHeight != this.gui.getScreenHeight())) {
            osWidth = this.gui.getScreenWidth();
            osHeight = this.gui.getScreenHeight();
        } else if (!(this.maximize || osWidth == 333 && osHeight == 232)) {
            osWidth = 333;
            osHeight = 232;
        } else {
            return;
        }
        this.setSize(new Size(osWidth, osHeight));
        this.desktop.setSize(new Size(osWidth, osHeight));
        this.menu.setSize(new Size(31, osHeight));
        this.home.setSelfPosition(this.maximize ? new Position((osWidth - this.home.getSize().width) / 2, osHeight - this.home.getSize().height - 10) : new Position(340, 104));
        this.home.setIcon(this.maximize ? TERMINAL_HOME : null);
        this.gui.setSize(this.maximize ? osWidth : 380, this.maximize ? osHeight : 256);
        if (this.focusApp != null) {
            this.focusApp.onOSSizeUpdate(osWidth, osHeight);
        }
        for (Widget widget : this.desktop.widgets) {
            if (!(widget instanceof TerminalDialogWidget)) continue;
            ((TerminalDialogWidget)widget).onOSSizeUpdate(osWidth, osHeight);
        }
    }

    public void maximize(boolean isClient) {
        if (isClient) {
            this.maximize = !this.maximize;
            this.updateOSSize();
        }
    }

    @Override
    public void setParentPosition(Position parentPosition) {
        if (this.maximize) {
            super.setParentPosition(parentPosition.subtract(this.getSelfPosition()));
            if (this.isRemote()) {
                this.updateOSSize();
            }
        } else {
            super.setParentPosition(parentPosition);
        }
    }
}

