/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material;

import com.google.common.collect.HashBiMap;
import gregtech.api.GTValues;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.Material;
import net.minecraft.item.EnumDyeColor;

public class MarkerMaterials {
    public static final MarkerMaterial Empty = new MarkerMaterial("empty");

    public static void register() {
        Color.Colorless.toString();
        Tier.ULV.toString();
        Empty.toString();
    }

    public static class Component {
        public static final Material Resistor = new MarkerMaterial("resistor");
        public static final Material Transistor = new MarkerMaterial("transistor");
        public static final Material Capacitor = new MarkerMaterial("capacitor");
        public static final Material Diode = new MarkerMaterial("diode");
        public static final Material Inductor = new MarkerMaterial("inductor");
    }

    public static class Tier {
        public static final Material ULV = new MarkerMaterial(GTValues.VN[0].toLowerCase());
        public static final Material LV = new MarkerMaterial(GTValues.VN[1].toLowerCase());
        public static final Material MV = new MarkerMaterial(GTValues.VN[2].toLowerCase());
        public static final Material HV = new MarkerMaterial(GTValues.VN[3].toLowerCase());
        public static final Material EV = new MarkerMaterial(GTValues.VN[4].toLowerCase());
        public static final Material IV = new MarkerMaterial(GTValues.VN[5].toLowerCase());
        public static final Material LuV = new MarkerMaterial(GTValues.VN[6].toLowerCase());
        public static final Material ZPM = new MarkerMaterial(GTValues.VN[7].toLowerCase());
        public static final Material UV = new MarkerMaterial(GTValues.VN[8].toLowerCase());
        public static final Material UHV = new MarkerMaterial(GTValues.VN[9].toLowerCase());
        public static final Material UEV = new MarkerMaterial(GTValues.VN[10].toLowerCase());
        public static final Material UIV = new MarkerMaterial(GTValues.VN[11].toLowerCase());
        public static final Material UXV = new MarkerMaterial(GTValues.VN[12].toLowerCase());
        public static final Material OpV = new MarkerMaterial(GTValues.VN[13].toLowerCase());
        public static final Material MAX = new MarkerMaterial(GTValues.VN[14].toLowerCase());
    }

    public static class Color {
        public static final MarkerMaterial Colorless = new MarkerMaterial("colorless");
        public static final MarkerMaterial White = new MarkerMaterial("white");
        public static final MarkerMaterial Orange = new MarkerMaterial("orange");
        public static final MarkerMaterial Magenta = new MarkerMaterial("magenta");
        public static final MarkerMaterial LightBlue = new MarkerMaterial("light_blue");
        public static final MarkerMaterial Yellow = new MarkerMaterial("yellow");
        public static final MarkerMaterial Lime = new MarkerMaterial("lime");
        public static final MarkerMaterial Pink = new MarkerMaterial("pink");
        public static final MarkerMaterial Gray = new MarkerMaterial("gray");
        public static final MarkerMaterial LightGray = new MarkerMaterial("light_gray");
        public static final MarkerMaterial Cyan = new MarkerMaterial("cyan");
        public static final MarkerMaterial Purple = new MarkerMaterial("purple");
        public static final MarkerMaterial Blue = new MarkerMaterial("blue");
        public static final MarkerMaterial Brown = new MarkerMaterial("brown");
        public static final MarkerMaterial Green = new MarkerMaterial("green");
        public static final MarkerMaterial Red = new MarkerMaterial("red");
        public static final MarkerMaterial Black = new MarkerMaterial("black");
        public static final MarkerMaterial[] VALUES = new MarkerMaterial[]{White, Orange, Magenta, LightBlue, Yellow, Lime, Pink, Gray, LightGray, Cyan, Purple, Blue, Brown, Green, Red, Black};
        public static final HashBiMap<EnumDyeColor, MarkerMaterial> COLORS = HashBiMap.create();

        public static MarkerMaterial valueOf(String string) {
            for (MarkerMaterial color : VALUES) {
                if (!color.toString().equals(string)) continue;
                return color;
            }
            return null;
        }

        static {
            for (EnumDyeColor color : EnumDyeColor.values()) {
                COLORS.put((Object)color, (Object)Color.valueOf(color.func_176610_l()));
            }
        }
    }
}

