/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.fluidType.FluidType;
import gregtech.api.unification.Element;
import gregtech.api.unification.Elements;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PlasmaProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.RotorProperty;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.SmallDigits;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenClass(value="mods.gregtech.material.Material")
@ZenRegister
public class Material
implements Comparable<Material> {
    @Nonnull
    private final MaterialInfo materialInfo;
    @Nonnull
    private final MaterialProperties properties;
    @Nonnull
    private final MaterialFlags flags;
    private String chemicalFormula;

    private String calculateChemicalFormula() {
        if (this.chemicalFormula != null) {
            return this.chemicalFormula;
        }
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getSymbol();
        }
        if (!this.materialInfo.componentList.isEmpty()) {
            StringBuilder components = new StringBuilder();
            for (MaterialStack component : this.materialInfo.componentList) {
                components.append(component.toString());
            }
            return components.toString();
        }
        return "";
    }

    @ZenGetter
    public String getChemicalFormula() {
        return this.chemicalFormula;
    }

    @ZenMethod
    public Material setFormula(String formula) {
        return this.setFormula(formula, false);
    }

    @ZenMethod
    public Material setFormula(String formula, boolean withFormatting) {
        this.chemicalFormula = withFormatting ? SmallDigits.toSmallDownNumbers(formula) : formula;
        return this;
    }

    public ImmutableList<MaterialStack> getMaterialComponents() {
        return this.materialInfo.componentList;
    }

    @ZenGetter(value="components")
    public MaterialStack[] getMaterialComponentsCt() {
        return (MaterialStack[])this.getMaterialComponents().toArray((Object[])new MaterialStack[0]);
    }

    private Material(@Nonnull MaterialInfo materialInfo, @Nonnull MaterialProperties properties, @Nonnull MaterialFlags flags) {
        this.materialInfo = materialInfo;
        this.properties = properties;
        this.flags = flags;
        this.properties.setMaterial(this);
        this.registerMaterial();
    }

    protected Material(String name) {
        this.materialInfo = new MaterialInfo(0, name);
        this.materialInfo.iconSet = MaterialIconSet.DULL;
        this.properties = new MaterialProperties();
        this.flags = new MaterialFlags();
    }

    protected void registerMaterial() {
        this.verifyMaterial();
        GregTechAPI.MATERIAL_REGISTRY.register(this);
    }

    public void addFlags(MaterialFlag ... flags) {
        if (GregTechAPI.MATERIAL_REGISTRY.isFrozen()) {
            throw new IllegalStateException("Cannot add flag to material when registry is frozen!");
        }
        this.flags.addFlags(flags).verify(this);
    }

    @ZenMethod
    public void addFlags(String ... names) {
        this.addFlags((MaterialFlag[])Arrays.stream(names).map(MaterialFlag::getByName).filter(Objects::nonNull).toArray(MaterialFlag[]::new));
    }

    public boolean hasFlag(MaterialFlag flag) {
        return this.flags.hasFlag(flag);
    }

    public boolean hasFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).allMatch(this::hasFlag);
    }

    public boolean hasAnyOfFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).anyMatch(this::hasFlag);
    }

    protected void calculateDecompositionType() {
        if (!(this.materialInfo.componentList.isEmpty() || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING) || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) || this.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION))) {
            boolean onlyMetalMaterials = true;
            for (MaterialStack materialStack : this.materialInfo.componentList) {
                Material material = materialStack.material;
                onlyMetalMaterials &= material.hasProperty(PropertyKey.INGOT);
            }
            if (onlyMetalMaterials) {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING);
            } else {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING);
            }
        }
    }

    public Fluid getFluid() {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.materialInfo.name + " does not have a Fluid!");
        }
        Fluid fluid = prop.getFluid();
        if (fluid == null) {
            GTLog.logger.warn("Material {} Fluid was null!", (Object)this);
        }
        return fluid;
    }

    public FluidStack getFluid(int amount) {
        return new FluidStack(this.getFluid(), amount);
    }

    public int getBlockHarvestLevel() {
        if (!this.hasProperty(PropertyKey.DUST)) {
            throw new IllegalArgumentException("Material " + this.materialInfo.name + " does not have a harvest level! Is probably a Fluid");
        }
        int harvestLevel = this.getProperty(PropertyKey.DUST).getHarvestLevel();
        return harvestLevel > 0 ? harvestLevel - 1 : harvestLevel;
    }

    public int getToolHarvestLevel() {
        if (!this.hasProperty(PropertyKey.TOOL)) {
            throw new IllegalArgumentException("Material " + this.materialInfo.name + " does not have a tool harvest level! Is probably not a Tool Material");
        }
        return this.getProperty(PropertyKey.TOOL).getToolHarvestLevel();
    }

    @ZenMethod
    public void setMaterialRGB(int materialRGB) {
        this.materialInfo.color = materialRGB;
    }

    @ZenGetter(value="materialRGB")
    public int getMaterialRGB() {
        return this.materialInfo.color;
    }

    @ZenGetter(value="hasFluidColor")
    public boolean hasFluidColor() {
        return this.materialInfo.hasFluidColor;
    }

    public void setMaterialIconSet(MaterialIconSet materialIconSet) {
        this.materialInfo.iconSet = materialIconSet;
    }

    public MaterialIconSet getMaterialIconSet() {
        return this.materialInfo.iconSet;
    }

    @ZenGetter(value="radioactive")
    public boolean isRadioactive() {
        if (this.materialInfo.element != null) {
            return ((MaterialInfo)this.materialInfo).element.halfLifeSeconds >= 0L;
        }
        for (MaterialStack material : this.materialInfo.componentList) {
            if (!material.material.isRadioactive()) continue;
            return true;
        }
        return false;
    }

    @ZenGetter(value="protons")
    public long getProtons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getProtons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return Math.max(1L, Elements.Tc.getProtons());
        }
        long totalProtons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount;
            totalProtons += material.amount * material.material.getProtons();
        }
        return totalProtons / totalAmount;
    }

    @ZenGetter(value="neutrons")
    public long getNeutrons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getNeutrons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return Elements.Tc.getNeutrons();
        }
        long totalNeutrons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount;
            totalNeutrons += material.amount * material.material.getNeutrons();
        }
        return totalNeutrons / totalAmount;
    }

    @ZenGetter(value="mass")
    public long getMass() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getMass();
        }
        if (this.materialInfo.componentList.size() <= 0) {
            return Elements.Tc.getMass();
        }
        long totalMass = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount;
            totalMass += material.amount * material.material.getMass();
        }
        return totalMass / totalAmount;
    }

    @ZenGetter(value="blastTemperature")
    public int getBlastTemperature() {
        BlastProperty prop = this.properties.getProperty(PropertyKey.BLAST);
        return prop == null ? 0 : prop.getBlastTemperature();
    }

    public FluidStack getPlasma(int amount) {
        PlasmaProperty prop = this.properties.getProperty(PropertyKey.PLASMA);
        return prop == null ? null : prop.getPlasma(amount);
    }

    @ZenGetter(value="camelCaseName")
    public String toCamelCaseString() {
        return GTUtility.lowerUnderscoreToUpperCamel(this.toString());
    }

    @ZenGetter(value="unlocalizedName")
    public String getUnlocalizedName() {
        return "material." + this.materialInfo.name;
    }

    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return LocalizationUtils.format(this.getUnlocalizedName(), new Object[0]);
    }

    @Override
    @ZenMethod
    public int compareTo(Material material) {
        return this.toString().compareTo(material.toString());
    }

    @ZenGetter(value="name")
    public String toString() {
        return this.materialInfo.name;
    }

    public int getId() {
        return this.materialInfo.metaItemSubId;
    }

    @ZenOperator(value=OperatorType.MUL)
    public MaterialStack createMaterialStack(long amount) {
        return new MaterialStack(this, amount);
    }

    @Nonnull
    public MaterialProperties getProperties() {
        return this.properties;
    }

    public <T extends IMaterialProperty<T>> boolean hasProperty(PropertyKey<T> key) {
        return this.getProperty(key) != null;
    }

    public <T extends IMaterialProperty<T>> T getProperty(PropertyKey<T> key) {
        return this.properties.getProperty(key);
    }

    public <T extends IMaterialProperty<T>> void setProperty(PropertyKey<T> key, IMaterialProperty<T> property) {
        if (GregTechAPI.MATERIAL_REGISTRY.isFrozen()) {
            throw new IllegalStateException("Cannot add properties to a Material when registry is frozen!");
        }
        this.properties.setProperty(key, property);
        this.properties.verify();
    }

    public boolean isSolid() {
        return this.hasProperty(PropertyKey.INGOT) || this.hasProperty(PropertyKey.GEM);
    }

    public boolean hasFluid() {
        return this.hasProperty(PropertyKey.FLUID);
    }

    public void verifyMaterial() {
        this.properties.verify();
        this.flags.verify(this);
        this.chemicalFormula = this.calculateChemicalFormula();
        this.calculateDecompositionType();
    }

    private static class MaterialInfo {
        private final String name;
        private final int metaItemSubId;
        private int color = -1;
        private boolean hasFluidColor = true;
        private MaterialIconSet iconSet;
        private ImmutableList<MaterialStack> componentList;
        private Element element;

        private MaterialInfo(int metaItemSubId, String name) {
            this.metaItemSubId = metaItemSubId;
            if (!GTUtility.toLowerCaseUnderscore(GTUtility.lowerUnderscoreToUpperCamel(name)).equals(name)) {
                throw new IllegalStateException("Cannot add materials with names like 'materialnumber'! Use 'material_number' instead.");
            }
            this.name = name;
        }

        private void verifyInfo(MaterialProperties p, boolean averageRGB) {
            if (this.iconSet == null) {
                this.iconSet = p.hasProperty(PropertyKey.GEM) ? MaterialIconSet.GEM_VERTICAL : (p.hasProperty(PropertyKey.DUST) || p.hasProperty(PropertyKey.INGOT) || p.hasProperty(PropertyKey.POLYMER) ? MaterialIconSet.DULL : (p.hasProperty(PropertyKey.FLUID) ? (p.getProperty(PropertyKey.FLUID).isGas() ? MaterialIconSet.GAS : MaterialIconSet.FLUID) : (p.hasProperty(PropertyKey.PLASMA) ? MaterialIconSet.FLUID : MaterialIconSet.DULL)));
            }
            if (this.color == -1) {
                if (!averageRGB || this.componentList.isEmpty()) {
                    this.color = 0xFFFFFF;
                } else {
                    long colorTemp = 0L;
                    int divisor = 0;
                    for (MaterialStack stack : this.componentList) {
                        colorTemp += (long)stack.material.getMaterialRGB() * stack.amount;
                        divisor = (int)((long)divisor + stack.amount);
                    }
                    this.color = (int)(colorTemp / (long)divisor);
                }
            }
        }
    }

    public static class Builder {
        private final MaterialInfo materialInfo;
        private final MaterialProperties properties;
        private final MaterialFlags flags;
        private List<MaterialStack> composition = new ArrayList<MaterialStack>();
        private boolean averageRGB = false;

        public Builder(int id, String name) {
            if (name.charAt(name.length() - 1) == '_') {
                throw new IllegalArgumentException("Material name cannot end with a '_'!");
            }
            this.materialInfo = new MaterialInfo(id, name);
            this.properties = new MaterialProperties();
            this.flags = new MaterialFlags();
        }

        public Builder fluid() {
            this.properties.ensureSet(PropertyKey.FLUID);
            return this;
        }

        public Builder fluid(FluidType type) {
            return this.fluid(type, false);
        }

        public Builder fluid(FluidType type, boolean hasBlock) {
            this.properties.setProperty(PropertyKey.FLUID, new FluidProperty(type, hasBlock));
            return this;
        }

        public Builder plasma() {
            this.properties.ensureSet(PropertyKey.PLASMA);
            return this;
        }

        public Builder dust() {
            this.properties.ensureSet(PropertyKey.DUST);
            return this;
        }

        public Builder dust(int harvestLevel) {
            return this.dust(harvestLevel, 0);
        }

        public Builder dust(int harvestLevel, int burnTime) {
            this.properties.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
            return this;
        }

        public Builder ingot() {
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder ingot(int harvestLevel) {
            return this.ingot(harvestLevel, 0);
        }

        public Builder ingot(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder gem() {
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder gem(int harvestLevel) {
            return this.gem(harvestLevel, 0);
        }

        public Builder gem(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder polymer() {
            this.properties.ensureSet(PropertyKey.POLYMER);
            return this;
        }

        public Builder polymer(int harvestLevel) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, 0);
            } else if (prop.getHarvestLevel() == 2) {
                prop.setHarvestLevel(harvestLevel);
            }
            this.properties.ensureSet(PropertyKey.POLYMER);
            this.properties.ensureSet(PropertyKey.FLUID);
            return this;
        }

        public Builder burnTime(int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust();
                prop = this.properties.getProperty(PropertyKey.DUST);
            }
            prop.setBurnTime(burnTime);
            return this;
        }

        public Builder color(int color) {
            this.color(color, true);
            return this;
        }

        public Builder color(int color, boolean hasFluidColor) {
            this.materialInfo.color = color;
            this.materialInfo.hasFluidColor = hasFluidColor;
            return this;
        }

        public Builder colorAverage() {
            this.averageRGB = true;
            return this;
        }

        public Builder iconSet(MaterialIconSet iconSet) {
            this.materialInfo.iconSet = iconSet;
            return this;
        }

        public Builder components(Object ... components) {
            Preconditions.checkArgument((components.length % 2 == 0 ? 1 : 0) != 0, (Object)"Material Components list malformed!");
            for (int i = 0; i < components.length; i += 2) {
                if (components[i] == null) {
                    throw new IllegalArgumentException("Material in Components List is null for Material " + this.materialInfo.name);
                }
                this.composition.add(new MaterialStack((Material)components[i], ((Integer)components[i + 1]).intValue()));
            }
            return this;
        }

        public Builder components(ImmutableList<MaterialStack> components) {
            this.composition = components;
            return this;
        }

        public Builder flags(MaterialFlag ... flags) {
            this.flags.addFlags(flags);
            return this;
        }

        public Builder flags(Collection<MaterialFlag> f1, MaterialFlag ... f2) {
            this.flags.addFlags(f1.toArray(new MaterialFlag[0]));
            this.flags.addFlags(f2);
            return this;
        }

        public Builder element(Element element) {
            this.materialInfo.element = element;
            return this;
        }

        public Builder toolStats(ToolProperty toolProperty) {
            this.properties.setProperty(PropertyKey.TOOL, toolProperty);
            return this;
        }

        public Builder rotorStats(float speed, float damage, int durability) {
            this.properties.setProperty(PropertyKey.ROTOR, new RotorProperty(speed, damage, durability));
            return this;
        }

        public Builder blastTemp(int temp) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp));
            return this;
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier, -1, -1));
            return this;
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier, eutOverride, -1));
            return this;
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride, int durationOverride) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier, eutOverride, durationOverride));
            return this;
        }

        public Builder ore() {
            this.properties.ensureSet(PropertyKey.ORE);
            return this;
        }

        public Builder ore(boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(1, 1, emissive));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier, boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier, emissive));
            return this;
        }

        public Builder fluidTemp(int temp) {
            this.properties.ensureSet(PropertyKey.FLUID);
            this.properties.getProperty(PropertyKey.FLUID).setFluidTemperature(temp);
            return this;
        }

        public Builder washedIn(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m);
            return this;
        }

        public Builder washedIn(Material m, int washedAmount) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m, washedAmount);
            return this;
        }

        public Builder separatedInto(Material ... m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setSeparatedInto(m);
            return this;
        }

        public Builder oreSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setDirectSmeltResult(m);
            return this;
        }

        public Builder polarizesInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMagneticMaterial(m);
            return this;
        }

        public Builder arcSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setArcSmeltingInto(m);
            return this;
        }

        public Builder macerateInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMacerateInto(m);
            return this;
        }

        public Builder ingotSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setSmeltingInto(m);
            return this;
        }

        public Builder addOreByproducts(Material ... byproducts) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setOreByProducts(byproducts);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss) {
            this.cableProperties((int)voltage, amperage, loss, false);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon) {
            this.properties.ensureSet(PropertyKey.DUST);
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties((int)voltage, amperage, loss, isSuperCon));
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon, int criticalTemperature) {
            this.properties.ensureSet(PropertyKey.DUST);
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties((int)voltage, amperage, loss, isSuperCon, criticalTemperature));
            return this;
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof) {
            return this.fluidPipeProperties(maxTemp, throughput, gasProof, false, false, false);
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.setProperty(PropertyKey.FLUID_PIPE, new FluidPipeProperties(maxTemp, throughput, gasProof, acidProof, cryoProof, plasmaProof));
            return this;
        }

        public Builder itemPipeProperties(int priority, float stacksPerSec) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.setProperty(PropertyKey.ITEM_PIPE, new ItemPipeProperties(priority, stacksPerSec));
            return this;
        }

        @Deprecated
        public Builder addDefaultEnchant(Enchantment enchant, int level) {
            if (!this.properties.hasProperty(PropertyKey.TOOL)) {
                throw new IllegalArgumentException("Material cannot have an Enchant without Tools!");
            }
            this.properties.getProperty(PropertyKey.TOOL).addEnchantmentForTools(enchant, level);
            return this;
        }

        public Material build() {
            this.materialInfo.componentList = ImmutableList.copyOf(this.composition);
            this.materialInfo.verifyInfo(this.properties, this.averageRGB);
            return new Material(this.materialInfo, this.properties, this.flags);
        }
    }
}

