/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.ore;

import com.google.common.base.Preconditions;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.IOreRegistrationHandler;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.function.TriConsumer;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.Validate;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.ore.OrePrefix")
@ZenRegister
public class OrePrefix {
    private static final Map<String, OrePrefix> PREFIXES = new HashMap<String, OrePrefix>();
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    public static final OrePrefix ore = new OrePrefix("ore", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreGranite = new OrePrefix("oreGranite", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreDiorite = new OrePrefix("oreDiorite", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreAndesite = new OrePrefix("oreAndesite", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreBlackgranite = new OrePrefix("oreBlackgranite", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreRedgranite = new OrePrefix("oreRedgranite", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreMarble = new OrePrefix("oreMarble", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreBasalt = new OrePrefix("oreBasalt", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreSand = new OrePrefix("oreSand", -1L, null, MaterialIconType.ore, 1L, null);
    public static final OrePrefix oreRedSand = new OrePrefix("oreRedSand", -1L, null, MaterialIconType.ore, 1L, null);
    public static final OrePrefix oreNetherrack = new OrePrefix("oreNetherrack", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix oreEndstone = new OrePrefix("oreEndstone", -1L, null, MaterialIconType.ore, 1L, Conditions.hasOreProperty);
    public static final OrePrefix crushedCentrifuged = new OrePrefix("crushedCentrifuged", -1L, null, MaterialIconType.crushedCentrifuged, 1L, Conditions.hasOreProperty);
    public static final OrePrefix crushedPurified = new OrePrefix("crushedPurified", -1L, null, MaterialIconType.crushedPurified, 1L, Conditions.hasOreProperty);
    public static final OrePrefix crushed = new OrePrefix("crushed", -1L, null, MaterialIconType.crushed, 1L, Conditions.hasOreProperty, mat -> Collections.singletonList(I18n.func_135052_a((String)"metaitem.crushed.tooltip.purify", (Object[])new Object[0])));
    public static final OrePrefix shard = new OrePrefix("shard", -1L, null, null, 1L, null);
    public static final OrePrefix clump = new OrePrefix("clump", -1L, null, null, 1L, null);
    public static final OrePrefix reduced = new OrePrefix("reduced", -1L, null, null, 1L, null);
    public static final OrePrefix crystalline = new OrePrefix("crystalline", -1L, null, null, 1L, null);
    public static final OrePrefix cleanGravel = new OrePrefix("cleanGravel", -1L, null, null, 1L, null);
    public static final OrePrefix dirtyGravel = new OrePrefix("dirtyGravel", -1L, null, null, 1L, null);
    public static final OrePrefix ingotHot = new OrePrefix("ingotHot", 3628800L, null, MaterialIconType.ingotHot, 1L, Conditions.hasBlastProperty.and(mat -> mat.getProperty(PropertyKey.BLAST).getBlastTemperature() > 1750));
    public static final OrePrefix ingot = new OrePrefix("ingot", 3628800L, null, MaterialIconType.ingot, 1L, Conditions.hasIngotProperty);
    public static final OrePrefix gem = new OrePrefix("gem", 3628800L, null, MaterialIconType.gem, 1L, Conditions.hasGemProperty);
    public static final OrePrefix gemChipped = new OrePrefix("gemChipped", 907200L, null, MaterialIconType.gemChipped, 1L, Conditions.hasGemProperty.and(unused -> ConfigHolder.recipes.generateLowQualityGems));
    public static final OrePrefix gemFlawed = new OrePrefix("gemFlawed", 1814400L, null, MaterialIconType.gemFlawed, 1L, Conditions.hasGemProperty.and(unused -> ConfigHolder.recipes.generateLowQualityGems));
    public static final OrePrefix gemFlawless = new OrePrefix("gemFlawless", 7257600L, null, MaterialIconType.gemFlawless, 1L, Conditions.hasGemProperty);
    public static final OrePrefix gemExquisite = new OrePrefix("gemExquisite", 14515200L, null, MaterialIconType.gemExquisite, 1L, Conditions.hasGemProperty);
    public static final OrePrefix dustSmall = new OrePrefix("dustSmall", 907200L, null, MaterialIconType.dustSmall, 1L, Conditions.hasDustProperty);
    public static final OrePrefix dustTiny = new OrePrefix("dustTiny", 403200L, null, MaterialIconType.dustTiny, 1L, Conditions.hasDustProperty);
    public static final OrePrefix dustImpure = new OrePrefix("dustImpure", 3628800L, null, MaterialIconType.dustImpure, 1L, Conditions.hasOreProperty, mat -> Collections.singletonList(I18n.func_135052_a((String)"metaitem.dust.tooltip.purify", (Object[])new Object[0])));
    public static final OrePrefix dustPure = new OrePrefix("dustPure", 3628800L, null, MaterialIconType.dustPure, 1L, Conditions.hasOreProperty, mat -> Collections.singletonList(I18n.func_135052_a((String)"metaitem.dust.tooltip.purify", (Object[])new Object[0])));
    public static final OrePrefix dust = new OrePrefix("dust", 3628800L, null, MaterialIconType.dust, 1L, Conditions.hasDustProperty);
    public static final OrePrefix nugget = new OrePrefix("nugget", 403200L, null, MaterialIconType.nugget, 1L, Conditions.hasIngotProperty);
    public static final OrePrefix plateDense = new OrePrefix("plateDense", 32659200L, null, MaterialIconType.plateDense, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_DENSE) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final OrePrefix plateDouble = new OrePrefix("plateDouble", 7257600L, null, MaterialIconType.plateDouble, 1L, Conditions.hasIngotProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE) && !mat.hasFlag(MaterialFlags.NO_SMASHING)));
    public static final OrePrefix plate = new OrePrefix("plate", 3628800L, null, MaterialIconType.plate, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE));
    public static final OrePrefix round = new OrePrefix("round", 403200L, null, MaterialIconType.round, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_ROUND));
    public static final OrePrefix foil = new OrePrefix("foil", 907200L, null, MaterialIconType.foil, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_FOIL));
    public static final OrePrefix stickLong = new OrePrefix("stickLong", 3628800L, null, MaterialIconType.stickLong, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_LONG_ROD));
    public static final OrePrefix stick = new OrePrefix("stick", 1814400L, null, MaterialIconType.stick, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_ROD));
    public static final OrePrefix bolt = new OrePrefix("bolt", 453600L, null, MaterialIconType.bolt, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW));
    public static final OrePrefix screw = new OrePrefix("screw", 403200L, null, MaterialIconType.screw, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW));
    public static final OrePrefix ring = new OrePrefix("ring", 907200L, null, MaterialIconType.ring, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_RING));
    public static final OrePrefix springSmall = new OrePrefix("springSmall", 907200L, null, MaterialIconType.springSmall, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_SPRING_SMALL) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final OrePrefix spring = new OrePrefix("spring", 3628800L, null, MaterialIconType.spring, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_SPRING) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final OrePrefix wireFine = new OrePrefix("wireFine", 453600L, null, MaterialIconType.wireFine, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_FINE_WIRE));
    public static final OrePrefix rotor = new OrePrefix("rotor", 14515200L, null, MaterialIconType.rotor, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_ROTOR));
    public static final OrePrefix gearSmall = new OrePrefix("gearSmall", 3628800L, null, MaterialIconType.gearSmall, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_SMALL_GEAR));
    public static final OrePrefix gear = new OrePrefix("gear", 14515200L, null, MaterialIconType.gear, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_GEAR));
    public static final OrePrefix lens = new OrePrefix("lens", 2721600L, null, MaterialIconType.lens, 1L, mat -> mat.hasFlag(MaterialFlags.GENERATE_LENS));
    public static final OrePrefix toolHeadBuzzSaw = new OrePrefix("toolHeadBuzzSaw", 14515200L, null, MaterialIconType.toolHeadBuzzSaw, 1L, Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final OrePrefix toolHeadScrewdriver = new OrePrefix("toolHeadScrewdriver", 3628800L, null, MaterialIconType.toolHeadScrewdriver, 1L, Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_LONG_ROD)));
    public static final OrePrefix toolHeadDrill = new OrePrefix("toolHeadDrill", 14515200L, null, MaterialIconType.toolHeadDrill, 1L, Conditions.hasToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final OrePrefix toolHeadChainsaw = new OrePrefix("toolHeadChainsaw", 7257600L, null, MaterialIconType.toolHeadChainsaw, 1L, Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final OrePrefix toolHeadWrench = new OrePrefix("toolHeadWrench", 14515200L, null, MaterialIconType.toolHeadWrench, 1L, Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final OrePrefix turbineBlade = new OrePrefix("turbineBlade", 36288000L, null, MaterialIconType.turbineBlade, 1L, Conditions.hasRotorProperty.and(m -> m.hasFlags(MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.GENERATE_PLATE) && !m.hasProperty(PropertyKey.GEM)));
    public static final OrePrefix paneGlass = new OrePrefix("paneGlass", -1L, MarkerMaterials.Color.Colorless, null, 2L, null);
    public static final OrePrefix blockGlass = new OrePrefix("blockGlass", -1L, MarkerMaterials.Color.Colorless, null, 2L, null);
    public static final OrePrefix block = new OrePrefix("block", 32659200L, null, MaterialIconType.block, 1L, null);
    public static final OrePrefix log = new OrePrefix("log", -1L, null, null, 0L, null);
    public static final OrePrefix plank = new OrePrefix("plank", -1L, null, null, 0L, null);
    public static final OrePrefix stone = new OrePrefix("stone", -1L, Materials.Stone, null, 2L, null);
    public static final OrePrefix frameGt = new OrePrefix("frameGt", 7257600L, null, null, 1L, material -> material.hasFlag(MaterialFlags.GENERATE_FRAME));
    public static final OrePrefix pipeTinyFluid = new OrePrefix("pipeTinyFluid", 1814400L, null, null, 1L, null);
    public static final OrePrefix pipeSmallFluid = new OrePrefix("pipeSmallFluid", 3628800L, null, null, 1L, null);
    public static final OrePrefix pipeNormalFluid = new OrePrefix("pipeNormalFluid", 10886400L, null, null, 1L, null);
    public static final OrePrefix pipeLargeFluid = new OrePrefix("pipeLargeFluid", 21772800L, null, null, 1L, null);
    public static final OrePrefix pipeHugeFluid = new OrePrefix("pipeHugeFluid", 43545600L, null, null, 1L, null);
    public static final OrePrefix pipeQuadrupleFluid = new OrePrefix("pipeQuadrupleFluid", 14515200L, null, null, 1L, null);
    public static final OrePrefix pipeNonupleFluid = new OrePrefix("pipeNonupleFluid", 32659200L, null, null, 1L, null);
    public static final OrePrefix pipeTinyItem = new OrePrefix("pipeTinyItem", 1814400L, null, null, 1L, null);
    public static final OrePrefix pipeSmallItem = new OrePrefix("pipeSmallItem", 3628800L, null, null, 1L, null);
    public static final OrePrefix pipeNormalItem = new OrePrefix("pipeNormalItem", 10886400L, null, null, 1L, null);
    public static final OrePrefix pipeLargeItem = new OrePrefix("pipeLargeItem", 21772800L, null, null, 1L, null);
    public static final OrePrefix pipeHugeItem = new OrePrefix("pipeHugeItem", 43545600L, null, null, 1L, null);
    public static final OrePrefix pipeSmallRestrictive = new OrePrefix("pipeSmallRestrictive", 3628800L, null, null, 1L, null);
    public static final OrePrefix pipeNormalRestrictive = new OrePrefix("pipeNormalRestrictive", 10886400L, null, null, 1L, null);
    public static final OrePrefix pipeLargeRestrictive = new OrePrefix("pipeLargeRestrictive", 21772800L, null, null, 1L, null);
    public static final OrePrefix pipeHugeRestrictive = new OrePrefix("pipeHugeRestrictive", 43545600L, null, null, 1L, null);
    public static final OrePrefix wireGtHex = new OrePrefix("wireGtHex", 29030400L, null, null, 1L, null);
    public static final OrePrefix wireGtOctal = new OrePrefix("wireGtOctal", 14515200L, null, null, 1L, null);
    public static final OrePrefix wireGtQuadruple = new OrePrefix("wireGtQuadruple", 7257600L, null, null, 1L, null);
    public static final OrePrefix wireGtDouble = new OrePrefix("wireGtDouble", 3628800L, null, null, 1L, null);
    public static final OrePrefix wireGtSingle = new OrePrefix("wireGtSingle", 1814400L, null, null, 1L, null);
    public static final OrePrefix cableGtHex = new OrePrefix("cableGtHex", 29030400L, null, null, 1L, null);
    public static final OrePrefix cableGtOctal = new OrePrefix("cableGtOctal", 14515200L, null, null, 1L, null);
    public static final OrePrefix cableGtQuadruple = new OrePrefix("cableGtQuadruple", 7257600L, null, null, 1L, null);
    public static final OrePrefix cableGtDouble = new OrePrefix("cableGtDouble", 3628800L, null, null, 1L, null);
    public static final OrePrefix cableGtSingle = new OrePrefix("cableGtSingle", 1814400L, null, null, 1L, null);
    public static final OrePrefix craftingLens = new OrePrefix("craftingLens", -1L, null, null, 0L, null);
    public static final OrePrefix dye = new OrePrefix("dye", -1L, null, null, 0L, null);
    public static final OrePrefix battery = new OrePrefix("battery", -1L, null, null, 0L, null);
    public static final OrePrefix circuit = new OrePrefix("circuit", -1L, null, null, 1L, null);
    public static final OrePrefix component = new OrePrefix("component", -1L, null, null, 1L, null);
    public final String name;
    public final int id;
    public final boolean isUnificationEnabled;
    public final boolean isSelfReferencing;
    @Nullable
    private Predicate<Material> generationCondition;
    @Nullable
    public final MaterialIconType materialIconType;
    private final long materialAmount;
    @Nullable
    public Material materialType;
    private final List<IOreRegistrationHandler> oreProcessingHandlers = new ArrayList<IOreRegistrationHandler>();
    private final Set<Material> ignoredMaterials = new HashSet<Material>();
    private final Set<Material> generatedMaterials = new HashSet<Material>();
    private boolean isMarkerPrefix = false;
    public byte maxStackSize = (byte)64;
    public final List<MaterialStack> secondaryMaterials = new ArrayList<MaterialStack>();
    public Function<Integer, Float> heatDamageFunction = null;
    public Function<Material, List<String>> tooltipFunc;
    private String alternativeOreName = null;
    private static final ThreadLocal<OrePrefix> currentProcessingPrefix;
    private static final ThreadLocal<Material> currentMaterial;

    private static void excludeAllGems(Material material) {
        gem.setIgnored(material);
        OrePrefix.excludeAllGemsButNormal(material);
    }

    private static void excludeAllGemsButNormal(Material material) {
        gemChipped.setIgnored(material);
        gemFlawed.setIgnored(material);
        gemFlawless.setIgnored(material);
        gemExquisite.setIgnored(material);
    }

    public OrePrefix(String name, long materialAmount, @Nullable Material material, @Nullable MaterialIconType materialIconType, long flags, @Nullable Predicate<Material> condition) {
        this(name, materialAmount, material, materialIconType, flags, condition, null);
    }

    public OrePrefix(String name, long materialAmount, @Nullable Material material, @Nullable MaterialIconType materialIconType, long flags, @Nullable Predicate<Material> condition, @Nullable Function<Material, List<String>> tooltipFunc) {
        Preconditions.checkArgument((!PREFIXES.containsKey(name) ? 1 : 0) != 0, (Object)("OrePrefix " + name + " already registered!"));
        this.name = name;
        this.id = idCounter.getAndIncrement();
        this.materialAmount = materialAmount;
        this.isSelfReferencing = (flags & 2L) != 0L;
        this.isUnificationEnabled = (flags & 1L) != 0L;
        this.materialIconType = materialIconType;
        this.generationCondition = condition;
        this.tooltipFunc = tooltipFunc;
        if (this.isSelfReferencing) {
            Preconditions.checkNotNull((Object)material, (Object)"Material is null for self-referencing OrePrefix");
            this.materialType = material;
        }
        PREFIXES.put(name, this);
    }

    public String name() {
        return this.name;
    }

    public void addSecondaryMaterial(MaterialStack secondaryMaterial) {
        Preconditions.checkNotNull((Object)secondaryMaterial, (Object)"secondaryMaterial");
        this.secondaryMaterials.add(secondaryMaterial);
    }

    public void setMarkerPrefix(boolean isMarkerPrefix) {
        this.isMarkerPrefix = isMarkerPrefix;
    }

    public long getMaterialAmount(@Nullable Material material) {
        if (material == null) {
            return this.materialAmount;
        }
        if (this == block) {
            if (material == Materials.Glowstone || material == Materials.NetherQuartz || material == Materials.Brick || material == Materials.Clay) {
                return 14515200L;
            }
            if (material == Materials.Glass || material == Materials.Ice || material == Materials.Obsidian || material == Materials.Concrete) {
                return 3628800L;
            }
        } else if (this == stick) {
            if (material == Materials.Blaze) {
                return 14515200L;
            }
            if (material == Materials.Bone) {
                return 18144000L;
            }
        }
        return this.materialAmount;
    }

    @ZenMethod
    public static OrePrefix getPrefix(String prefixName) {
        return OrePrefix.getPrefix(prefixName, null);
    }

    public static OrePrefix getPrefix(String prefixName, @Nullable OrePrefix replacement) {
        return PREFIXES.getOrDefault(prefixName, replacement);
    }

    public boolean doGenerateItem(Material material) {
        return !this.isSelfReferencing && !this.isIgnored(material) && (this.generationCondition == null || this.generationCondition.test(material));
    }

    public void setGenerationCondition(@Nullable Predicate<Material> in) {
        this.generationCondition = in;
    }

    public boolean addProcessingHandler(IOreRegistrationHandler ... processingHandler) {
        Preconditions.checkNotNull((Object)processingHandler);
        Validate.noNullElements((Object[])processingHandler);
        return this.oreProcessingHandlers.addAll(Arrays.asList(processingHandler));
    }

    public <T extends IMaterialProperty<T>> void addProcessingHandler(PropertyKey<T> propertyKey, TriConsumer<OrePrefix, Material, T> handler) {
        this.addProcessingHandler((orePrefix, material) -> {
            if (material.hasProperty(propertyKey) && !material.hasFlag(MaterialFlags.NO_UNIFICATION)) {
                handler.accept(orePrefix, material, material.getProperty(propertyKey));
            }
        });
    }

    public void processOreRegistration(@Nullable Material material) {
        if (this.isSelfReferencing && material == null) {
            material = this.materialType;
        }
        if (material != null) {
            this.generatedMaterials.add(material);
        }
    }

    public static void runMaterialHandlers() {
        for (OrePrefix orePrefix : PREFIXES.values()) {
            orePrefix.runGeneratedMaterialHandlers();
        }
    }

    public static OrePrefix getCurrentProcessingPrefix() {
        return currentProcessingPrefix.get();
    }

    public static Material getCurrentMaterial() {
        return currentMaterial.get();
    }

    private void runGeneratedMaterialHandlers() {
        currentProcessingPrefix.set(this);
        for (Material registeredMaterial : this.generatedMaterials) {
            currentMaterial.set(registeredMaterial);
            for (IOreRegistrationHandler registrationHandler : this.oreProcessingHandlers) {
                registrationHandler.processMaterial(this, registeredMaterial);
            }
            currentMaterial.set(null);
        }
        this.generatedMaterials.clear();
        currentProcessingPrefix.set(null);
    }

    public void setAlternativeOreName(String name) {
        this.alternativeOreName = name;
    }

    public String getAlternativeOreName() {
        return this.alternativeOreName;
    }

    public String getLocalNameForItem(Material material) {
        String specifiedUnlocalized = "item." + material.toString() + "." + this.name;
        if (LocalizationUtils.hasKey(specifiedUnlocalized)) {
            return LocalizationUtils.format(specifiedUnlocalized, new Object[0]);
        }
        String unlocalized = this.findUnlocalizedName(material);
        String matLocalized = material.getLocalizedName();
        String formatted = LocalizationUtils.format(unlocalized, matLocalized);
        return formatted.equals(unlocalized) ? matLocalized : formatted;
    }

    private String findUnlocalizedName(Material material) {
        String localizationKey;
        if (material.hasProperty(PropertyKey.POLYMER) && LocalizationUtils.hasKey(localizationKey = String.format("item.material.oreprefix.polymer.%s", this.name))) {
            return localizationKey;
        }
        return String.format("item.material.oreprefix.%s", this.name);
    }

    public boolean isIgnored(Material material) {
        return this.ignoredMaterials.contains(material);
    }

    @ZenMethod
    public void setIgnored(Material material) {
        this.ignoredMaterials.add(material);
    }

    public boolean isMarkerPrefix() {
        return this.isMarkerPrefix;
    }

    public boolean equals(Object o) {
        return o instanceof OrePrefix && ((OrePrefix)o).name.equals(this.name);
    }

    public static Collection<OrePrefix> values() {
        return PREFIXES.values();
    }

    public String toString() {
        return this.name + "/" + this.id;
    }

    static {
        OrePrefix.ingotHot.heatDamageFunction = temp -> Float.valueOf((float)(temp - 1750) / 1000.0f + 2.0f);
        OrePrefix.gemFlawless.maxStackSize = (byte)32;
        OrePrefix.gemExquisite.maxStackSize = (byte)16;
        OrePrefix.plateDouble.maxStackSize = (byte)32;
        OrePrefix.plateDense.maxStackSize = (byte)7;
        OrePrefix.rotor.maxStackSize = (byte)16;
        OrePrefix.gear.maxStackSize = (byte)16;
        OrePrefix.toolHeadBuzzSaw.maxStackSize = (byte)16;
        OrePrefix.toolHeadScrewdriver.maxStackSize = (byte)16;
        OrePrefix.toolHeadDrill.maxStackSize = (byte)16;
        OrePrefix.toolHeadChainsaw.maxStackSize = (byte)16;
        OrePrefix.toolHeadWrench.maxStackSize = (byte)16;
        craftingLens.setMarkerPrefix(true);
        dye.setMarkerPrefix(true);
        battery.setMarkerPrefix(true);
        circuit.setMarkerPrefix(true);
        gemExquisite.setIgnored(Materials.Sugar);
        gemFlawless.setIgnored(Materials.Sugar);
        gem.setIgnored(Materials.Diamond);
        gem.setIgnored(Materials.Emerald);
        gem.setIgnored(Materials.Lapis);
        gem.setIgnored(Materials.NetherQuartz);
        gem.setIgnored(Materials.Coal);
        OrePrefix.excludeAllGems(Materials.Charcoal);
        OrePrefix.excludeAllGems(Materials.NetherStar);
        OrePrefix.excludeAllGems(Materials.EnderPearl);
        OrePrefix.excludeAllGems(Materials.EnderEye);
        OrePrefix.excludeAllGems(Materials.Flint);
        OrePrefix.excludeAllGemsButNormal(Materials.Lapotron);
        dust.setIgnored(Materials.Redstone);
        dust.setIgnored(Materials.Glowstone);
        dust.setIgnored(Materials.Gunpowder);
        dust.setIgnored(Materials.Sugar);
        dust.setIgnored(Materials.Bone);
        dust.setIgnored(Materials.Blaze);
        stick.setIgnored(Materials.Wood);
        stick.setIgnored(Materials.Bone);
        stick.setIgnored(Materials.Blaze);
        stick.setIgnored(Materials.Paper);
        ingot.setIgnored(Materials.Iron);
        ingot.setIgnored(Materials.Gold);
        ingot.setIgnored(Materials.Wood);
        ingot.setIgnored(Materials.TreatedWood);
        ingot.setIgnored(Materials.Paper);
        nugget.setIgnored(Materials.Wood);
        nugget.setIgnored(Materials.TreatedWood);
        nugget.setIgnored(Materials.Gold);
        nugget.setIgnored(Materials.Paper);
        nugget.setIgnored(Materials.Iron);
        plate.setIgnored(Materials.Paper);
        block.setIgnored(Materials.Iron);
        block.setIgnored(Materials.Gold);
        block.setIgnored(Materials.Lapis);
        block.setIgnored(Materials.Emerald);
        block.setIgnored(Materials.Redstone);
        block.setIgnored(Materials.Diamond);
        block.setIgnored(Materials.Coal);
        block.setIgnored(Materials.Glass);
        block.setIgnored(Materials.Marble);
        block.setIgnored(Materials.GraniteRed);
        block.setIgnored(Materials.Stone);
        block.setIgnored(Materials.Glowstone);
        block.setIgnored(Materials.Endstone);
        block.setIgnored(Materials.Wheat);
        block.setIgnored(Materials.Oilsands);
        block.setIgnored(Materials.Wood);
        block.setIgnored(Materials.TreatedWood);
        block.setIgnored(Materials.RawRubber);
        block.setIgnored(Materials.Clay);
        block.setIgnored(Materials.Brick);
        block.setIgnored(Materials.Bone);
        block.setIgnored(Materials.NetherQuartz);
        block.setIgnored(Materials.Ice);
        block.setIgnored(Materials.Netherrack);
        block.setIgnored(Materials.Concrete);
        block.setIgnored(Materials.Blaze);
        block.setIgnored(Materials.Lapotron);
        ore.addSecondaryMaterial(new MaterialStack(Materials.Stone, OrePrefix.dust.materialAmount));
        oreNetherrack.addSecondaryMaterial(new MaterialStack(Materials.Netherrack, OrePrefix.dust.materialAmount));
        oreEndstone.addSecondaryMaterial(new MaterialStack(Materials.Endstone, OrePrefix.dust.materialAmount));
        if (ConfigHolder.worldgen.allUniqueStoneTypes) {
            oreGranite.addSecondaryMaterial(new MaterialStack(Materials.Granite, OrePrefix.dust.materialAmount));
            oreDiorite.addSecondaryMaterial(new MaterialStack(Materials.Diorite, OrePrefix.dust.materialAmount));
            oreAndesite.addSecondaryMaterial(new MaterialStack(Materials.Andesite, OrePrefix.dust.materialAmount));
            oreRedgranite.addSecondaryMaterial(new MaterialStack(Materials.GraniteRed, OrePrefix.dust.materialAmount));
            oreBlackgranite.addSecondaryMaterial(new MaterialStack(Materials.GraniteBlack, OrePrefix.dust.materialAmount));
            oreBasalt.addSecondaryMaterial(new MaterialStack(Materials.Basalt, OrePrefix.dust.materialAmount));
            oreMarble.addSecondaryMaterial(new MaterialStack(Materials.Marble, OrePrefix.dust.materialAmount));
            oreSand.addSecondaryMaterial(new MaterialStack(Materials.SiliconDioxide, OrePrefix.dustTiny.materialAmount));
            oreRedSand.addSecondaryMaterial(new MaterialStack(Materials.SiliconDioxide, OrePrefix.dustTiny.materialAmount));
        }
        crushed.addSecondaryMaterial(new MaterialStack(Materials.Stone, OrePrefix.dust.materialAmount));
        toolHeadDrill.addSecondaryMaterial(new MaterialStack(Materials.Steel, OrePrefix.plate.materialAmount * 4L));
        toolHeadChainsaw.addSecondaryMaterial(new MaterialStack(Materials.Steel, OrePrefix.plate.materialAmount * 4L + OrePrefix.ring.materialAmount * 2L));
        toolHeadWrench.addSecondaryMaterial(new MaterialStack(Materials.Steel, OrePrefix.ring.materialAmount + OrePrefix.screw.materialAmount * 2L));
        pipeTinyFluid.setIgnored(Materials.Wood);
        pipeHugeFluid.setIgnored(Materials.Wood);
        pipeQuadrupleFluid.setIgnored(Materials.Wood);
        pipeNonupleFluid.setIgnored(Materials.Wood);
        pipeTinyFluid.setIgnored(Materials.TreatedWood);
        pipeHugeFluid.setIgnored(Materials.TreatedWood);
        pipeQuadrupleFluid.setIgnored(Materials.TreatedWood);
        pipeNonupleFluid.setIgnored(Materials.TreatedWood);
        pipeSmallRestrictive.addSecondaryMaterial(new MaterialStack(Materials.Iron, OrePrefix.ring.materialAmount * 2L));
        pipeNormalRestrictive.addSecondaryMaterial(new MaterialStack(Materials.Iron, OrePrefix.ring.materialAmount * 2L));
        pipeLargeRestrictive.addSecondaryMaterial(new MaterialStack(Materials.Iron, OrePrefix.ring.materialAmount * 2L));
        pipeHugeRestrictive.addSecondaryMaterial(new MaterialStack(Materials.Iron, OrePrefix.ring.materialAmount * 2L));
        cableGtSingle.addSecondaryMaterial(new MaterialStack(Materials.Rubber, OrePrefix.plate.materialAmount));
        cableGtDouble.addSecondaryMaterial(new MaterialStack(Materials.Rubber, OrePrefix.plate.materialAmount));
        cableGtQuadruple.addSecondaryMaterial(new MaterialStack(Materials.Rubber, OrePrefix.plate.materialAmount * 2L));
        cableGtOctal.addSecondaryMaterial(new MaterialStack(Materials.Rubber, OrePrefix.plate.materialAmount * 3L));
        cableGtHex.addSecondaryMaterial(new MaterialStack(Materials.Rubber, OrePrefix.plate.materialAmount * 5L));
        plateDouble.setIgnored(Materials.BorosilicateGlass);
        plate.setIgnored(Materials.BorosilicateGlass);
        foil.setIgnored(Materials.BorosilicateGlass);
        dustSmall.setIgnored(Materials.Lapotron);
        dustTiny.setIgnored(Materials.Lapotron);
        currentProcessingPrefix = new ThreadLocal();
        currentMaterial = new ThreadLocal();
    }

    public static class Conditions {
        public static final Predicate<Material> hasToolProperty = mat -> mat.hasProperty(PropertyKey.TOOL);
        public static final Predicate<Material> hasNoCraftingToolProperty = hasToolProperty.and(mat -> !mat.getProperty(PropertyKey.TOOL).getShouldIgnoreCraftingTools());
        public static final Predicate<Material> hasOreProperty = mat -> mat.hasProperty(PropertyKey.ORE);
        public static final Predicate<Material> hasGemProperty = mat -> mat.hasProperty(PropertyKey.GEM);
        public static final Predicate<Material> hasDustProperty = mat -> mat.hasProperty(PropertyKey.DUST);
        public static final Predicate<Material> hasIngotProperty = mat -> mat.hasProperty(PropertyKey.INGOT);
        public static final Predicate<Material> hasBlastProperty = mat -> mat.hasProperty(PropertyKey.BLAST);
        public static final Predicate<Material> hasRotorProperty = mat -> mat.hasProperty(PropertyKey.ROTOR);
    }

    public static class Flags {
        public static final long ENABLE_UNIFICATION = 1L;
        public static final long SELF_REFERENCING = 2L;
    }
}

