/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public final class StreamUtils {
    public static Stream<ItemStack> streamFrom(IItemHandler inventory) {
        return StreamSupport.stream(StreamUtils.iterableFrom(inventory).spliterator(), false);
    }

    public static Stream<FluidStack> streamFrom(IFluidHandler fluidInventory) {
        return StreamSupport.stream(StreamUtils.iterableFrom(fluidInventory).spliterator(), false);
    }

    public static Iterable<ItemStack> iterableFrom(final IItemHandler inventory) {
        return new Iterable<ItemStack>(){

            @Override
            @Nonnull
            public Iterator<ItemStack> iterator() {
                return new Iterator<ItemStack>(){
                    private int cursor = 0;

                    @Override
                    public boolean hasNext() {
                        return this.cursor < inventory.getSlots();
                    }

                    @Override
                    public ItemStack next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("ItemStack iterator does not have next value");
                        }
                        ItemStack next = inventory.getStackInSlot(this.cursor);
                        ++this.cursor;
                        return next;
                    }
                };
            }

            @Override
            public Spliterator<ItemStack> spliterator() {
                return Spliterators.spliterator(this.iterator(), (long)inventory.getSlots(), 0);
            }
        };
    }

    public static Iterable<FluidStack> iterableFrom(final IFluidHandler fluidInventory) {
        return new Iterable<FluidStack>(){

            @Override
            @Nonnull
            public Iterator<FluidStack> iterator() {
                return new Iterator<FluidStack>(){
                    private int cursor = 0;

                    @Override
                    public boolean hasNext() {
                        return this.cursor < fluidInventory.getTankProperties().length;
                    }

                    @Override
                    public FluidStack next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("FluidStack iterator does not have next value");
                        }
                        FluidStack next = fluidInventory.getTankProperties()[this.cursor].getContents();
                        ++this.cursor;
                        return next;
                    }
                };
            }

            @Override
            public Spliterator<FluidStack> spliterator() {
                return Spliterators.spliterator(this.iterator(), (long)fluidInventory.getTankProperties().length, 0);
            }
        };
    }
}

