/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.gson.JsonObject;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.api.worldgen.config.IWorldgenDefinition;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldConfigUtils;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BedrockFluidDepositDefinition
implements IWorldgenDefinition {
    private final String depositName;
    private int weight;
    private String assignedName;
    private String description;
    private final int[] yields = new int[2];
    private int depletionAmount;
    private int depletionChance;
    private int depletedYield;
    private Fluid storedFluid;
    private Function<Biome, Integer> biomeWeightModifier = OreDepositDefinition.NO_BIOME_INFLUENCE;
    private Predicate<WorldProvider> dimensionFilter = OreDepositDefinition.PREDICATE_SURFACE_WORLD;

    public BedrockFluidDepositDefinition(String depositName) {
        this.depositName = depositName;
    }

    @Override
    public boolean initializeFromConfig(@Nonnull JsonObject configRoot) {
        this.weight = configRoot.get("weight").getAsInt();
        this.yields[0] = configRoot.get("yield").getAsJsonObject().get("min").getAsInt();
        this.yields[1] = configRoot.get("yield").getAsJsonObject().get("max").getAsInt();
        this.depletionAmount = configRoot.get("depletion").getAsJsonObject().get("amount").getAsInt();
        this.depletionChance = Math.max(0, Math.min(100, configRoot.get("depletion").getAsJsonObject().get("chance").getAsInt()));
        Fluid fluid = FluidRegistry.getFluid((String)configRoot.get("fluid").getAsString());
        if (fluid == null) {
            GTLog.logger.error("Bedrock Fluid Vein {} cannot have a null fluid!", (Object)this.depositName, (Object)new RuntimeException());
            return false;
        }
        this.storedFluid = fluid;
        if (configRoot.has("name")) {
            this.assignedName = configRoot.get("name").getAsString();
        }
        if (configRoot.has("description")) {
            this.description = configRoot.get("description").getAsString();
        }
        if (configRoot.get("depletion").getAsJsonObject().has("depleted_yield")) {
            this.depletedYield = configRoot.get("depletion").getAsJsonObject().get("depleted_yield").getAsInt();
        }
        if (configRoot.has("biome_modifier")) {
            this.biomeWeightModifier = WorldConfigUtils.createBiomeWeightModifier(configRoot.get("biome_modifier"));
        }
        if (configRoot.has("dimension_filter")) {
            this.dimensionFilter = WorldConfigUtils.createWorldPredicate(configRoot.get("dimension_filter"));
        }
        BedrockFluidVeinHandler.addFluidDeposit(this);
        return true;
    }

    @Override
    public String getDepositName() {
        return this.depositName;
    }

    public String getAssignedName() {
        return this.assignedName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWeight() {
        return this.weight;
    }

    public int[] getYields() {
        return this.yields;
    }

    public int getMinimumYield() {
        return this.yields[0];
    }

    public int getMaximumYield() {
        return this.yields[1];
    }

    public int getDepletionAmount() {
        return this.depletionAmount;
    }

    public int getDepletionChance() {
        return this.depletionChance;
    }

    public int getDepletedYield() {
        return this.depletedYield;
    }

    public Fluid getStoredFluid() {
        return this.storedFluid;
    }

    public Function<Biome, Integer> getBiomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    public Predicate<WorldProvider> getDimensionFilter() {
        return this.dimensionFilter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BedrockFluidDepositDefinition)) {
            return false;
        }
        BedrockFluidDepositDefinition objDeposit = (BedrockFluidDepositDefinition)obj;
        if (this.weight != objDeposit.getWeight()) {
            return false;
        }
        if (this.getMinimumYield() != objDeposit.getMinimumYield()) {
            return false;
        }
        if (this.getMaximumYield() != objDeposit.getMaximumYield()) {
            return false;
        }
        if (this.depletionAmount != objDeposit.getDepletionAmount()) {
            return false;
        }
        if (this.depletionChance != objDeposit.getDepletionChance()) {
            return false;
        }
        if (!this.storedFluid.equals(objDeposit.getStoredFluid())) {
            return false;
        }
        if (this.assignedName == null && objDeposit.getAssignedName() != null || this.assignedName != null && objDeposit.getAssignedName() == null || this.assignedName != null && objDeposit.getAssignedName() != null && !this.assignedName.equals(objDeposit.getAssignedName())) {
            return false;
        }
        if (this.description == null && objDeposit.getDescription() != null || this.description != null && objDeposit.getDescription() == null || this.description != null && objDeposit.getDescription() != null && !this.description.equals(objDeposit.getDescription())) {
            return false;
        }
        if (this.depletedYield != objDeposit.getDepletedYield()) {
            return false;
        }
        if (this.biomeWeightModifier == null && objDeposit.getBiomeWeightModifier() != null || this.biomeWeightModifier != null && objDeposit.getBiomeWeightModifier() == null || this.biomeWeightModifier != null && objDeposit.getBiomeWeightModifier() != null && !this.biomeWeightModifier.equals(objDeposit.getBiomeWeightModifier())) {
            return false;
        }
        if (this.dimensionFilter == null && objDeposit.getDimensionFilter() != null || this.dimensionFilter != null && objDeposit.getDimensionFilter() == null || this.dimensionFilter != null && objDeposit.getDimensionFilter() != null && !this.dimensionFilter.equals(objDeposit.getDimensionFilter())) {
            return false;
        }
        return super.equals(obj);
    }
}

