/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.BedrockFluidDepositDefinition;
import gregtech.api.worldgen.config.IWorldgenDefinition;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.filler.BlacklistedBlockFiller;
import gregtech.api.worldgen.filler.BlockFiller;
import gregtech.api.worldgen.filler.LayeredBlockFiller;
import gregtech.api.worldgen.filler.SimpleBlockFiller;
import gregtech.api.worldgen.generator.WorldGeneratorImpl;
import gregtech.api.worldgen.populator.FluidSpringPopulator;
import gregtech.api.worldgen.populator.IVeinPopulator;
import gregtech.api.worldgen.populator.SurfaceBlockPopulator;
import gregtech.api.worldgen.populator.SurfaceRockPopulator;
import gregtech.api.worldgen.shape.EllipsoidGenerator;
import gregtech.api.worldgen.shape.LayeredGenerator;
import gregtech.api.worldgen.shape.PlateGenerator;
import gregtech.api.worldgen.shape.ShapeGenerator;
import gregtech.api.worldgen.shape.SingleBlockGenerator;
import gregtech.api.worldgen.shape.SphereGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.io.IOUtils;

public class WorldGenRegistry {
    public static final WorldGenRegistry INSTANCE = new WorldGenRegistry();
    private static final int FLUID_VEIN_VERSION = 2;
    private static final int ORE_VEIN_VERSION = 1;
    private final Map<String, Supplier<ShapeGenerator>> shapeGeneratorRegistry = new TreeMap<String, Supplier<ShapeGenerator>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Supplier<BlockFiller>> blockFillerRegistry = new TreeMap<String, Supplier<BlockFiller>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Supplier<IVeinPopulator>> veinPopulatorRegistry = new TreeMap<String, Supplier<IVeinPopulator>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<Integer, String> namedDimensions = new HashMap<Integer, String>();
    private final List<OreDepositDefinition> registeredVeinDefinitions = new ArrayList<OreDepositDefinition>();
    private final List<BedrockFluidDepositDefinition> registeredBedrockVeinDefinitions = new ArrayList<BedrockFluidDepositDefinition>();
    private final List<OreDepositDefinition> addonRegisteredDefinitions = new ArrayList<OreDepositDefinition>();
    private final List<BedrockFluidDepositDefinition> addonRegisteredBedrockVeinDefinitions = new ArrayList<BedrockFluidDepositDefinition>();
    private List<OreDepositDefinition> removedVeinDefinitions = new ArrayList<OreDepositDefinition>();
    private List<BedrockFluidDepositDefinition> removedBedrockVeinDefinitions = new ArrayList<BedrockFluidDepositDefinition>();
    private final Map<WorldProvider, WorldOreVeinCache> oreVeinCache = new WeakHashMap<WorldProvider, WorldOreVeinCache>();

    private WorldGenRegistry() {
    }

    public List<Map.Entry<Integer, OreDepositDefinition>> getCachedBiomeVeins(WorldProvider provider, Biome biome) {
        if (this.oreVeinCache.containsKey(provider)) {
            return this.oreVeinCache.get(provider).getBiomeEntry(biome);
        }
        WorldOreVeinCache worldOreVeinCache = new WorldOreVeinCache(provider);
        this.oreVeinCache.put(provider, worldOreVeinCache);
        return worldOreVeinCache.getBiomeEntry(biome);
    }

    public void initializeRegistry() {
        GTLog.logger.info("Initializing ore generation registry...");
        this.registerShapeGenerator("ellipsoid", EllipsoidGenerator::new);
        this.registerShapeGenerator("sphere", SphereGenerator::new);
        this.registerShapeGenerator("plate", PlateGenerator::new);
        this.registerShapeGenerator("single", SingleBlockGenerator::new);
        this.registerShapeGenerator("layered", LayeredGenerator::new);
        this.registerBlockFiller("simple", SimpleBlockFiller::new);
        this.registerBlockFiller("layered", LayeredBlockFiller::new);
        this.registerBlockFiller("ignore_bedrock", () -> new BlacklistedBlockFiller(Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150357_h.func_176223_P()})));
        this.registerVeinPopulator("surface_rock", SurfaceRockPopulator::new);
        this.registerVeinPopulator("fluid_spring", FluidSpringPopulator::new);
        this.registerVeinPopulator("surface_block", SurfaceBlockPopulator::new);
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldGeneratorImpl.INSTANCE, (int)1);
        MinecraftForge.ORE_GEN_BUS.register((Object)WorldGeneratorImpl.INSTANCE);
        try {
            this.reinitializeRegisteredVeins();
        }
        catch (IOException | RuntimeException exception) {
            GTLog.logger.fatal("Failed to initialize worldgen registry.", (Throwable)exception);
        }
        if (Loader.isModLoaded((String)"galacticraftcore")) {
            try {
                Class<?> transformerHooksClass = Class.forName("micdoodle8.mods.galacticraft.core.TransformerHooks");
                Field otherModGeneratorsWhitelistField = transformerHooksClass.getDeclaredField("otherModGeneratorsWhitelist");
                otherModGeneratorsWhitelistField.setAccessible(true);
                List otherModGeneratorsWhitelist = (List)otherModGeneratorsWhitelistField.get(null);
                otherModGeneratorsWhitelist.add(WorldGeneratorImpl.INSTANCE);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                GTLog.logger.fatal("Failed to inject world generator into Galacticraft's whitelist.", (Throwable)e);
            }
        }
    }

    public void reinitializeRegisteredVeins() throws IOException {
        Path worldgenDefinition;
        JsonObject element;
        Path worldgenDefinition2;
        JsonObject element2;
        Path bedrockVeinPath;
        GTLog.logger.info("Reloading ore generation files from config...");
        this.registeredVeinDefinitions.clear();
        this.registeredBedrockVeinDefinitions.clear();
        this.oreVeinCache.clear();
        Path configPath = Loader.instance().getConfigDir().toPath().resolve("gregtech");
        Path dimensionsFile = configPath.resolve("dimensions.json");
        Path worldgenRootPath = configPath.resolve("worldgen");
        Path jarFileExtractLock = configPath.resolve("worldgen_extracted.json");
        if (!Files.exists(worldgenRootPath, new LinkOption[0])) {
            Files.createDirectories(worldgenRootPath, new FileAttribute[0]);
        }
        Path jarFileExtractLockOLD = configPath.resolve("worldgen_extracted.txt");
        Files.deleteIfExists(jarFileExtractLockOLD);
        Path veinPath = worldgenRootPath.resolve("vein");
        if (!Files.exists(veinPath, new LinkOption[0])) {
            Files.createDirectories(veinPath, new FileAttribute[0]);
        }
        if (!Files.exists(bedrockVeinPath = worldgenRootPath.resolve("fluid"), new LinkOption[0])) {
            Files.createDirectories(bedrockVeinPath, new FileAttribute[0]);
        }
        if (!Files.exists(dimensionsFile, new LinkOption[0])) {
            Files.createFile(dimensionsFile, new FileAttribute[0]);
            WorldGenRegistry.extractJarVeinDefinitions(configPath, dimensionsFile);
        }
        if (Files.exists(jarFileExtractLock, new LinkOption[0])) {
            JsonObject extractLock = FileUtility.tryExtractFromFile(jarFileExtractLock);
            if (extractLock != null) {
                boolean needsUpdate = false;
                if (extractLock.get("fluidVersion").getAsInt() != 2) {
                    WorldGenRegistry.extractJarVeinDefinitions(configPath, bedrockVeinPath);
                    needsUpdate = true;
                }
                if (extractLock.get("veinVersion").getAsInt() != 1) {
                    WorldGenRegistry.extractJarVeinDefinitions(configPath, veinPath);
                    needsUpdate = true;
                }
                if (needsUpdate) {
                    WorldGenRegistry.extractJarVeinDefinitions(configPath, jarFileExtractLock);
                }
            }
        } else {
            WorldGenRegistry.extractJarVeinDefinitions(configPath, bedrockVeinPath);
            Files.createFile(jarFileExtractLock, new FileAttribute[0]);
            WorldGenRegistry.extractJarVeinDefinitions(configPath, jarFileExtractLock);
        }
        if (!Files.list(worldgenRootPath.resolve(veinPath)).findFirst().isPresent()) {
            WorldGenRegistry.extractJarVeinDefinitions(configPath, veinPath);
        }
        if (!Files.list(worldgenRootPath.resolve(bedrockVeinPath)).findFirst().isPresent()) {
            WorldGenRegistry.extractJarVeinDefinitions(configPath, bedrockVeinPath);
        }
        this.gatherNamedDimensions(dimensionsFile);
        if (!this.removedVeinDefinitions.isEmpty()) {
            this.removeExistingFiles(veinPath, this.removedVeinDefinitions);
        }
        if (!this.removedBedrockVeinDefinitions.isEmpty()) {
            this.removeExistingFiles(bedrockVeinPath, this.removedBedrockVeinDefinitions);
        }
        List veinFiles = Files.walk(veinPath, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        Iterator needsUpdate = veinFiles.iterator();
        while (needsUpdate.hasNext() && (element2 = FileUtility.tryExtractFromFile(worldgenDefinition2 = (Path)needsUpdate.next())) != null) {
            String depositName = veinPath.relativize(worldgenDefinition2).toString();
            try {
                OreDepositDefinition deposit = new OreDepositDefinition(depositName);
                deposit.initializeFromConfig(element2);
                this.registeredVeinDefinitions.add(deposit);
            }
            catch (RuntimeException exception) {
                GTLog.logger.error("Failed to parse worldgen definition {} on path {}", (Object)depositName, (Object)worldgenDefinition2, (Object)exception);
            }
        }
        GTLog.logger.info("Loaded {} vein worldgen definitions", (Object)this.registeredVeinDefinitions.size());
        List bedrockFluidVeinFiles = Files.walk(bedrockVeinPath, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        Iterator iterator = bedrockFluidVeinFiles.iterator();
        while (iterator.hasNext() && (element = FileUtility.tryExtractFromFile(worldgenDefinition = (Path)iterator.next())) != null) {
            String depositName = bedrockVeinPath.relativize(worldgenDefinition).toString();
            try {
                BedrockFluidDepositDefinition deposit = new BedrockFluidDepositDefinition(depositName);
                if (!deposit.initializeFromConfig(element)) continue;
                this.registeredBedrockVeinDefinitions.add(deposit);
            }
            catch (RuntimeException exception) {
                GTLog.logger.error("Failed to parse worldgen definition {} on path {}", (Object)depositName, (Object)worldgenDefinition, (Object)exception);
            }
        }
        this.addAddonFiles(worldgenRootPath, this.addonRegisteredDefinitions, this.registeredVeinDefinitions);
        this.addAddonFiles(worldgenRootPath, this.addonRegisteredBedrockVeinDefinitions, this.registeredBedrockVeinDefinitions);
        GTLog.logger.info("Loaded {} bedrock worldgen definitions", (Object)this.registeredBedrockVeinDefinitions.size());
        GTLog.logger.info("Loaded {} worldgen definitions from addon mods", (Object)this.addonRegisteredDefinitions.size());
        GTLog.logger.info("Loaded {} bedrock worldgen definitions from addon mods", (Object)this.addonRegisteredBedrockVeinDefinitions.size());
        GTLog.logger.info("Loaded {} total worldgen definitions", (Object)(this.registeredVeinDefinitions.size() + this.registeredBedrockVeinDefinitions.size()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void extractJarVeinDefinitions(Path configPath, Path targetPath) throws IOException {
        Path worldgenRootPath = configPath.resolve("worldgen");
        Path oreVeinRootPath = worldgenRootPath.resolve("vein");
        Path bedrockFluidVeinRootPath = worldgenRootPath.resolve("fluid");
        Path dimensionsRootPath = configPath.resolve("dimensions.json");
        Path extractLockPath = configPath.resolve("worldgen_extracted.json");
        FileSystem zipFileSystem = null;
        try {
            Path bedrockFluidJarRootPath;
            Path oreVeinJarRootPath;
            Path worldgenJarRootPath;
            URI sampleUri = WorldGenRegistry.class.getResource("/assets/gregtech/.gtassetsroot").toURI();
            if (sampleUri.getScheme().equals("jar") || sampleUri.getScheme().equals("zip")) {
                zipFileSystem = FileSystems.newFileSystem(sampleUri, Collections.emptyMap());
                worldgenJarRootPath = zipFileSystem.getPath("/assets/gregtech/worldgen", new String[0]);
                oreVeinJarRootPath = zipFileSystem.getPath("/assets/gregtech/worldgen/vein", new String[0]);
                bedrockFluidJarRootPath = zipFileSystem.getPath("/assets/gregtech/worldgen/fluid", new String[0]);
            } else {
                if (!sampleUri.getScheme().equals("file")) throw new IllegalStateException("Unable to locate absolute path to worldgen root directory: " + sampleUri);
                worldgenJarRootPath = Paths.get(WorldGenRegistry.class.getResource("/assets/gregtech/worldgen").toURI());
                oreVeinJarRootPath = Paths.get(WorldGenRegistry.class.getResource("/assets/gregtech/worldgen/vein").toURI());
                bedrockFluidJarRootPath = Paths.get(WorldGenRegistry.class.getResource("/assets/gregtech/worldgen/fluid").toURI());
            }
            if (targetPath.compareTo(oreVeinRootPath) == 0) {
                GTLog.logger.info("Attempting extraction of standard worldgen definitions from {} to {}", (Object)oreVeinJarRootPath, (Object)oreVeinRootPath);
                List jarFiles = Files.walk(oreVeinJarRootPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path jarFile : jarFiles) {
                    Path worldgenPath = oreVeinRootPath.resolve(oreVeinJarRootPath.relativize(jarFile).toString());
                    Files.createDirectories(worldgenPath.getParent(), new FileAttribute[0]);
                    Files.copy(jarFile, worldgenPath, StandardCopyOption.REPLACE_EXISTING);
                }
                GTLog.logger.info("Extracted {} builtin worldgen vein definitions into vein folder", (Object)jarFiles.size());
            } else if (targetPath.compareTo(bedrockFluidVeinRootPath) == 0) {
                GTLog.logger.info("Attempting extraction of standard worldgen definitions from {} to {}", (Object)bedrockFluidJarRootPath, (Object)bedrockFluidVeinRootPath);
                List jarFiles = Files.walk(bedrockFluidJarRootPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path jarFile : jarFiles) {
                    Path worldgenPath = bedrockFluidVeinRootPath.resolve(bedrockFluidJarRootPath.relativize(jarFile).toString());
                    Files.createDirectories(worldgenPath.getParent(), new FileAttribute[0]);
                    Files.copy(jarFile, worldgenPath, StandardCopyOption.REPLACE_EXISTING);
                }
                GTLog.logger.info("Extracted {} builtin worldgen bedrock fluid definitions into fluid folder", (Object)jarFiles.size());
            } else if (targetPath.compareTo(dimensionsRootPath) == 0) {
                GTLog.logger.info("Attempting extraction of standard dimension definitions from {} to {}", (Object)worldgenJarRootPath, (Object)dimensionsRootPath);
                Path dimensionFile = worldgenJarRootPath.resolve("dimensions.json");
                Path worldgenPath = dimensionsRootPath.resolve(worldgenJarRootPath.relativize(worldgenJarRootPath).toString());
                Files.copy(dimensionFile, worldgenPath, StandardCopyOption.REPLACE_EXISTING);
                GTLog.logger.info("Extracted builtin dimension definitions into worldgen folder");
            } else if (targetPath.compareTo(extractLockPath) == 0) {
                Path extractLockFile = worldgenJarRootPath.resolve("worldgen_extracted.json");
                Path worldgenPath = extractLockPath.resolve(worldgenJarRootPath.relativize(worldgenJarRootPath).toString());
                Files.copy(extractLockFile, worldgenPath, StandardCopyOption.REPLACE_EXISTING);
                GTLog.logger.info("Extracted jar lock file into worldgen folder");
            }
            if (zipFileSystem == null) return;
        }
        catch (URISyntaxException impossible) {
            try {
                throw new RuntimeException(impossible);
            }
            catch (Throwable throwable) {
                if (zipFileSystem == null) throw throwable;
                IOUtils.closeQuietly(zipFileSystem);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)zipFileSystem);
        return;
    }

    private void removeExistingFiles(Path root, @Nonnull List<? extends IWorldgenDefinition> definitions) {
        for (IWorldgenDefinition iWorldgenDefinition : definitions) {
            Path filePath = root.resolve(Paths.get(iWorldgenDefinition.getDepositName(), new String[0]));
            try {
                if (!Files.exists(filePath, new LinkOption[0])) continue;
                Files.delete(filePath);
                GTLog.logger.info("Removed oregen file at {}", (Object)iWorldgenDefinition.getDepositName());
            }
            catch (IOException exception) {
                GTLog.logger.error("Failed to remove oregen file at {}", (Object)iWorldgenDefinition.getDepositName());
            }
        }
    }

    private <T extends IWorldgenDefinition> void addAddonFiles(Path root, @Nonnull List<T> definitions, @Nonnull List<T> registeredDefinitions) {
        for (IWorldgenDefinition definition : definitions) {
            JsonObject element = FileUtility.tryExtractFromFile(root.resolve(definition.getDepositName()));
            if (element == null) {
                GTLog.logger.error("Addon mod tried to register bad ore definition at {}", (Object)definition.getDepositName());
                definitions.remove(definition);
                continue;
            }
            try {
                definition.initializeFromConfig(element);
                registeredDefinitions.add(definition);
            }
            catch (RuntimeException exception) {
                GTLog.logger.error("Failed to parse addon worldgen definition {}", (Object)definition.getDepositName(), (Object)exception);
            }
        }
    }

    private void gatherNamedDimensions(Path dimensionsFile) {
        JsonObject element = FileUtility.tryExtractFromFile(dimensionsFile);
        if (element == null) {
            return;
        }
        try {
            JsonArray dims = element.getAsJsonArray("dims");
            for (JsonElement dim : dims) {
                this.namedDimensions.put(dim.getAsJsonObject().get("dimID").getAsInt(), dim.getAsJsonObject().get("dimName").getAsString());
            }
        }
        catch (RuntimeException exception) {
            GTLog.logger.error("Failed to parse named dimensions", (Throwable)exception);
        }
    }

    public void removeVeinDefinitions(IWorldgenDefinition definition) {
        if (definition instanceof OreDepositDefinition) {
            if (this.registeredVeinDefinitions.contains(definition)) {
                this.registeredVeinDefinitions.remove(definition);
                this.removedVeinDefinitions.add((OreDepositDefinition)definition);
            } else {
                GTLog.logger.error("Failed to remove OreDepositDefinition at {}. Deposit was not in list of registered veins.", (Object)definition.getDepositName());
            }
        } else if (definition instanceof BedrockFluidDepositDefinition) {
            if (this.registeredBedrockVeinDefinitions.contains(definition)) {
                this.registeredBedrockVeinDefinitions.remove(definition);
                this.removedBedrockVeinDefinitions.add((BedrockFluidDepositDefinition)definition);
            } else {
                GTLog.logger.error("Failed to remove BedrockFluidDepositDefinition at {}. Deposit was not in list of registered veins.", (Object)definition.getDepositName());
            }
        }
    }

    public void addVeinDefinitions(OreDepositDefinition definition) {
        if (!this.registeredVeinDefinitions.contains(definition)) {
            this.addonRegisteredDefinitions.add(definition);
        } else {
            GTLog.logger.error("Failed to add ore vein definition at {}. Definition already exists", (Object)definition.getDepositName());
        }
    }

    public void addVeinDefinitions(BedrockFluidDepositDefinition definition) {
        if (!this.addonRegisteredBedrockVeinDefinitions.contains(definition)) {
            this.addonRegisteredBedrockVeinDefinitions.add(definition);
        } else {
            GTLog.logger.error("Failed to add bedrock fluid deposit definition at {}. Definition already exists", (Object)definition.getDepositName());
        }
    }

    public void registerShapeGenerator(String identifier, Supplier<ShapeGenerator> shapeGeneratorSupplier) {
        if (this.shapeGeneratorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("Identifier already occupied:" + identifier);
        }
        this.shapeGeneratorRegistry.put(identifier, shapeGeneratorSupplier);
    }

    public void registerBlockFiller(String identifier, Supplier<BlockFiller> blockFillerSupplier) {
        if (this.blockFillerRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("Identifier already occupied:" + identifier);
        }
        this.blockFillerRegistry.put(identifier, blockFillerSupplier);
    }

    public void registerVeinPopulator(String identifier, Supplier<IVeinPopulator> veinPopulatorSupplier) {
        if (this.veinPopulatorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("Identifier already occupied:" + identifier);
        }
        this.veinPopulatorRegistry.put(identifier, veinPopulatorSupplier);
    }

    public ShapeGenerator createShapeGenerator(JsonObject object) {
        String identifier = object.get("type").getAsString();
        if (!this.shapeGeneratorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("No shape generator found for type " + identifier);
        }
        ShapeGenerator shapeGenerator = this.shapeGeneratorRegistry.get(identifier).get();
        shapeGenerator.loadFromConfig(object);
        return shapeGenerator;
    }

    public BlockFiller createBlockFiller(JsonObject object) {
        String identifier = object.get("type").getAsString();
        if (!this.blockFillerRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("No block filler found for type " + identifier);
        }
        BlockFiller blockFiller = this.blockFillerRegistry.get(identifier).get();
        blockFiller.loadFromConfig(object);
        return blockFiller;
    }

    public IVeinPopulator createVeinPopulator(JsonObject object) {
        String identifier = object.get("type").getAsString();
        if (!this.veinPopulatorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("No vein populator found for type " + identifier);
        }
        IVeinPopulator veinPopulator = this.veinPopulatorRegistry.get(identifier).get();
        veinPopulator.loadFromConfig(object);
        return veinPopulator;
    }

    public static List<OreDepositDefinition> getOreDeposits() {
        return Collections.unmodifiableList(WorldGenRegistry.INSTANCE.registeredVeinDefinitions);
    }

    public static List<BedrockFluidDepositDefinition> getBedrockVeinDeposits() {
        return Collections.unmodifiableList(WorldGenRegistry.INSTANCE.registeredBedrockVeinDefinitions);
    }

    public static Map<Integer, String> getNamedDimensions() {
        return WorldGenRegistry.INSTANCE.namedDimensions;
    }

    private class WorldOreVeinCache {
        private final List<OreDepositDefinition> worldVeins;
        private final Map<Biome, List<Map.Entry<Integer, OreDepositDefinition>>> biomeVeins = new HashMap<Biome, List<Map.Entry<Integer, OreDepositDefinition>>>();

        public WorldOreVeinCache(WorldProvider worldProvider) {
            this.worldVeins = WorldGenRegistry.this.registeredVeinDefinitions.stream().filter(definition -> definition.getDimensionFilter().test(worldProvider)).collect(Collectors.toList());
        }

        private List<Map.Entry<Integer, OreDepositDefinition>> getBiomeEntry(Biome biome) {
            if (this.biomeVeins.containsKey(biome)) {
                return this.biomeVeins.get(biome);
            }
            List<Map.Entry<Integer, OreDepositDefinition>> result = this.worldVeins.stream().map(vein -> new AbstractMap.SimpleEntry<Integer, OreDepositDefinition>(vein.getWeight() + vein.getBiomeWeightModifier().apply(biome), (OreDepositDefinition)vein)).filter(entry -> (Integer)entry.getKey() > 0).collect(Collectors.toList());
            this.biomeVeins.put(biome, result);
            return result;
        }
    }
}

