/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.modelfactories;

import gregtech.api.block.VariantActiveBlock;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ActiveVariantBlockBakedModel
implements IBakedModel {
    private final ThreadLocal<TextureAtlasSprite> particle = ThreadLocal.withInitial(() -> Minecraft.func_71410_x().func_147117_R().func_174944_f());

    ActiveVariantBlockBakedModel() {
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        List<BakedQuad> quads;
        if (side == null || state == null) {
            return Collections.emptyList();
        }
        boolean activeState = ((IExtendedBlockState)state).getValue((IUnlistedProperty)VariantActiveBlock.ACTIVE) == null ? false : (Boolean)((IExtendedBlockState)state).getValue((IUnlistedProperty)VariantActiveBlock.ACTIVE);
        ModelResourceLocation mrl = activeState ? new ModelResourceLocation(state.func_177230_c().getRegistryName(), "active=true,variant=" + state.func_177228_b().entrySet().stream().filter(p -> ((IProperty)p.getKey()).func_177701_a().equals("variant")).map(e -> {
            IProperty p = (IProperty)e.getKey();
            return ActiveVariantBlockBakedModel.getPropertyName(p, (Comparable)e.getValue());
        }).collect(Collectors.joining())) : new ModelResourceLocation(state.func_177230_c().getRegistryName(), "active=false,variant=" + state.func_177228_b().entrySet().stream().filter(p -> ((IProperty)p.getKey()).func_177701_a().equals("variant")).map(e -> {
            IProperty p = (IProperty)e.getKey();
            return ActiveVariantBlockBakedModel.getPropertyName(p, (Comparable)e.getValue());
        }).collect(Collectors.joining()));
        IBakedModel m = Minecraft.func_71410_x().field_175618_aM.func_175023_a().func_178126_b().func_174953_a(mrl);
        TextureAtlasSprite textureAtlasSprite = m.func_177554_e();
        this.particle.set(textureAtlasSprite);
        if (MinecraftForgeClient.getRenderLayer() == BloomEffectUtil.getRealBloomLayer()) {
            if (ConfigHolder.client.casingsActiveEmissiveTextures) {
                quads = new ArrayList();
                for (BakedQuad b : m.func_188616_a(state, side, rand)) {
                    if (!b.func_187508_a().func_94215_i().contains("bloom")) continue;
                    quads.add(b);
                }
            } else {
                quads = Collections.emptyList();
            }
        } else {
            quads = new ArrayList<BakedQuad>(m.func_188616_a(state, side, rand));
        }
        return quads;
    }

    public static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            ModelResourceLocation mrl = (Boolean)((IExtendedBlockState)state).getValue((IUnlistedProperty)VariantActiveBlock.ACTIVE) != false ? new ModelResourceLocation(state.func_177230_c().getRegistryName(), "active=true," + MetaBlocks.statePropertiesToString(state.func_177228_b())) : new ModelResourceLocation(state.func_177230_c().getRegistryName(), "active=false," + MetaBlocks.statePropertiesToString(state.func_177228_b()));
            IBakedModel m = Minecraft.func_71410_x().field_175618_aM.func_175023_a().func_178126_b().func_174953_a(mrl);
            return m.func_177555_b();
        }
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle.get();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

