/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.block.DelayedStateBlock;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.ItemBlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.model.IModelSupplier;
import gregtech.client.model.SimpleStateMapper;
import gregtech.common.blocks.FrameItemBlock;
import gregtech.common.blocks.properties.PropertyMaterial;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BlockFrame
extends DelayedStateBlock
implements IModelSupplier {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "frame_block"), "normal");
    public static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 1.0, 0.95);
    public final PropertyMaterial variantProperty;

    public BlockFrame(gregtech.api.unification.material.Material[] materials) {
        super(Material.field_151573_f);
        this.func_149663_c("frame");
        this.func_149711_c(3.0f);
        this.func_149752_b(6.0f);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_MATERIALS);
        this.variantProperty = PropertyMaterial.create("variant", materials);
        this.initBlockState();
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta >= this.variantProperty.getAllowedValues().size()) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)this.variantProperty.getAllowedValues().get(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.variantProperty.getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.variantProperty));
    }

    public String getHarvestTool(IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (ModHandler.isMaterialWood(material)) {
            return "axe";
        }
        return "wrench";
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (ModHandler.isMaterialWood(material)) {
            return SoundType.field_185848_a;
        }
        return SoundType.field_185852_e;
    }

    public SoundType getSoundType(ItemStack stack) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(stack.func_77960_j());
        if (ModHandler.isMaterialWood(material)) {
            return SoundType.field_185848_a;
        }
        return SoundType.field_185852_e;
    }

    public int getHarvestLevel(@Nonnull IBlockState state) {
        return 1;
    }

    @Override
    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.variantProperty});
    }

    @Nonnull
    public Material func_149688_o(IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        if (ModHandler.isMaterialWood(material)) {
            return Material.field_151575_d;
        }
        return super.func_149688_o(state);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        this.field_176227_L.func_177619_a().stream().filter(blockState -> blockState.func_177229_b((IProperty)this.variantProperty) != Materials.NULL).forEach(blockState -> list.add((Object)this.getItem((IBlockState)blockState)));
    }

    public ItemStack getItem(IBlockState blockState) {
        return GTUtility.toItem(blockState);
    }

    public ItemStack getItem(gregtech.api.unification.material.Material material) {
        return this.getItem(this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material));
    }

    public IBlockState getBlock(gregtech.api.unification.material.Material material) {
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material);
    }

    public gregtech.api.unification.material.Material getGtMaterial(int meta) {
        return (gregtech.api.unification.material.Material)this.variantProperty.getAllowedValues().get(meta);
    }

    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean replaceWithFramedPipe(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, ItemStack stackInHand, EnumFacing facing) {
        BlockPipe blockPipe = (BlockPipe)((ItemBlockPipe)stackInHand.func_77973_b()).func_179223_d();
        if (((IPipeType)blockPipe.getItemPipeType(stackInHand)).getThickness() < 1.0f) {
            ItemBlock itemBlock = (ItemBlock)stackInHand.func_77973_b();
            IBlockState pipeState = blockPipe.func_176223_P();
            itemBlock.placeBlockAt(stackInHand, playerIn, worldIn, pos, facing, 0.0f, 0.0f, 0.0f, pipeState);
            IPipeTile pipeTile = blockPipe.getPipeTileEntity((IBlockAccess)worldIn, pos);
            if (!(pipeTile instanceof TileEntityPipeBase)) {
                GTLog.logger.error("Pipe was not placed!");
                return false;
            }
            ((TileEntityPipeBase)pipeTile).setFrameMaterial(this.getGtMaterial(this.func_176201_c(state)));
            SoundType type = blockPipe.getSoundType(state, worldIn, pos, (Entity)playerIn);
            worldIn.func_184133_a(playerIn, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stackInHand.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stackInHand = playerIn.func_184586_b(hand);
        if (stackInHand.func_190926_b()) {
            return false;
        }
        if (stackInHand.func_77973_b() instanceof ItemBlockPipe) {
            return this.replaceWithFramedPipe(worldIn, pos, state, playerIn, stackInHand, facing);
        }
        if (!(stackInHand.func_77973_b() instanceof FrameItemBlock)) {
            return false;
        }
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        blockPos.func_189533_g((Vec3i)pos);
        for (int i = 0; i < 32; ++i) {
            if (worldIn.func_180495_p((BlockPos)blockPos).func_177230_c() instanceof BlockFrame) {
                blockPos.func_189536_c(EnumFacing.UP);
                continue;
            }
            TileEntity te = worldIn.func_175625_s((BlockPos)blockPos);
            if (te instanceof IPipeTile && ((IPipeTile)te).getFrameMaterial() != null) {
                blockPos.func_189536_c(EnumFacing.UP);
                continue;
            }
            if (this.func_176196_c(worldIn, (BlockPos)blockPos)) {
                worldIn.func_175656_a((BlockPos)blockPos, ((FrameItemBlock)stackInHand.func_77973_b()).getBlockState(stackInHand));
                SoundType type = this.getSoundType(stackInHand);
                worldIn.func_184133_a(null, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stackInHand.func_190918_g(1);
                }
                blockPos.func_185344_t();
                return true;
            }
            if (te instanceof TileEntityPipeBase && ((TileEntityPipeBase)te).getFrameMaterial() == null) {
                gregtech.api.unification.material.Material material = ((BlockFrame)((FrameItemBlock)stackInHand.func_77973_b()).func_179223_d()).getGtMaterial(stackInHand.func_77960_j());
                ((TileEntityPipeBase)te).setFrameMaterial(material);
                SoundType type = this.getSoundType(stackInHand);
                worldIn.func_184133_a(null, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stackInHand.func_190918_g(1);
                }
                blockPos.func_185344_t();
                return true;
            }
            blockPos.func_185344_t();
            return false;
        }
        blockPos.func_185344_t();
        return false;
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Entity entityIn) {
        entityIn.field_70159_w = MathHelper.func_151237_a((double)entityIn.field_70159_w, (double)-0.15, (double)0.15);
        entityIn.field_70179_y = MathHelper.func_151237_a((double)entityIn.field_70179_y, (double)-0.15, (double)0.15);
        entityIn.field_70143_R = 0.0f;
        if (entityIn.field_70181_x < -0.15) {
            entityIn.field_70181_x = -0.15;
        }
        if (entityIn.func_70093_af() && entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = 0.0;
        }
        if (entityIn.field_70123_F) {
            entityIn.field_70181_x = 0.3;
        }
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return COLLISION_BOX;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
            event.getMap().func_174942_a(MaterialIconType.frameGt.getBlockTexturePath(material.getMaterialIconSet()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new SimpleStateMapper(MODEL_LOCATION));
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)MODEL_LOCATION);
        }
    }
}

