/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GTValues;
import gregtech.api.block.DelayedStateBlock;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.properties.PropertyMaterial;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSurfaceRock
extends DelayedStateBlock {
    private static final AxisAlignedBB STONE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "surface_rock"), "normal");
    public final PropertyMaterial variantProperty;

    public BlockSurfaceRock(gregtech.api.unification.material.Material[] materials) {
        super(Material.field_151572_C);
        this.func_149663_c("surface_rock");
        this.func_149711_c(0.25f);
        this.variantProperty = PropertyMaterial.create("variant", materials);
        this.initBlockState();
    }

    @Nullable
    public String getHarvestTool(@Nonnull IBlockState state) {
        return "shovel";
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)this.variantProperty.getAllowedValues().get(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material);
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        return this.variantProperty.getAllowedValues().indexOf((Object)material);
    }

    public IBlockState getBlock(gregtech.api.unification.material.Material material) {
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material);
    }

    @Override
    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.variantProperty});
    }

    public ItemStack getItem(IBlockState blockState) {
        return GTUtility.toItem(blockState);
    }

    public ItemStack getItem(gregtech.api.unification.material.Material material) {
        return this.getItem(this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material));
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        this.field_176227_L.func_177619_a().stream().filter(blockState -> blockState.func_177229_b((IProperty)this.variantProperty) != Materials.NULL).forEach(blockState -> list.add((Object)this.getItem((IBlockState)blockState)));
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        playerIn.func_184609_a(hand);
        return true;
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        return SoundType.field_185849_b;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return STONE_AABB;
    }

    private ItemStack getDropStack(IBlockState blockState, int amount) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)blockState.func_177229_b((IProperty)this.variantProperty);
        return OreDictUnifier.get(OrePrefix.dustTiny, material, amount);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.getDropStack(state, 1);
    }

    public void getDrops(NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        int amount = 3 + GTValues.RNG.nextInt((int)(2.0 + (double)fortune * 1.5));
        drops.add((Object)this.getDropStack(state, amount));
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, BlockPos fromPos) {
        if (fromPos.func_177984_a().equals((Object)pos) && worldIn.func_180495_p(fromPos).func_193401_d((IBlockAccess)worldIn, fromPos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            worldIn.func_175655_b(pos, true);
        }
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

