/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.foam;

import gregtech.api.GregTechAPI;
import gregtech.api.unification.OreDictUnifier;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.foam.BlockPetrifiedFoam;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockColored;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFoam
extends BlockColored {
    private final boolean isReinforced;

    public BlockFoam(boolean isReinforced) {
        super(Material.field_151595_p);
        this.func_149663_c(isReinforced ? "gt.reinforced_foam" : "gt.foam");
        this.func_149672_a(SoundType.field_185856_i);
        this.func_149752_b(0.3f);
        this.func_149711_c(0.5f);
        this.func_149713_g(0);
        this.func_149675_a(true);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.isReinforced = isReinforced;
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stackInHand = playerIn.func_184586_b(hand);
        if (!stackInHand.func_190926_b() && OreDictUnifier.getOreDictionaryNames(stackInHand).contains("sand")) {
            worldIn.func_175656_a(pos, this.getPetrifiedBlock(state));
            worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187753_eE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stackInHand.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public void func_180645_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random random) {
        int lightLevel;
        int n = lightLevel = worldIn.func_175678_i(pos) && worldIn.func_72935_r() ? 16 : worldIn.func_175699_k(pos);
        if (random.nextInt(20 - lightLevel) == 0) {
            worldIn.func_175656_a(pos, this.getPetrifiedBlock(state));
        }
    }

    private IBlockState getPetrifiedBlock(IBlockState state) {
        BlockPetrifiedFoam block = this.isReinforced ? MetaBlocks.REINFORCED_PETRIFIED_FOAM : MetaBlocks.PETRIFIED_FOAM;
        return block.func_176223_P().func_177226_a((IProperty)field_176581_a, state.func_177229_b((IProperty)field_176581_a));
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return null;
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Items.field_190931_a;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

