/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.properties;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import gregtech.api.unification.ore.StoneType;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyStoneType
extends PropertyHelper<StoneType> {
    private final ImmutableList<StoneType> allowedValues;

    protected PropertyStoneType(String name, Collection<? extends StoneType> allowedValues) {
        super(name, StoneType.class);
        this.allowedValues = ImmutableList.copyOf(allowedValues);
    }

    public static PropertyStoneType create(String name, Collection<? extends StoneType> allowedValues) {
        return new PropertyStoneType(name, allowedValues);
    }

    public static PropertyStoneType create(String name, StoneType[] allowedValues) {
        return new PropertyStoneType(name, Arrays.asList(allowedValues));
    }

    @Nonnull
    public ImmutableList<StoneType> getAllowedValues() {
        return this.allowedValues;
    }

    @Nonnull
    public Optional<StoneType> func_185929_b(@Nonnull String value) {
        StoneType stoneType = (StoneType)StoneType.STONE_TYPE_REGISTRY.func_82594_a(value);
        if (this.allowedValues.contains((Object)stoneType)) {
            return Optional.of((Object)stoneType);
        }
        return Optional.absent();
    }

    @Nonnull
    public String getName(StoneType stoneType) {
        return stoneType.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyStoneType) {
            PropertyStoneType propertyStoneType = (PropertyStoneType)((Object)obj);
            return this.allowedValues.equals(propertyStoneType.allowedValues);
        }
        return false;
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.allowedValues.hashCode();
        return i;
    }
}

