/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.util.GTLog;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverCraftingTable;
import gregtech.common.covers.CoverDigitalInterface;
import gregtech.common.covers.CoverDigitalInterfaceWireless;
import gregtech.common.covers.CoverEnderFluidLink;
import gregtech.common.covers.CoverFacade;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverFluidVoidingAdvanced;
import gregtech.common.covers.CoverInfiniteWater;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.CoverItemVoidingAdvanced;
import gregtech.common.covers.CoverMachineController;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.CoverScreen;
import gregtech.common.covers.CoverShutter;
import gregtech.common.covers.CoverSolarPanel;
import gregtech.common.covers.detector.CoverActivityDetector;
import gregtech.common.covers.detector.CoverActivityDetectorAdvanced;
import gregtech.common.covers.detector.CoverDetectorEnergy;
import gregtech.common.covers.detector.CoverDetectorEnergyAdvanced;
import gregtech.common.covers.detector.CoverDetectorFluid;
import gregtech.common.covers.detector.CoverDetectorItem;
import gregtech.common.covers.filter.OreDictionaryItemFilter;
import gregtech.common.covers.filter.SimpleFluidFilter;
import gregtech.common.covers.filter.SimpleItemFilter;
import gregtech.common.covers.filter.SmartItemFilter;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.CoverDigitalInterfaceWirelessPlaceBehaviour;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import java.util.function.BiFunction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CoverBehaviors {
    public static void init() {
        GTLog.logger.info("Registering cover behaviors...");
        CoverBehaviors.registerBehavior(0, new ResourceLocation("gregtech", "conveyor.lv"), MetaItems.CONVEYOR_MODULE_LV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(1, new ResourceLocation("gregtech", "conveyor.mv"), MetaItems.CONVEYOR_MODULE_MV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(2, new ResourceLocation("gregtech", "conveyor.hv"), MetaItems.CONVEYOR_MODULE_HV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(3, new ResourceLocation("gregtech", "conveyor.ev"), MetaItems.CONVEYOR_MODULE_EV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(4, new ResourceLocation("gregtech", "conveyor.iv"), MetaItems.CONVEYOR_MODULE_IV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(5, new ResourceLocation("gregtech", "conveyor.luv"), MetaItems.CONVEYOR_MODULE_LuV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(6, new ResourceLocation("gregtech", "conveyor.zpm"), MetaItems.CONVEYOR_MODULE_ZPM, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(7, new ResourceLocation("gregtech", "conveyor.uv"), MetaItems.CONVEYOR_MODULE_UV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(10, new ResourceLocation("gregtech", "robotic_arm.lv"), MetaItems.ROBOT_ARM_LV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(11, new ResourceLocation("gregtech", "robotic_arm.mv"), MetaItems.ROBOT_ARM_MV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(12, new ResourceLocation("gregtech", "robotic_arm.hv"), MetaItems.ROBOT_ARM_HV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(13, new ResourceLocation("gregtech", "robotic_arm.ev"), MetaItems.ROBOT_ARM_EV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(14, new ResourceLocation("gregtech", "robotic_arm.iv"), MetaItems.ROBOT_ARM_IV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(15, new ResourceLocation("gregtech", "robotic_arm.luv"), MetaItems.ROBOT_ARM_LuV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(16, new ResourceLocation("gregtech", "robotic_arm.zpm"), MetaItems.ROBOT_ARM_ZPM, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(17, new ResourceLocation("gregtech", "robotic_arm.uv"), MetaItems.ROBOT_ARM_UV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(30, new ResourceLocation("gregtech", "ore_dictionary_filter"), MetaItems.ORE_DICTIONARY_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.ore_dictionary_filter.title", Textures.ORE_DICTIONARY_FILTER_OVERLAY, new OreDictionaryItemFilter()));
        CoverBehaviors.registerBehavior(31, new ResourceLocation("gregtech", "item_filter"), MetaItems.ITEM_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.item_filter.title", Textures.ITEM_FILTER_FILTER_OVERLAY, new SimpleItemFilter()));
        CoverBehaviors.registerBehavior(32, new ResourceLocation("gregtech", "fluid_filter"), MetaItems.FLUID_FILTER, (tile, side) -> new CoverFluidFilter((ICoverable)tile, (EnumFacing)side, "cover.fluid_filter.title", Textures.FLUID_FILTER_OVERLAY, new SimpleFluidFilter()));
        CoverBehaviors.registerBehavior(33, new ResourceLocation("gregtech", "shutter"), MetaItems.COVER_SHUTTER, CoverShutter::new);
        CoverBehaviors.registerBehavior(34, new ResourceLocation("gregtech", "solar_panel.basic"), MetaItems.COVER_SOLAR_PANEL, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 1L));
        CoverBehaviors.registerBehavior(35, new ResourceLocation("gregtech", "solar_panel.ulv"), MetaItems.COVER_SOLAR_PANEL_ULV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[0]));
        CoverBehaviors.registerBehavior(36, new ResourceLocation("gregtech", "solar_panel.lv"), MetaItems.COVER_SOLAR_PANEL_LV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[1]));
        CoverBehaviors.registerBehavior(37, new ResourceLocation("gregtech", "solar_panel.mv"), MetaItems.COVER_SOLAR_PANEL_MV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[2]));
        CoverBehaviors.registerBehavior(38, new ResourceLocation("gregtech", "solar_panel.hv"), MetaItems.COVER_SOLAR_PANEL_HV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[3]));
        CoverBehaviors.registerBehavior(39, new ResourceLocation("gregtech", "solar_panel.ev"), MetaItems.COVER_SOLAR_PANEL_EV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[4]));
        CoverBehaviors.registerBehavior(40, new ResourceLocation("gregtech", "solar_panel.iv"), MetaItems.COVER_SOLAR_PANEL_IV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[5]));
        CoverBehaviors.registerBehavior(41, new ResourceLocation("gregtech", "solar_panel.luv"), MetaItems.COVER_SOLAR_PANEL_LUV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[6]));
        CoverBehaviors.registerBehavior(42, new ResourceLocation("gregtech", "solar_panel.zpm"), MetaItems.COVER_SOLAR_PANEL_ZPM, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[7]));
        CoverBehaviors.registerBehavior(43, new ResourceLocation("gregtech", "solar_panel.uv"), MetaItems.COVER_SOLAR_PANEL_UV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[8]));
        CoverBehaviors.registerBehavior(45, new ResourceLocation("gregtech", "machine_controller"), MetaItems.COVER_MACHINE_CONTROLLER, CoverMachineController::new);
        CoverBehaviors.registerBehavior(46, new ResourceLocation("gregtech", "smart_filter"), MetaItems.SMART_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.smart_item_filter.title", Textures.SMART_FILTER_FILTER_OVERLAY, new SmartItemFilter()));
        CoverBehaviors.registerBehavior(47, new ResourceLocation("gregtech", "facade"), MetaItems.COVER_FACADE, CoverFacade::new);
        CoverBehaviors.registerBehavior(49, new ResourceLocation("gregtech", "screen"), MetaItems.COVER_SCREEN, CoverScreen::new);
        CoverBehaviors.registerBehavior(50, new ResourceLocation("gregtech", "energy_detector"), MetaItems.COVER_ENERGY_DETECTOR, CoverDetectorEnergy::new);
        CoverBehaviors.registerBehavior(73, new ResourceLocation("gregtech", "energy_detector_advanced"), MetaItems.COVER_ENERGY_DETECTOR_ADVANCED, CoverDetectorEnergyAdvanced::new);
        CoverBehaviors.registerBehavior(51, new ResourceLocation("gregtech", "fluid_detector"), MetaItems.COVER_FLUID_DETECTOR, CoverDetectorFluid::new);
        CoverBehaviors.registerBehavior(52, new ResourceLocation("gregtech", "item_detector"), MetaItems.COVER_ITEM_DETECTOR, CoverDetectorItem::new);
        CoverBehaviors.registerBehavior(53, new ResourceLocation("gregtech", "activity_detector"), MetaItems.COVER_ACTIVITY_DETECTOR, CoverActivityDetector::new);
        CoverBehaviors.registerBehavior(54, new ResourceLocation("gregtech", "activity_detector_advanced"), MetaItems.COVER_ACTIVITY_DETECTOR_ADVANCED, CoverActivityDetectorAdvanced::new);
        CoverBehaviors.registerBehavior(55, new ResourceLocation("gregtech", "crafting_table"), MetaItems.COVER_CRAFTING, CoverCraftingTable::new);
        CoverBehaviors.registerBehavior(56, new ResourceLocation("gregtech", "infinite_water"), MetaItems.COVER_INFINITE_WATER, CoverInfiniteWater::new);
        CoverBehaviors.registerBehavior(57, new ResourceLocation("gregtech", "ender_fluid_link"), MetaItems.COVER_ENDER_FLUID_LINK, CoverEnderFluidLink::new);
        CoverBehaviors.registerBehavior(58, new ResourceLocation("gregtech", "cover.digital"), MetaItems.COVER_DIGITAL_INTERFACE, CoverDigitalInterface::new);
        MetaItems.COVER_DIGITAL_INTERFACE_WIRELESS.addComponents(new CoverDigitalInterfaceWirelessPlaceBehaviour(CoverBehaviors.registerCover(59, new ResourceLocation("gregtech", "cover.digital.wireless"), MetaItems.COVER_DIGITAL_INTERFACE_WIRELESS, CoverDigitalInterfaceWireless::new)));
        CoverBehaviors.registerBehavior(20, new ResourceLocation("gregtech", "pump.lv"), MetaItems.ELECTRIC_PUMP_LV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 1, 1280));
        CoverBehaviors.registerBehavior(21, new ResourceLocation("gregtech", "pump.mv"), MetaItems.ELECTRIC_PUMP_MV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 2, 5120));
        CoverBehaviors.registerBehavior(22, new ResourceLocation("gregtech", "pump.hv"), MetaItems.ELECTRIC_PUMP_HV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 3, 20480));
        CoverBehaviors.registerBehavior(23, new ResourceLocation("gregtech", "pump.ev"), MetaItems.ELECTRIC_PUMP_EV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 4, 81920));
        CoverBehaviors.registerBehavior(24, new ResourceLocation("gregtech", "pump.iv"), MetaItems.ELECTRIC_PUMP_IV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 5, 327680));
        CoverBehaviors.registerBehavior(25, new ResourceLocation("gregtech", "pump.luv"), MetaItems.ELECTRIC_PUMP_LuV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 6, 0x140000));
        CoverBehaviors.registerBehavior(26, new ResourceLocation("gregtech", "pump.zpm"), MetaItems.ELECTRIC_PUMP_ZPM, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 7, 0x500000));
        CoverBehaviors.registerBehavior(27, new ResourceLocation("gregtech", "pump.uv"), MetaItems.ELECTRIC_PUMP_UV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 8, 0x1400000));
        CoverBehaviors.registerBehavior(60, new ResourceLocation("gregtech", "fluid.regulator.lv"), MetaItems.FLUID_REGULATOR_LV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 1, 1280));
        CoverBehaviors.registerBehavior(61, new ResourceLocation("gregtech", "fluid.regulator.mv"), MetaItems.FLUID_REGULATOR_MV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 2, 5120));
        CoverBehaviors.registerBehavior(62, new ResourceLocation("gregtech", "fluid.regulator.hv"), MetaItems.FLUID_REGULATOR_HV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 3, 20480));
        CoverBehaviors.registerBehavior(63, new ResourceLocation("gregtech", "fluid.regulator.ev"), MetaItems.FLUID_REGULATOR_EV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 4, 81920));
        CoverBehaviors.registerBehavior(64, new ResourceLocation("gregtech", "fluid.regulator.iv"), MetaItems.FLUID_REGULATOR_IV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 5, 327680));
        CoverBehaviors.registerBehavior(65, new ResourceLocation("gregtech", "fluid.regulator.luv"), MetaItems.FLUID_REGULATOR_LUV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 6, 0x140000));
        CoverBehaviors.registerBehavior(66, new ResourceLocation("gregtech", "fluid.regulator.zpm"), MetaItems.FLUID_REGULATOR_ZPM, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 7, 0x500000));
        CoverBehaviors.registerBehavior(67, new ResourceLocation("gregtech", "fluid.regulator.uv"), MetaItems.FLUID_REGULATOR_UV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 8, 0x1400000));
        CoverBehaviors.registerBehavior(68, new ResourceLocation("gregtech", "conveyor.uhv"), MetaItems.CONVEYOR_MODULE_UHV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 9, 1024));
        CoverBehaviors.registerBehavior(69, new ResourceLocation("gregtech", "conveyor.uev"), MetaItems.CONVEYOR_MODULE_UEV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 10, 1024));
        CoverBehaviors.registerBehavior(70, new ResourceLocation("gregtech", "conveyor.uiv"), MetaItems.CONVEYOR_MODULE_UIV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 11, 1024));
        CoverBehaviors.registerBehavior(71, new ResourceLocation("gregtech", "conveyor.uxv"), MetaItems.CONVEYOR_MODULE_UXV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 12, 1024));
        CoverBehaviors.registerBehavior(72, new ResourceLocation("gregtech", "conveyor.opv"), MetaItems.CONVEYOR_MODULE_OpV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 13, 1024));
        CoverBehaviors.registerBehavior(78, new ResourceLocation("gregtech", "robotic_arm.uhv"), MetaItems.ROBOT_ARM_UHV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 9, 1024));
        CoverBehaviors.registerBehavior(79, new ResourceLocation("gregtech", "robotic_arm.uev"), MetaItems.ROBOT_ARM_UEV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 10, 1024));
        CoverBehaviors.registerBehavior(80, new ResourceLocation("gregtech", "robotic_arm.uiv"), MetaItems.ROBOT_ARM_UIV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 11, 1024));
        CoverBehaviors.registerBehavior(81, new ResourceLocation("gregtech", "robotic_arm.uxv"), MetaItems.ROBOT_ARM_UXV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 12, 1024));
        CoverBehaviors.registerBehavior(82, new ResourceLocation("gregtech", "robotic_arm.opv"), MetaItems.ROBOT_ARM_OpV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 13, 1024));
        CoverBehaviors.registerBehavior(88, new ResourceLocation("gregtech", "pump.uhv"), MetaItems.ELECTRIC_PUMP_UHV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 9, 0x1400000));
        CoverBehaviors.registerBehavior(89, new ResourceLocation("gregtech", "pump.uev"), MetaItems.ELECTRIC_PUMP_UEV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 10, 0x1400000));
        CoverBehaviors.registerBehavior(90, new ResourceLocation("gregtech", "pump.uiv"), MetaItems.ELECTRIC_PUMP_UIV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 11, 0x1400000));
        CoverBehaviors.registerBehavior(91, new ResourceLocation("gregtech", "pump.uxv"), MetaItems.ELECTRIC_PUMP_UXV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 12, 0x1400000));
        CoverBehaviors.registerBehavior(92, new ResourceLocation("gregtech", "pump.opv"), MetaItems.ELECTRIC_PUMP_OpV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 13, 0x1400000));
        CoverBehaviors.registerBehavior(100, new ResourceLocation("gregtech", "fluid_voiding"), MetaItems.COVER_FLUID_VOIDING, CoverFluidVoiding::new);
        CoverBehaviors.registerBehavior(101, new ResourceLocation("gregtech", "fluid_voiding.advanced"), MetaItems.COVER_FLUID_VOIDING_ADVANCED, CoverFluidVoidingAdvanced::new);
        CoverBehaviors.registerBehavior(102, new ResourceLocation("gregtech", "item_voiding"), MetaItems.COVER_ITEM_VOIDING, CoverItemVoiding::new);
        CoverBehaviors.registerBehavior(103, new ResourceLocation("gregtech", "item_voiding.advanced"), MetaItems.COVER_ITEM_VOIDING_ADVANCED, CoverItemVoidingAdvanced::new);
    }

    public static void registerBehavior(int coverNetworkId, ResourceLocation coverId, MetaItem.MetaValueItem placerItem, BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        placerItem.addComponents(new CoverPlaceBehavior(CoverBehaviors.registerCover(coverNetworkId, coverId, placerItem, behaviorCreator)));
    }

    public static CoverDefinition registerCover(int coverNetworkId, ResourceLocation coverId, MetaItem.MetaValueItem itemStack, BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        CoverDefinition coverDefinition = new CoverDefinition(coverId, behaviorCreator, itemStack.getStackForm());
        GregTechAPI.COVER_REGISTRY.register(coverNetworkId, coverId, coverDefinition);
        return coverDefinition;
    }
}

