/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GradientUtil;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class FoamSprayerBehavior
implements IItemCapabilityProvider,
IItemDurabilityManager,
IItemBehaviour,
ISubItemHandler {
    private static final int FLUID_PER_BLOCK = 100;
    private final Pair<Color, Color> durabilityBarColors = GradientUtil.getGradient(Materials.ConstructionFoam.getMaterialRGB(), 10);

    @Override
    public ActionResult<ItemStack> onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack fluidStack = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
        if (fluidStack != null && fluidStack.amount >= 100) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState initialBlockState = world.func_180495_p(pos);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            if (initialBlockState.func_177230_c() instanceof BlockFrame) {
                int blocksToFoam = fluidStack.amount / 100;
                int blocksFoamed = FoamSprayerBehavior.foamAllFrameBlocks(world, pos, blocksToFoam, player.func_70093_af());
                if (!player.field_71075_bZ.field_75098_d) {
                    fluidHandlerItem.drain(100 * blocksFoamed, true);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
            }
            if (offsetState.func_177230_c().func_176200_f((IBlockAccess)world, offsetPos)) {
                int blocksToFoam = fluidStack.amount / 100;
                int blocksFoamed = FoamSprayerBehavior.foamReplacableBlocks(world, offsetPos, blocksToFoam);
                if (!player.field_71075_bZ.field_75098_d) {
                    fluidHandlerItem.drain(100 * blocksFoamed, true);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack itemStack) {
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandlerItem == null) {
            return 0.0;
        }
        IFluidTankProperties fluidTankProperties = fluidHandlerItem.getTankProperties()[0];
        FluidStack fluidStack = fluidTankProperties.getContents();
        return fluidStack == null ? 0.0 : (double)fluidStack.amount / (double)fluidTankProperties.getCapacity();
    }

    @Override
    @Nullable
    public Pair<Color, Color> getDurabilityColorsForDisplay(ItemStack itemStack) {
        return this.durabilityBarColors;
    }

    @Override
    public ICapabilityProvider createProvider(ItemStack itemStack) {
        return new FluidHandlerItemStack(itemStack, 10000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && fluid.isFluidEqual(Materials.ConstructionFoam.getFluid(1));
            }
        };
    }

    private static int foamAllFrameBlocks(World world, BlockPos pos, int maxBlocksToFoam, boolean isSneaking) {
        IBlockState blockState;
        List<BlockPos> frameBlocks = FoamSprayerBehavior.gatherFrameBlocks(world, pos, 1024);
        frameBlocks = frameBlocks.subList(0, Math.min(frameBlocks.size(), maxBlocksToFoam));
        for (BlockPos framePos : frameBlocks) {
            boolean isNormalFrame;
            blockState = world.func_180495_p(framePos);
            boolean bl = isNormalFrame = blockState.func_177230_c().func_149688_o(blockState) == Material.field_151575_d || isSneaking;
            if (isNormalFrame) {
                blockState.func_177230_c().func_176226_b(world, framePos, blockState, 0);
            }
            IBlockState foamToPlace = isNormalFrame ? MetaBlocks.FOAM.func_176223_P() : MetaBlocks.REINFORCED_FOAM.func_176223_P();
            world.func_180501_a(framePos, foamToPlace, 2);
        }
        for (BlockPos blockPos : frameBlocks) {
            blockState = world.func_180495_p(blockPos);
            world.func_175722_b(blockPos, blockState.func_177230_c(), true);
        }
        return frameBlocks.size();
    }

    private static int foamReplacableBlocks(World world, BlockPos pos, int maxBlocksToFoam) {
        List<BlockPos> replacableBlocks = FoamSprayerBehavior.gatherReplacableBlocks(world, pos, 10);
        replacableBlocks = replacableBlocks.subList(0, Math.min(replacableBlocks.size(), maxBlocksToFoam));
        for (BlockPos blockPos : replacableBlocks) {
            world.func_180501_a(blockPos, MetaBlocks.FOAM.func_176223_P(), 2);
        }
        for (BlockPos blockPos : replacableBlocks) {
            IBlockState blockState = world.func_180495_p(blockPos);
            world.func_175722_b(pos, blockState.func_177230_c(), true);
        }
        return replacableBlocks.size();
    }

    private static List<BlockPos> gatherReplacableBlocks(World worldIn, BlockPos centerPos, int maxRadiusSq) {
        HashSet<BlockPos> observedSet = new HashSet<BlockPos>();
        ArrayList<BlockPos> resultAirBlocks = new ArrayList<BlockPos>();
        observedSet.add(centerPos);
        resultAirBlocks.add(centerPos);
        Stack<EnumFacing> moveStack = new Stack<EnumFacing>();
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(centerPos);
        while (true) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                currentPos.func_189536_c(facing);
                IBlockState blockStateHere = worldIn.func_180495_p((BlockPos)currentPos);
                if (blockStateHere.func_177230_c().func_176200_f((IBlockAccess)worldIn, (BlockPos)currentPos) && currentPos.func_177951_i((Vec3i)centerPos) <= (double)maxRadiusSq && !observedSet.contains(currentPos)) {
                    BlockPos immutablePos = currentPos.func_185334_h();
                    observedSet.add(immutablePos);
                    resultAirBlocks.add(immutablePos);
                    moveStack.push(facing.func_176734_d());
                    continue;
                }
                currentPos.func_189536_c(facing.func_176734_d());
            }
            if (moveStack.isEmpty()) break;
            currentPos.func_189536_c((EnumFacing)moveStack.pop());
        }
        resultAirBlocks.sort(Comparator.comparing(it -> it.func_177951_i((Vec3i)centerPos)));
        return resultAirBlocks;
    }

    private static List<BlockPos> gatherFrameBlocks(World worldIn, BlockPos centerPos, int maxRadiusSq) {
        HashSet<BlockPos> observedSet = new HashSet<BlockPos>();
        ArrayList<BlockPos> resultFrameBlocks = new ArrayList<BlockPos>();
        observedSet.add(centerPos);
        resultFrameBlocks.add(centerPos);
        IBlockState frameState = null;
        Stack<EnumFacing> moveStack = new Stack<EnumFacing>();
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(centerPos);
        while (true) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                currentPos.func_189536_c(facing);
                IBlockState blockStateHere = worldIn.func_180495_p((BlockPos)currentPos);
                if (blockStateHere.func_177230_c() instanceof BlockFrame && currentPos.func_177951_i((Vec3i)centerPos) <= (double)maxRadiusSq && (frameState == null || frameState == blockStateHere) && !observedSet.contains(currentPos)) {
                    BlockPos immutablePos = currentPos.func_185334_h();
                    observedSet.add(immutablePos);
                    resultFrameBlocks.add(immutablePos);
                    moveStack.push(facing.func_176734_d());
                    frameState = blockStateHere;
                    continue;
                }
                currentPos.func_189536_c(facing.func_176734_d());
            }
            if (moveStack.isEmpty()) break;
            currentPos.func_189536_c((EnumFacing)moveStack.pop());
        }
        resultFrameBlocks.sort(Comparator.comparing(it -> it.func_177951_i((Vec3i)centerPos)));
        return resultFrameBlocks;
    }

    @Override
    public String getItemSubType(ItemStack itemStack) {
        return "";
    }

    @Override
    public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        ItemStack copy = itemStack.func_77946_l();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandlerItem != null) {
            fluidHandlerItem.fill(Materials.ConstructionFoam.getFluid(10000), true);
            subItems.add((Object)copy);
        } else {
            subItems.add((Object)itemStack);
        }
    }
}

