/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gregtech.api.items.metaitem.stats.IEnchantabilityHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.items.behaviors.ToggleEnergyConsumerBehavior;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NanoSaberBehavior
extends ToggleEnergyConsumerBehavior
implements IEnchantabilityHelper {
    public static final ResourceLocation OVERRIDE_KEY_LOCATION = new ResourceLocation("gregtech", "nano_saber_active");
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A288-9C13A33DB5CF");
    protected static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4288-B01B-BCCE9785ACA3");
    private final double baseAttackDamage;
    private final double additionalAttackDamage;

    public NanoSaberBehavior() {
        super(ConfigHolder.tools.nanoSaber.energyConsumption);
        this.baseAttackDamage = ConfigHolder.tools.nanoSaber.nanoSaberBaseDamage;
        this.additionalAttackDamage = ConfigHolder.tools.nanoSaber.nanoSaberDamageBoost;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            double attackDamage = this.baseAttackDamage + (NanoSaberBehavior.isItemActive(stack) ? this.additionalAttackDamage : 0.0);
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", -2.0, 0));
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon Modifier", attackDamage, 0));
        }
        return modifiers;
    }

    @Override
    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @Override
    public int getItemEnchantability(ItemStack stack) {
        return 33;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.field_77351_y == null) {
            return false;
        }
        return enchantment != Enchantments.field_185307_s && enchantment != Enchantments.field_185296_A && enchantment.field_77351_y.func_77557_a(Items.field_151040_l);
    }
}

