/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiFluidHatch;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;

public class MetaTileEntityDistillationTower
extends RecipeMapMultiblockController {
    public MetaTileEntityDistillationTower(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.DISTILLATION_RECIPES);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityDistillationTower(this.metaTileEntityId);
    }

    @Override
    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return Vec3i::func_177956_o;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        FluidStack stackInTank;
        if (this.isStructureFormed() && (stackInTank = this.importFluids.drain(Integer.MAX_VALUE, false)) != null && stackInTank.amount > 0) {
            TextComponentTranslation fluidName = new TextComponentTranslation(stackInTank.getFluid().getUnlocalizedName(stackInTank), new Object[0]);
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.distillation_tower.distilling_fluid", new Object[]{fluidName}));
        }
        super.addDisplayText(textList);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start(RelativeDirection.RIGHT, RelativeDirection.FRONT, RelativeDirection.UP).aisle("YSY", "YYY", "YYY").aisle("XXX", "X#X", "XXX").setRepeatable(1, 11).aisle("XXX", "XXX", "XXX").where('S', this.selfPredicate()).where('Y', MetaTileEntityDistillationTower.states(this.getCasingState()).or(MetaTileEntityDistillationTower.abilities(MultiblockAbility.EXPORT_ITEMS).setMaxGlobalLimited(1)).or(MetaTileEntityDistillationTower.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(MetaTileEntityDistillationTower.abilities(MultiblockAbility.IMPORT_FLUIDS).setExactLimit(1))).where('X', MetaTileEntityDistillationTower.states(this.getCasingState()).or(MetaTileEntityDistillationTower.metaTileEntities((MetaTileEntity[])MultiblockAbility.REGISTRY.get(MultiblockAbility.EXPORT_FLUIDS).stream().filter(mte -> !(mte instanceof MetaTileEntityMultiFluidHatch)).toArray(MetaTileEntity[]::new)).setMinLayerLimited(1).setMaxLayerLimited(1)).or(this.autoAbilities(true, false))).where('#', MetaTileEntityDistillationTower.air()).build();
    }

    @Override
    protected boolean allowSameFluidFillForOutputs() {
        return false;
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.CLEAN_STAINLESS_STEEL_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN);
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.DISTILLATION_TOWER_OVERLAY;
    }

    @Override
    public int getFluidOutputLimit() {
        return this.getOutputFluidInventory().getTanks();
    }
}

