/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class MetaTileEntityLargeCombustionEngine
extends FuelMultiblockController {
    private final int tier;
    private final boolean isExtreme;
    private boolean boostAllowed;

    public MetaTileEntityLargeCombustionEngine(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, RecipeMaps.COMBUSTION_GENERATOR_FUELS, tier);
        this.recipeMapWorkable = new LargeCombustionEngineWorkableHandler(this, tier > 4);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
        this.tier = tier;
        this.isExtreme = tier > 4;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeCombustionEngine(this.metaTileEntityId, this.tier);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        if (this.isStructureFormed()) {
            if (this.getInputFluidInventory() != null) {
                FluidStack lubricantStack = this.getInputFluidInventory().drain(Materials.Lubricant.getFluid(Integer.MAX_VALUE), false);
                FluidStack oxygenStack = this.getInputFluidInventory().drain(Materials.Oxygen.getFluid(Integer.MAX_VALUE), false);
                FluidStack liquidOxygenStack = this.getInputFluidInventory().drain(Materials.LiquidOxygen.getFluid(Integer.MAX_VALUE), false);
                int lubricantAmount = lubricantStack == null ? 0 : lubricantStack.amount;
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.lubricant_amount", new Object[]{lubricantAmount}));
                if (this.boostAllowed) {
                    if (!this.isExtreme) {
                        if (((LargeCombustionEngineWorkableHandler)this.recipeMapWorkable).isOxygenBoosted) {
                            int oxygenAmount = oxygenStack == null ? 0 : oxygenStack.amount;
                            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.oxygen_amount", new Object[]{oxygenAmount}));
                            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.oxygen_boosted", new Object[0]));
                        } else {
                            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.supply_oxygen_to_boost", new Object[0]));
                        }
                    } else if (((LargeCombustionEngineWorkableHandler)this.recipeMapWorkable).isOxygenBoosted) {
                        int liquidOxygenAmount = liquidOxygenStack == null ? 0 : liquidOxygenStack.amount;
                        textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.liquid_oxygen_amount", new Object[]{liquidOxygenAmount}));
                        textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.liquid_oxygen_boosted", new Object[0]));
                    } else {
                        textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.supply_liquid_oxygen_to_boost", new Object[0]));
                    }
                } else {
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.boost_disallowed", new Object[0]));
                }
            }
            if (this.isStructureObstructed()) {
                textList.add(new TextComponentTranslation("gregtech.multiblock.large_combustion_engine.obstructed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[this.tier]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_hour_lubricant", (Object[])new Object[]{1000}));
        if (this.isExtreme) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.large_combustion_engine.tooltip.boost_extreme", (Object[])new Object[]{GTValues.V[this.tier] * 4L}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.large_combustion_engine.tooltip.boost_regular", (Object[])new Object[]{GTValues.V[this.tier] * 3L}));
        }
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XDX", "XXX").aisle("XCX", "CGC", "XCX").aisle("XCX", "CGC", "XCX").aisle("AAA", "AYA", "AAA").where('X', MetaTileEntityLargeCombustionEngine.states(this.getCasingState())).where('G', MetaTileEntityLargeCombustionEngine.states(this.getGearboxState())).where('C', MetaTileEntityLargeCombustionEngine.states(this.getCasingState()).setMinGlobalLimited(3).or(this.autoAbilities(false, true, true, true, true, true, true))).where('D', MetaTileEntityLargeCombustionEngine.metaTileEntities((MetaTileEntity[])MultiblockAbility.REGISTRY.get(MultiblockAbility.OUTPUT_ENERGY).stream().filter(mte -> {
            IEnergyContainer container = mte.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null);
            return container != null && container.getOutputVoltage() * container.getOutputAmperage() >= GTValues.V[this.tier];
        }).toArray(MetaTileEntity[]::new)).addTooltip("gregtech.multiblock.pattern.error.limited.1", GTValues.VN[this.tier])).where('A', MetaTileEntityLargeCombustionEngine.states(this.getIntakeState()).addTooltips("gregtech.multiblock.pattern.clear_amount_1")).where('Y', this.selfPredicate()).build();
    }

    public IBlockState getCasingState() {
        return this.isExtreme ? MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST) : MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE);
    }

    public IBlockState getGearboxState() {
        return this.isExtreme ? MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_GEARBOX) : MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TITANIUM_GEARBOX);
    }

    public IBlockState getIntakeState() {
        return this.isExtreme ? MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.EXTREME_ENGINE_INTAKE_CASING) : MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.ENGINE_INTAKE_CASING);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.isExtreme ? Textures.ROBUST_TUNGSTENSTEEL_CASING : Textures.STABLE_TITANIUM_CASING;
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return this.isExtreme ? Textures.EXTREME_COMBUSTION_ENGINE_OVERLAY : Textures.LARGE_COMBUSTION_ENGINE_OVERLAY;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public boolean isStructureObstructed() {
        return super.isStructureObstructed() || this.checkIntakesObstructed();
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        IEnergyContainer energyContainer = this.getEnergyContainer();
        this.boostAllowed = energyContainer != null && energyContainer.getOutputVoltage() >= GTValues.V[this.tier + 1];
    }

    private boolean checkIntakesObstructed() {
        EnumFacing facing = this.getFrontFacing();
        boolean permuteXZ = facing.func_176740_k() == EnumFacing.Axis.Z;
        BlockPos centerPos = this.getPos().func_177972_a(facing);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                if (x == 0 && y == 0) continue;
                BlockPos blockPos = centerPos.func_177982_a(permuteXZ ? x : 0, y, permuteXZ ? 0 : x);
                IBlockState blockState = this.getWorld().func_180495_p(blockPos);
                if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getWorld(), blockPos)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    public boolean isBoostAllowed() {
        return this.boostAllowed;
    }

    private static class LargeCombustionEngineWorkableHandler
    extends MultiblockFuelRecipeLogic {
        private boolean isOxygenBoosted = false;
        private final MetaTileEntityLargeCombustionEngine combustionEngine;
        private final boolean isExtreme;
        private final int tier;
        private static final FluidStack OXYGEN_STACK = Materials.Oxygen.getFluid(20);
        private static final FluidStack LIQUID_OXYGEN_STACK = Materials.LiquidOxygen.getFluid(80);
        private static final FluidStack LUBRICANT_STACK = Materials.Lubricant.getFluid(1);

        public LargeCombustionEngineWorkableHandler(RecipeMapMultiblockController tileEntity, boolean isExtreme) {
            super(tileEntity);
            this.combustionEngine = (MetaTileEntityLargeCombustionEngine)tileEntity;
            this.isExtreme = isExtreme;
            this.tier = isExtreme ? 5 : 4;
        }

        @Override
        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
                IMultipleTankHandler inputTank;
                if (this.totalContinuousRunningTime == 1L || this.totalContinuousRunningTime % 72L == 0L) {
                    inputTank = this.combustionEngine.getInputFluidInventory();
                    if (LUBRICANT_STACK.isFluidStackIdentical(inputTank.drain(LUBRICANT_STACK, false))) {
                        inputTank.drain(LUBRICANT_STACK, true);
                    } else {
                        this.invalidate();
                        return;
                    }
                }
                if (this.combustionEngine.isBoostAllowed() && (this.totalContinuousRunningTime == 1L || this.totalContinuousRunningTime % 20L == 0L)) {
                    FluidStack boosterStack;
                    inputTank = this.combustionEngine.getInputFluidInventory();
                    FluidStack fluidStack = boosterStack = this.isExtreme ? LIQUID_OXYGEN_STACK : OXYGEN_STACK;
                    if (boosterStack.isFluidStackIdentical(inputTank.drain(boosterStack, false))) {
                        this.isOxygenBoosted = true;
                        inputTank.drain(boosterStack, true);
                    } else {
                        this.isOxygenBoosted = false;
                    }
                }
                this.drawEnergy(this.recipeEUt, false);
                if (++this.progressTime > this.maxProgressTime) {
                    this.completeRecipe();
                }
            }
        }

        @Override
        protected boolean shouldSearchForRecipes() {
            return super.shouldSearchForRecipes() && LUBRICANT_STACK.isFluidStackIdentical(((RecipeMapMultiblockController)this.metaTileEntity).getInputFluidInventory().drain(LUBRICANT_STACK, false));
        }

        @Override
        protected long getMaxVoltage() {
            if (this.isOxygenBoosted) {
                return GTValues.V[this.tier] * 2L;
            }
            return GTValues.V[this.tier];
        }

        @Override
        protected long boostProduction(long production) {
            if (this.isOxygenBoosted) {
                if (!this.isExtreme) {
                    return production * 3L / 2L;
                }
                return production * 2L;
            }
            return production;
        }

        @Override
        public void invalidate() {
            this.isOxygenBoosted = false;
            super.invalidate();
        }
    }
}

