/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.tile;

import codechicken.lib.vec.Cuboid6;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.util.GTUtility;
import gregtech.api.util.PerTickLongCounter;
import gregtech.api.util.TaskScheduler;
import gregtech.client.particle.GTOverheatParticle;
import gregtech.client.particle.GTParticleManager;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.net.EnergyNet;
import gregtech.common.pipelike.cable.net.EnergyNetHandler;
import gregtech.common.pipelike.cable.net.WorldENet;
import gregtech.common.pipelike.cable.tile.AveragingPerTickCounter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCable
extends TileEntityMaterialPipeBase<Insulation, WireProperties>
implements IDataInfoProvider {
    private final EnumMap<EnumFacing, EnergyNetHandler> handlers = new EnumMap(EnumFacing.class);
    private final PerTickLongCounter maxVoltageCounter = new PerTickLongCounter(0L);
    private final AveragingPerTickCounter averageVoltageCounter = new AveragingPerTickCounter(0L, 20);
    private final AveragingPerTickCounter averageAmperageCounter = new AveragingPerTickCounter(0L, 20);
    private EnergyNetHandler defaultHandler;
    private final IEnergyContainer clientCapability = IEnergyContainer.DEFAULT;
    private WeakReference<EnergyNet> currentEnergyNet = new WeakReference<Object>(null);
    @SideOnly(value=Side.CLIENT)
    private GTOverheatParticle particle;
    private int heatQueue;
    private int temperature = 293;
    private final int meltTemp = 3000;
    private boolean isTicking = false;

    @Override
    public Class<Insulation> getPipeTypeClass() {
        return Insulation.class;
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    @Override
    public boolean canHaveBlockedFaces() {
        return false;
    }

    private void initHandlers() {
        EnergyNet net = this.getEnergyNet();
        if (net == null) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.handlers.put(facing, new EnergyNetHandler(net, this, facing));
        }
        this.defaultHandler = new EnergyNetHandler(net, this, null);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.setTemperature(this.temperature);
            if (this.temperature > 293) {
                TaskScheduler.scheduleTask(this.field_145850_b, this::update);
            }
        }
    }

    public boolean incrementAmperage(long amps, long voltage) {
        if (voltage > this.maxVoltageCounter.get(this.field_145850_b)) {
            this.maxVoltageCounter.set(this.field_145850_b, voltage);
        }
        this.averageVoltageCounter.increment(this.field_145850_b, voltage);
        this.averageAmperageCounter.increment(this.field_145850_b, amps);
        int dif = (int)(this.averageAmperageCounter.getLast(this.field_145850_b) - this.getMaxAmperage());
        if (dif > 0) {
            this.applyHeat(dif * 40);
            return true;
        }
        return false;
    }

    public void applyHeat(int amount) {
        this.heatQueue += amount;
        if (!this.field_145850_b.field_72995_K && !this.isTicking && this.temperature + this.heatQueue > 293) {
            TaskScheduler.scheduleTask(this.field_145850_b, this::update);
            this.isTicking = true;
        }
    }

    private boolean update() {
        if (this.heatQueue > 0) {
            this.setTemperature(this.temperature + this.heatQueue);
        }
        if (this.temperature >= 3000) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150480_ab.func_176223_P());
            this.isTicking = false;
            return false;
        }
        if (this.temperature <= 293) {
            this.isTicking = false;
            return false;
        }
        if (((Insulation)this.getPipeType()).insulationLevel >= 0 && this.temperature >= 1500 && (double)GTValues.RNG.nextFloat() < 0.1) {
            this.uninsulate();
            this.isTicking = false;
            return false;
        }
        if (this.heatQueue == 0) {
            this.setTemperature((int)((double)this.temperature - Math.pow(this.temperature - 293, 0.35)));
        } else {
            this.heatQueue = 0;
        }
        return true;
    }

    private void uninsulate() {
        int temp = this.temperature;
        this.setTemperature(293);
        int index = ((Insulation)this.getPipeType()).insulationLevel;
        BlockCable newBlock = MetaBlocks.CABLES[index];
        this.field_145850_b.func_175656_a(this.field_174879_c, newBlock.func_176223_P());
        TileEntityCable newCable = (TileEntityCable)this.field_145850_b.func_175625_s(this.field_174879_c);
        if (newCable != null) {
            newCable.setPipeData(newBlock, newBlock.getItemPipeType(null), this.getPipeMaterial());
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!this.isConnected(facing)) continue;
                newCable.setConnection(facing, true, true);
            }
            newCable.setTemperature(temp);
            if (!newCable.isTicking) {
                TaskScheduler.scheduleTask(this.field_145850_b, newCable::update);
                newCable.isTicking = true;
            }
        }
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
        this.field_145850_b.func_175664_x(this.field_174879_c);
        if (!this.field_145850_b.field_72995_K) {
            this.writeCustomData(100, buf -> buf.func_150787_b(temperature));
        } else if (temperature <= 293) {
            if (this.isParticleAlive()) {
                this.particle.func_187112_i();
            }
        } else {
            if (!this.isParticleAlive()) {
                this.createParticle();
            }
            this.particle.setTemperature(temperature);
        }
    }

    public int getDefaultTemp() {
        return 293;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getMeltTemp() {
        return 3000;
    }

    @SideOnly(value=Side.CLIENT)
    public void createParticle() {
        this.particle = new GTOverheatParticle(this.field_145850_b, this.field_174879_c, 3000, this.getPipeBoxes(), ((Insulation)this.getPipeType()).insulationLevel >= 0);
        GTParticleManager.INSTANCE.addEffect(this.particle);
    }

    @SideOnly(value=Side.CLIENT)
    public void killParticle() {
        if (this.isParticleAlive()) {
            this.particle.func_187112_i();
            this.particle = null;
        }
    }

    public double getAverageAmperage() {
        return this.averageAmperageCounter.getAverage(this.func_145831_w());
    }

    public long getCurrentMaxVoltage() {
        return this.maxVoltageCounter.get(this.func_145831_w());
    }

    public double getAverageVoltage() {
        return this.averageVoltageCounter.getAverage(this.func_145831_w());
    }

    public long getMaxAmperage() {
        return ((WireProperties)this.getNodeData()).getAmperage();
    }

    public long getMaxVoltage() {
        return ((WireProperties)this.getNodeData()).getVoltage();
    }

    @Override
    @Nullable
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (this.field_145850_b.field_72995_K) {
                return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this.clientCapability);
            }
            if (this.handlers.size() == 0) {
                this.initHandlers();
            }
            this.checkNetwork();
            return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this.handlers.getOrDefault(facing, this.defaultHandler));
        }
        return super.getCapabilityInternal(capability, facing);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            EnergyNet current = this.getEnergyNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (EnergyNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    private EnergyNet getEnergyNet() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        EnergyNet currentEnergyNet = (EnergyNet)this.currentEnergyNet.get();
        if (currentEnergyNet != null && currentEnergyNet.isValid() && currentEnergyNet.containsNode(this.func_174877_v())) {
            return currentEnergyNet;
        }
        WorldENet worldENet = WorldENet.getWorldENet(this.func_145831_w());
        currentEnergyNet = (EnergyNet)worldENet.getNetFromPos(this.func_174877_v());
        if (currentEnergyNet != null) {
            this.currentEnergyNet = new WeakReference<EnergyNet>(currentEnergyNet);
        }
        return currentEnergyNet;
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0x404040;
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        if (discriminator == 100) {
            this.setTemperature(buf.func_150792_a());
        } else {
            super.receiveCustomData(discriminator, buf);
            if (this.isParticleAlive() && discriminator == -2) {
                this.particle.updatePipeBoxes(this.getPipeBoxes());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isParticleAlive() {
        return this.particle != null && this.particle.func_187113_k();
    }

    protected List<Cuboid6> getPipeBoxes() {
        ArrayList<Cuboid6> pipeBoxes = new ArrayList<Cuboid6>();
        float thickness = ((Insulation)this.getPipeType()).getThickness();
        if ((this.getConnections() & 0x3F) < 63) {
            pipeBoxes.add(BlockPipe.getSideBox(null, thickness));
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.isConnected(facing)) continue;
            pipeBoxes.add(BlockPipe.getSideBox(facing, thickness));
        }
        return pipeBoxes;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Temp", this.temperature);
        return compound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.temperature = compound.func_74762_e("Temp");
    }

    @Override
    @Nonnull
    public List<ITextComponent> getDataInfo() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.eut_per_sec", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.getAverageVoltage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.amp_per_sec", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.getAverageAmperage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        return list;
    }
}

