/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe.net;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.util.FacingPos;
import gregtech.common.pipelike.itempipe.net.ItemNetWalker;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemPipeNet
extends PipeNet<ItemPipeProperties> {
    private final Map<BlockPos, List<Inventory>> NET_DATA = new HashMap<BlockPos, List<Inventory>>();

    public ItemPipeNet(WorldPipeNet<ItemPipeProperties, ? extends PipeNet<ItemPipeProperties>> world) {
        super(world);
    }

    public List<Inventory> getNetData(BlockPos pipePos, EnumFacing facing) {
        List<Inventory> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = ItemNetWalker.createNetData(this.getWorldData(), pipePos, facing);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(inv -> ((Inventory)inv).properties.getPriority()));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<ItemPipeProperties>> transferredNodes, PipeNet<ItemPipeProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((ItemPipeNet)parentNet).NET_DATA.clear();
    }

    @Override
    protected void writeNodeData(ItemPipeProperties nodeData, NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Resistance", nodeData.getPriority());
        tagCompound.func_74776_a("Rate", nodeData.getTransferRate());
    }

    @Override
    protected ItemPipeProperties readNodeData(NBTTagCompound tagCompound) {
        return new ItemPipeProperties(tagCompound.func_74762_e("Range"), tagCompound.func_74760_g("Rate"));
    }

    public static class Inventory {
        private final BlockPos pipePos;
        private final EnumFacing faceToHandler;
        private final int distance;
        private final ItemPipeProperties properties;
        private final List<Predicate<ItemStack>> filters;

        public Inventory(BlockPos pipePos, EnumFacing facing, int distance, ItemPipeProperties properties, List<Predicate<ItemStack>> filters) {
            this.pipePos = pipePos;
            this.faceToHandler = facing;
            this.distance = distance;
            this.properties = properties;
            this.filters = filters;
        }

        public BlockPos getPipePos() {
            return this.pipePos;
        }

        public EnumFacing getFaceToHandler() {
            return this.faceToHandler;
        }

        public int getDistance() {
            return this.distance;
        }

        public ItemPipeProperties getProperties() {
            return this.properties;
        }

        public List<Predicate<ItemStack>> getFilters() {
            return this.filters;
        }

        public boolean matchesFilters(ItemStack stack) {
            for (Predicate<ItemStack> filter : this.filters) {
                if (filter.test(stack)) continue;
                return false;
            }
            return true;
        }

        public BlockPos getHandlerPos() {
            return this.pipePos.func_177972_a(this.faceToHandler);
        }

        public IItemHandler getHandler(World world) {
            TileEntity tile = world.func_175625_s(this.getHandlerPos());
            if (tile != null) {
                return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.faceToHandler.func_176734_d());
            }
            return null;
        }

        public FacingPos toFacingPos() {
            return new FacingPos(this.pipePos, this.faceToHandler);
        }
    }
}

