/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.batterymanager;

import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.common.items.MetaItems;
import gregtech.common.terminal.app.batterymanager.BatteryWidget;
import gregtech.common.terminal.hardware.BatteryHardware;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class BatteryManagerApp
extends AbstractApplication {
    public BatteryManagerApp() {
        super("battery");
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(MetaItems.BATTERY_HV_SODIUM.getStackForm(), new ItemStack[0]);
    }

    @Override
    public boolean isClientSideApp() {
        return true;
    }

    @Override
    public AbstractApplication initApp() {
        if (this.isClient) {
            this.addWidget(new ImageWidget(5, 5, 323, 222, TerminalTheme.COLOR_B_2));
            this.addWidget(new ImageWidget(170, 15, 1, 202, TerminalTheme.COLOR_7));
            this.addWidget(new BatteryWidget(10, 41, 150, 150, this.getOs()));
            this.addBatteryApps();
        }
        return this;
    }

    private void addBatteryApps() {
        AtomicInteger index = new AtomicInteger();
        for (AbstractApplication installed : this.getOs().installedApps) {
            TerminalRegistry.getAppHardwareDemand(installed.getRegistryName(), this.getOs().tabletNBT.func_74775_l(installed.getRegistryName()).func_74762_e("_tier")).stream().filter(i -> i instanceof BatteryHardware).findFirst().ifPresent(battery -> {
                long charge = ((BatteryHardware)battery).getCharge();
                this.addWidget(new RectButtonWidget(180 + index.get() % 5 * 30, 15 + index.get() / 5 * 30, 20, 20, 2).setIcon(installed.getIcon()).setHoverText(I18n.func_135052_a((String)"terminal.battery.hover", (Object[])new Object[]{I18n.func_135052_a((String)installed.getUnlocalizedName(), (Object[])new Object[0]), charge})).setColors(0, TerminalTheme.COLOR_7.getColor(), 0));
                index.getAndIncrement();
            });
        }
    }
}

