/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.worldprospector;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.gui.resources.ShaderTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.terminal.app.ARApplication;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.client.shader.Shaders;
import gregtech.client.utils.DepthTextureUtil;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.common.inventory.handlers.SingleItemStackHandler;
import gregtech.common.items.MetaItems;
import gregtech.common.terminal.app.worldprospector.matcher.BlockStateMatcher;
import gregtech.common.terminal.app.worldprospector.matcher.IMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WorldProspectorARApp
extends ARApplication {
    private SingleItemStackHandler[] handlers;
    private int[] colors;
    @SideOnly(value=Side.CLIENT)
    private static Set<IMatcher> matchers;
    @SideOnly(value=Side.CLIENT)
    private static Map<IMatcher, Map<AxisAlignedBB, Set<BlockPos>>> founds;
    @SideOnly(value=Side.CLIENT)
    private static BlockPos lastPos;
    @SideOnly(value=Side.CLIENT)
    private static int radius;
    @SideOnly(value=Side.CLIENT)
    private static int maxRadius;

    public WorldProspectorARApp() {
        super("world_prospector");
    }

    @Override
    public AbstractApplication initApp() {
        this.addWidget(new ImageWidget(10, 10, 313, 212, new ColorRectTexture(TerminalTheme.COLOR_B_2.getColor())));
        this.addWidget(new LabelWidget(90, 116, "terminal.world_prospector.radius", -1, new Object[]{this.getMaxRadius()}).setShadow(true).setYCentered(true).setXCentered(true));
        int slotSize = (int)Math.pow(2.0, this.getAppTier());
        int x = 250 - slotSize * 12;
        int y = 98;
        this.handlers = new SingleItemStackHandler[slotSize];
        this.colors = new int[slotSize];
        for (int i = 0; i < slotSize; ++i) {
            final int index = i;
            Tuple<ItemStack, Integer> stack = this.getSlotStack(i);
            if (stack == null) {
                this.handlers[i] = new SingleItemStackHandler(ItemStack.field_190927_a);
                this.colors[i] = 0;
            } else {
                this.handlers[i] = new SingleItemStackHandler((ItemStack)stack.func_76341_a());
                this.colors[i] = (Integer)stack.func_76340_b();
            }
            final RectButtonWidget buttonWidget = new RectButtonWidget(x + i * 24, y + 18, 18, 18, 1);
            this.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)this.handlers[i], 0, x + i * 24, y){

                @Override
                public boolean mouseClicked(int mouseX, int mouseY, int button) {
                    if (WorldProspectorARApp.this.handlers[index].getStackInSlot(0).func_190926_b() && this.isMouseOverElement(mouseX, mouseY)) {
                        this.writeClientAction(-1, buffer -> {});
                        WorldProspectorARApp.this.selectReference(index, buttonWidget);
                        return true;
                    }
                    return super.mouseClicked(mouseX, mouseY, button);
                }

                @Override
                public void handleClientAction(int id, PacketBuffer buffer) {
                    if (id == -1) {
                        WorldProspectorARApp.this.selectReference(index, buttonWidget);
                    } else {
                        super.handleClientAction(id, buffer);
                    }
                }
            }.setBackgroundTexture(new ColorRectTexture(0x4FFFFFFF)));
            this.addWidget(buttonWidget.setHoverText("terminal.world_prospector.color").setColors(0x4FFFFFFF, -1, this.colors[i]).setClickListener(cd -> TerminalDialogWidget.showColorDialog(this.getOs(), "terminal.world_prospector.color", res -> {
                if (res != null) {
                    buttonWidget.setFill((int)(res | 0xFF000000));
                    this.colors[index] = res | 0xFF000000;
                }
            }, this.colors[index]).open()));
        }
        this.addWidget(new CircleButtonWidget(166, 200).setClickListener(cd -> this.openAR()).setHoverText("terminal.ar.open").setColors(0, -1, TerminalTheme.COLOR_B_3.getColor()).setIcon(new ItemStackTexture(MetaItems.CAMERA.getStackForm(), new ItemStack[0])));
        return this;
    }

    @Override
    public NBTTagCompound closeApp() {
        NBTTagCompound slots = new NBTTagCompound();
        this.nbt.func_82580_o("slots");
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i].getStackInSlot(0).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74782_a("item", (NBTBase)this.handlers[i].getStackInSlot(0).serializeNBT());
            itemTag.func_74768_a("color", this.colors[i]);
            slots.func_74782_a("s" + i, (NBTBase)itemTag);
        }
        this.nbt.func_74782_a("slots", (NBTBase)slots);
        return this.nbt;
    }

    @Override
    public int getMaxTier() {
        return 2;
    }

    @Override
    protected void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
        float time = ((float)this.gui.entityPlayer.field_70173_aa + partialTicks) / 20.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        if (Shaders.allowedShader()) {
            ShaderTexture.createShader("lightring.frag").draw(this.getPosition().x + 15, (float)this.getPosition().y + 41.0f, 150, 150, uniformCache -> uniformCache.glUniform1F("u_time", time));
        }
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    private void selectReference(int index, RectButtonWidget buttonWidget) {
        TerminalDialogWidget.showItemSelector(this.getOs(), "terminal.world_prospector.reference", false, stack -> stack.func_77973_b() instanceof ItemBlock, stack -> {
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                this.handlers[index].setStackInSlot(0, copy);
                Block block = ((ItemBlock)copy.func_77973_b()).func_179223_d();
                this.colors[index] = block instanceof BlockFalling ? ((BlockFalling)block).func_189876_x(block.func_176203_a(copy.func_77960_j())) : block.func_176203_a((int)copy.func_77960_j()).func_185904_a().func_151565_r().field_76291_p;
                if (this.colors[index] == 0) {
                    this.colors[index] = block.hashCode();
                }
                this.colors[index] = this.colors[index] | 0xFF000000;
                buttonWidget.setFill(this.colors[index]);
            }
        }).open();
    }

    private int getMaxRadius() {
        return (int)(15.0 * Math.pow(2.0, this.getAppTier()));
    }

    private Tuple<ItemStack, Integer> getSlotStack(int i) {
        NBTTagCompound slots;
        if (this.nbt != null && (slots = this.nbt.func_74775_l("slots")).func_74764_b("s" + i)) {
            NBTTagCompound itemTag = slots.func_74775_l("s" + i);
            return new Tuple((Object)new ItemStack(itemTag.func_74775_l("item")), (Object)itemTag.func_74762_e("color"));
        }
        return null;
    }

    private List<Tuple<ItemStack, Integer>> getAllSlotStack() {
        ArrayList<Tuple<ItemStack, Integer>> stacks = new ArrayList<Tuple<ItemStack, Integer>>();
        if (this.nbt != null) {
            NBTTagCompound slots = this.nbt.func_74775_l("slots");
            for (String key : slots.func_150296_c()) {
                NBTTagCompound itemTag = slots.func_74775_l(key);
                stacks.add((Tuple<ItemStack, Integer>)new Tuple((Object)new ItemStack(itemTag.func_74775_l("item")), (Object)itemTag.func_74762_e("color")));
            }
        }
        return stacks;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onAROpened() {
        founds = new HashMap<IMatcher, Map<AxisAlignedBB, Set<BlockPos>>>();
        radius = 0;
        maxRadius = this.getMaxRadius();
        lastPos = null;
        matchers = new HashSet<IMatcher>();
        for (Tuple<ItemStack, Integer> stack : this.getAllSlotStack()) {
            Block block;
            if (!(((ItemStack)stack.func_76341_a()).func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)((ItemStack)stack.func_76341_a()).func_77973_b()).func_179223_d()) == Blocks.field_150350_a) continue;
            matchers.add(new BlockStateMatcher(block.func_176203_a(((ItemStack)stack.func_76341_a()).func_77960_j()), (Integer)stack.func_76340_b()));
        }
        matchers.forEach(matcher -> {
            Map cfr_ignored_0 = founds.put((IMatcher)matcher, new HashMap());
        });
    }

    @SideOnly(value=Side.CLIENT)
    private List<BlockPos> bresenhamCircle(int xc, int zc, int r) {
        ArrayList<BlockPos> blockPos = new ArrayList<BlockPos>();
        int x = 0;
        int z = r;
        int d = 3 - 2 * r;
        this.circlePlot(blockPos, xc, zc, x, z);
        while (x < z) {
            if (d < 0) {
                d = d + 4 * x + 6;
            } else {
                d = d + 4 * (x - z) + 10;
                --z;
            }
            this.circlePlot(blockPos, xc, zc, ++x, z);
        }
        return blockPos;
    }

    @SideOnly(value=Side.CLIENT)
    private void circlePlot(List<BlockPos> blockPos, int xc, int zc, int x, int z) {
        blockPos.add(new BlockPos(xc + x, 0, zc + z));
        blockPos.add(new BlockPos(xc - x, 0, zc + z));
        blockPos.add(new BlockPos(xc + x, 0, zc - z));
        blockPos.add(new BlockPos(xc - x, 0, zc - z));
        blockPos.add(new BlockPos(xc + z, 0, zc + x));
        blockPos.add(new BlockPos(xc - z, 0, zc + x));
        blockPos.add(new BlockPos(xc + z, 0, zc - x));
        blockPos.add(new BlockPos(xc - z, 0, zc - x));
    }

    @SideOnly(value=Side.CLIENT)
    private void addCluster(BlockPos pos, Map<AxisAlignedBB, Set<BlockPos>> found) {
        BlockPos min = pos.func_177982_a(-1, -1, -1);
        BlockPos max = pos.func_177982_a(1, 1, 1);
        AxisAlignedBB root = null;
        for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    Set<Object> blocks;
                    AxisAlignedBB union;
                    Vec3d clusterPos = new Vec3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    AxisAlignedBB find = null;
                    for (AxisAlignedBB bb : found.keySet()) {
                        if (bb == root || !bb.func_72318_a(clusterPos)) continue;
                        find = bb;
                        break;
                    }
                    if (find == null) continue;
                    if (root == null) {
                        union = new AxisAlignedBB(pos).func_111270_a(find);
                        blocks = found.get(find);
                        found.remove(find);
                    } else {
                        union = root.func_111270_a(find);
                        blocks = new HashSet();
                        blocks.addAll((Collection)found.get(find));
                        blocks.addAll((Collection)found.get(root));
                        found.remove(find);
                        found.remove(root);
                    }
                    found.put(union, blocks);
                    root = union;
                    found.get(root).add(pos);
                }
            }
        }
        if (root == null) {
            HashSet<BlockPos> blocks = new HashSet<BlockPos>();
            blocks.add(pos);
            found.put(new AxisAlignedBB(pos), blocks);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickAR(EntityPlayer player) {
        World world = player.field_70170_p;
        if (radius == 0 || lastPos == null) {
            lastPos = player.func_180425_c();
        }
        int maxY = Math.min(256, maxRadius + player.func_180425_c().func_177956_o());
        int minY = Math.max(0, -maxRadius + player.func_180425_c().func_177956_o());
        for (BlockPos pos2 : this.bresenhamCircle(lastPos.func_177958_n(), lastPos.func_177952_p(), radius)) {
            for (int y = minY; y <= maxY; ++y) {
                for (IMatcher matcher : matchers) {
                    BlockPos blockPos;
                    if (!matcher.match(world.func_180495_p(blockPos = new BlockPos(pos2.func_177958_n(), y, pos2.func_177952_p())))) continue;
                    this.addCluster(blockPos, founds.get(matcher));
                }
            }
        }
        if (radius == maxRadius) {
            radius = 0;
            for (IMatcher matcher : matchers) {
                Iterator<Map.Entry<AxisAlignedBB, Set<BlockPos>>> it = founds.get(matcher).entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<AxisAlignedBB, Set<BlockPos>> entry = it.next();
                    entry.getValue().removeIf(pos -> !matcher.match(world.func_180495_p(pos)));
                    if (!entry.getValue().isEmpty()) continue;
                    it.remove();
                }
            }
        } else {
            ++radius;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawARScreen(RenderWorldLastEvent event) {
        this.renderScan(event.getPartialTicks());
        this.renderAxisAlignedBB(event.getPartialTicks());
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAxisAlignedBB(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity == null) {
            return;
        }
        double posX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double posY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double posZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-posX), (double)(-posY), (double)(-posZ));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (IMatcher matcher : matchers) {
            int color = matcher.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = 1.0f;
            for (AxisAlignedBB bound : founds.get(matcher).keySet()) {
                RenderBufferHelper.renderCubeFace(buffer, bound.field_72340_a, bound.field_72338_b, bound.field_72339_c, bound.field_72336_d, bound.field_72337_e, bound.field_72334_f, r, g, b, 1.0f);
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderScan(float getPartialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        Entity viewer = mc.func_175606_aa();
        if (world != null && viewer != null && !Shaders.isOptiFineShaderPackLoaded()) {
            Framebuffer fbo = mc.func_147110_a();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)1);
            DepthTextureUtil.bindDepthTexture();
            float time = ((float)viewer.field_70173_aa + getPartialTicks) / 20.0f;
            Shaders.renderFullImageInFBO(fbo, Shaders.SCANNING, uniformCache -> {
                uniformCache.glUniform1F("u_time", time);
                uniformCache.glUniform1F("radius", (float)radius + getPartialTicks);
                uniformCache.glUniform1F("u_zFar", (float)(mc.field_71474_y.field_151451_c * 16) * MathHelper.field_180189_a);
                uniformCache.glUniform1F("u_FOV", mc.field_71474_y.field_74334_X);
            });
            DepthTextureUtil.unBindDepthTexture();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        }
    }
}

