/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class PacketProspecting {
    public int chunkX;
    public int chunkZ;
    public int posX;
    public int posZ;
    public int mode;
    public HashMap<Byte, String>[][] map;
    public Set<String> ores;

    public PacketProspecting(int chunkX, int chunkZ, int posX, int posZ, int mode) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.posX = posX;
        this.posZ = posZ;
        this.mode = mode;
        this.map = mode == 1 ? new HashMap[1][1] : new HashMap[16][16];
        this.ores = new HashSet<String>();
    }

    public static PacketProspecting readPacketData(PacketBuffer buffer) {
        PacketProspecting packet = new PacketProspecting(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
        int aSize = 0;
        if (packet.mode == 0) {
            aSize = 16;
        } else if (packet.mode == 1) {
            aSize = 1;
        }
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                int kSize = buffer.readByte();
                if (kSize == 0) continue;
                packet.map[i][j] = new HashMap();
                for (int k = 0; k < kSize; ++k) {
                    byte y = buffer.readByte();
                    String name = buffer.func_150789_c(1000);
                    packet.map[i][j].put(y, name);
                    if (packet.mode != 1 || y == 1) {
                        packet.ores.add(name);
                    }
                    ++checkOut;
                }
            }
        }
        int checkOut2 = buffer.readInt();
        if (checkOut != checkOut2) {
            return null;
        }
        return packet;
    }

    public static PacketProspecting readPacketData(NBTTagCompound nbt) {
        if (nbt.func_74764_b("buffer")) {
            return PacketProspecting.readPacketData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])nbt.func_74770_j("buffer"))));
        }
        return null;
    }

    public NBTTagCompound writePacketData() {
        NBTTagCompound nbt = new NBTTagCompound();
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        this.writePacketData(buffer);
        byte[] bytes = buffer.array();
        nbt.func_74773_a("buffer", bytes);
        return nbt;
    }

    public void writePacketData(PacketBuffer buffer) {
        buffer.writeInt(this.chunkX);
        buffer.writeInt(this.chunkZ);
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posZ);
        buffer.writeInt(this.mode);
        int aSize = 0;
        if (this.mode == 0) {
            aSize = 16;
        } else if (this.mode == 1) {
            aSize = 1;
        }
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                if (this.map[i][j] == null) {
                    buffer.writeByte(0);
                    continue;
                }
                buffer.writeByte(this.map[i][j].keySet().size());
                for (byte key : this.map[i][j].keySet()) {
                    buffer.writeByte((int)key);
                    buffer.func_180714_a(this.map[i][j].get(key));
                    ++checkOut;
                }
            }
        }
        buffer.writeInt(checkOut);
    }

    public void addBlock(int x, int y, int z, String orePrefix) {
        if (this.mode == 0) {
            if (this.map[x][z] == null) {
                this.map[x][z] = new HashMap();
            }
            this.map[x][z].put((byte)y, orePrefix);
            this.ores.add(orePrefix);
        } else if (this.mode == 1) {
            if (this.map[x][z] == null) {
                this.map[x][z] = new HashMap();
            }
            this.map[x][z].put((byte)y, orePrefix);
            if (y == 1) {
                this.ores.add(orePrefix);
            }
        }
    }

    public PacketProspecting() {
    }
}

