/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils;

import gregtech.integration.jei.utils.JeiButton;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiUtils;

public abstract class AdvancedRecipeWrapper
implements IRecipeWrapper {
    protected final List<JeiButton> buttons = new ArrayList<JeiButton>();

    public AdvancedRecipeWrapper() {
        this.initExtras();
    }

    public abstract void initExtras();

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        for (JeiButton button : this.buttons) {
            button.render(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            if (!button.isHovering(mouseX, mouseY)) continue;
            ArrayList<String> lines = new ArrayList<String>();
            button.buildTooltip(lines);
            if (lines.isEmpty()) continue;
            Minecraft mc = Minecraft.func_71410_x();
            int width = (int)((float)mc.field_71443_c / 2.0f + (float)recipeWidth / 2.0f);
            int maxWidth = Math.min(200, width - mouseX - 5);
            GuiUtils.drawHoveringText((ItemStack)ItemStack.field_190927_a, lines, (int)mouseX, (int)mouseY, (int)width, (int)mc.field_71440_d, (int)maxWidth, (FontRenderer)mc.field_71466_p);
            GlStateManager.func_179140_f();
        }
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        for (JeiButton button : this.buttons) {
            if (!button.isHovering(mouseX, mouseY) || !button.getClickAction().click(minecraft, mouseX, mouseY, mouseButton)) continue;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return false;
    }
}

