/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.metatileentities.converter.ConverterTrait;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;

public class ConverterInfoProvider
extends CapabilityInfoProvider<ConverterTrait> {
    public String getID() {
        return "gregtech:converter_info_provider";
    }

    @Override
    @Nonnull
    protected Capability<ConverterTrait> getCapability() {
        return GregtechCapabilities.CAPABILITY_CONVERTER;
    }

    @Override
    protected void addProbeInfo(@Nonnull ConverterTrait capability, @Nonnull IProbeInfo probeInfo, EntityPlayer player, @Nonnull TileEntity tileEntity, @Nonnull IProbeHitData data) {
        probeInfo.text(TextStyleClass.INFO + (capability.isFeToEu() ? "{*gregtech.top.convert_fe*}" : "{*gregtech.top.convert_eu*}"));
        EnumFacing facing = ((IGregTechTileEntity)tileEntity).getMetaTileEntity().getFrontFacing();
        String voltageN = GTValues.VNF[GTUtility.getTierByVoltage(capability.getVoltage())];
        long amperage = capability.getBaseAmps();
        if (capability.isFeToEu()) {
            if (data.getSideHit() == facing) {
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.transform_output*} " + voltageN + TextFormatting.GREEN + " (" + amperage + "A)");
            } else {
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.transform_input*} " + TextFormatting.RED + FeCompat.toFe(capability.getVoltage() * amperage, FeCompat.ratio(true)) + " FE");
            }
        } else if (data.getSideHit() == facing) {
            probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.transform_output*} " + TextFormatting.RED + FeCompat.toFe(capability.getVoltage() * amperage, FeCompat.ratio(false)) + " FE");
        } else {
            probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.transform_input*} " + voltageN + TextFormatting.GREEN + " (" + amperage + "A)");
        }
    }
}

