/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.recipes.RecipeMap;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;

public class MultiRecipeMapInfoProvider
extends CapabilityInfoProvider<IMultipleRecipeMaps> {
    public String getID() {
        return "gregtech:multi_recipemap_provider";
    }

    @Override
    @Nonnull
    protected Capability<IMultipleRecipeMaps> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_MULTIPLE_RECIPEMAPS;
    }

    @Override
    protected void addProbeInfo(@Nonnull IMultipleRecipeMaps iMultipleRecipeMaps, @Nonnull IProbeInfo iProbeInfo, @Nonnull EntityPlayer player, @Nonnull TileEntity tileEntity, @Nonnull IProbeHitData data) {
        if (iMultipleRecipeMaps.getAvailableRecipeMaps().length == 1) {
            return;
        }
        iProbeInfo.text(TextStyleClass.INFO + "{*" + "gregtech.multiblock.multiple_recipemaps.header" + "*}");
        for (RecipeMap<?> recipeMap : iMultipleRecipeMaps.getAvailableRecipeMaps()) {
            if (recipeMap.equals(iMultipleRecipeMaps.getCurrentRecipeMap())) {
                iProbeInfo.text("   " + TextStyleClass.INFOIMP + "{*recipemap." + recipeMap.getUnlocalizedName() + ".name*} {*<*}");
                continue;
            }
            iProbeInfo.text("   " + TextStyleClass.LABEL + recipeMap.getLocalizedName());
        }
    }
}

