/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.PrimitiveRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;

public class RecipeLogicInfoProvider
extends CapabilityInfoProvider<AbstractRecipeLogic> {
    public String getID() {
        return "gregtech:recipe_logic_provider";
    }

    @Override
    @Nonnull
    protected Capability<AbstractRecipeLogic> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC;
    }

    @Override
    protected void addProbeInfo(@Nonnull AbstractRecipeLogic capability, @Nonnull IProbeInfo probeInfo, @Nonnull EntityPlayer player, @Nonnull TileEntity tileEntity, @Nonnull IProbeHitData data) {
        if (capability.isWorking()) {
            IGregTechTileEntity gtTileEntity;
            MetaTileEntity mte;
            if (capability instanceof PrimitiveRecipeLogic) {
                return;
            }
            int EUt = capability.getRecipeEUt();
            int absEUt = Math.abs(EUt);
            String text = null;
            if (tileEntity instanceof IGregTechTileEntity && (mte = (gtTileEntity = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof SteamMetaTileEntity) {
                text = TextFormatting.RED.toString() + absEUt + TextStyleClass.INFO + " L/t {*material.steam*}";
            }
            if (text == null) {
                text = TextFormatting.RED.toString() + absEUt + TextStyleClass.INFO + " EU/t" + TextFormatting.GREEN + " (" + GTValues.VNF[GTUtility.getTierByVoltage(absEUt)] + TextFormatting.GREEN + ")";
            }
            if (EUt > 0) {
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_consumption*} " + text);
            } else if (EUt < 0) {
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_production*} " + text);
            }
        }
    }
}

