/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.GTValues;
import gregtech.api.items.OreDictNames;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class VanillaStandardRecipes {
    public static void init() {
        VanillaStandardRecipes.compressingRecipes();
        VanillaStandardRecipes.glassRecipes();
        VanillaStandardRecipes.smashingRecipes();
        VanillaStandardRecipes.engraverRecipes();
        VanillaStandardRecipes.woodRecipes();
        VanillaStandardRecipes.cuttingRecipes();
        VanillaStandardRecipes.dyingCleaningRecipes();
        VanillaStandardRecipes.redstoneRecipes();
        VanillaStandardRecipes.metalRecipes();
        VanillaStandardRecipes.miscRecipes();
        VanillaStandardRecipes.mixingRecipes();
        VanillaStandardRecipes.dyeRecipes();
    }

    private static void compressingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).input(OrePrefix.plate, Materials.Stone, 9)).outputs(new ItemStack(Blocks.field_150348_b))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150354_m, 4))).outputs(new ItemStack(Blocks.field_150322_A))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack((Block)Blocks.field_150354_m, 4, 1))).outputs(new ItemStack(Blocks.field_180395_cM))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151118_aC, 4))).outputs(new ItemStack(Blocks.field_150336_V))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151130_bT, 4))).outputs(new ItemStack(Blocks.field_150385_bj))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Blocks.field_150433_aE))).outputs(new ItemStack(Blocks.field_150432_aD))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151119_aD, 4))).outputs(new ItemStack(Blocks.field_150435_aG))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().duration(300)).EUt(2)).inputs(new ItemStack(Items.field_151114_aO, 4))).outputs(new ItemStack(Blocks.field_150426_aN))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150432_aD, 2, Short.MAX_VALUE))).outputs(new ItemStack(Blocks.field_150403_cj))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Ice, 1)).outputs(new ItemStack(Blocks.field_150432_aD))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151015_O, 9))).notConsumable(new IntCircuitIngredient(9))).outputs(new ItemStack(Blocks.field_150407_cf))).duration(200)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151127_ba, 9))).notConsumable(new IntCircuitIngredient(9))).outputs(new ItemStack(Blocks.field_150440_ba))).duration(200)).EUt(2)).buildAndRegister();
    }

    private static void glassRecipes() {
        ModHandler.addShapedRecipe("glass_dust_hammer", OreDictUnifier.get(OrePrefix.dust, Materials.Glass), "hG", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE));
        ModHandler.addShapelessRecipe("glass_dust_handcrafting", OreDictUnifier.get(OrePrefix.dust, Materials.Glass), "dustSand", "dustFlint");
        ModHandler.addShapedRecipe("quartz_sand", OreDictUnifier.get(OrePrefix.dust, Materials.QuartzSand), "S", "m", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150354_m));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150354_m))).output(OrePrefix.dust, Materials.QuartzSand)).duration(30)).buildAndRegister();
        ModHandler.addShapelessRecipe("glass_dust_flint", OreDictUnifier.get(OrePrefix.dust, Materials.Glass), new UnificationEntry(OrePrefix.dust, Materials.QuartzSand), new UnificationEntry(OrePrefix.dustTiny, Materials.Flint));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration(160)).EUt(GTValues.VA[0])).input(OrePrefix.dustSmall, Materials.Flint)).input(OrePrefix.dust, Materials.Quartzite, 4)).output(OrePrefix.dust, Materials.Glass, 5)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration(200)).EUt(GTValues.VA[0])).input(OrePrefix.dustSmall, Materials.Flint)).input(OrePrefix.dust, Materials.QuartzSand, 4)).output(OrePrefix.dust, Materials.Glass, 4)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ARC_FURNACE_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[1])).inputs(new ItemStack((Block)Blocks.field_150354_m, 1))).outputs(new ItemStack(Blocks.field_150359_w, 2))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().duration(80)).EUt(GTValues.VA[1])).input(OrePrefix.dust, Materials.Glass)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).outputs(new ItemStack(Blocks.field_150359_w, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration(64)).EUt(4)).input(OrePrefix.dust, Materials.Glass)).notConsumable(MetaItems.SHAPE_MOLD_BOTTLE)).outputs(new ItemStack(Items.field_151069_bo))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().duration(32)).EUt(16)).input(OrePrefix.dust, Materials.Glass)).notConsumable(MetaItems.SHAPE_EXTRUDER_BOTTLE)).outputs(new ItemStack(Items.field_151069_bo))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(12)).EUt(4)).fluidInputs(Materials.Glass.getFluid(144))).notConsumable(MetaItems.SHAPE_MOLD_BOTTLE)).outputs(new ItemStack(Items.field_151069_bo))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(12)).EUt(4)).fluidInputs(Materials.Glass.getFluid(144))).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).outputs(new ItemStack(Blocks.field_150359_w))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration(120)).EUt(16)).input(OrePrefix.dust, Materials.Glass)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).outputs(new ItemStack(Blocks.field_150359_w, 1))).buildAndRegister();
        for (int i = 0; i < 16; ++i) {
            if (ConfigHolder.recipes.hardGlassRecipes) {
                ModHandler.removeRecipes(new ItemStack((Block)Blocks.field_150397_co, 16, i));
            }
            ModHandler.addShapedRecipe("stained_glass_pane_" + i, new ItemStack((Block)Blocks.field_150397_co, 2, i), "sG", Character.valueOf('G'), new ItemStack((Block)Blocks.field_150399_cn, 1, i));
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(50)).EUt(GTValues.VA[0])).inputs(new ItemStack((Block)Blocks.field_150399_cn, 3, i))).outputs(new ItemStack((Block)Blocks.field_150397_co, 8, i))).buildAndRegister();
        }
        if (ConfigHolder.recipes.hardGlassRecipes) {
            ModHandler.removeRecipes(new ItemStack(Blocks.field_150410_aZ, 16));
        }
        ModHandler.addShapedRecipe("glass_pane", new ItemStack(Blocks.field_150410_aZ, 2), "sG", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(50)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_150359_w, 3))).outputs(new ItemStack(Blocks.field_150410_aZ, 8))).buildAndRegister();
    }

    private static void smashingRecipes() {
        ModHandler.addShapedRecipe("cobblestone_hammer", new ItemStack(Blocks.field_150347_e), "h", "C", Character.valueOf('C'), new UnificationEntry(OrePrefix.stone));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(OrePrefix.stone.name(), 1)).outputs(new ItemStack(Blocks.field_150347_e, 1))).EUt(16)).duration(10)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(OreDictNames.cobblestone.name(), 1)).outputs(new ItemStack(Blocks.field_150351_n, 1))).EUt(16)).duration(10)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150351_n, 1))).outputs(new ItemStack((Block)Blocks.field_150354_m))).EUt(16)).duration(10)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150351_n, 1))).output(OrePrefix.dust, Materials.Stone)).chancedOutput(new ItemStack(Items.field_151145_ak), 1000, 1000)).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150322_A, 1, Short.MAX_VALUE))).outputs(new ItemStack((Block)Blocks.field_150354_m, 1))).EUt(2)).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_180395_cM, 1, Short.MAX_VALUE))).outputs(new ItemStack((Block)Blocks.field_150354_m, 1, 1))).EUt(2)).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150417_aV))).outputs(new ItemStack(Blocks.field_150417_aV, 1, 2))).EUt(2)).duration(400)).buildAndRegister();
        if (!ConfigHolder.recipes.disableManualCompression) {
            ModHandler.addShapelessRecipe("nether_quartz_block_to_nether_quartz", new ItemStack(Items.field_151128_bU, 4), Blocks.field_150371_ca);
        }
        ModHandler.addShapelessRecipe("clay_block_to_dust", OreDictUnifier.get(OrePrefix.dust, Materials.Clay), Character.valueOf('m'), Blocks.field_150435_aG);
        ModHandler.addShapelessRecipe("clay_ball_to_dust", OreDictUnifier.get(OrePrefix.dustSmall, Materials.Clay), Character.valueOf('m'), Items.field_151119_aD);
        ModHandler.addShapelessRecipe("brick_block_to_dust", OreDictUnifier.get(OrePrefix.dust, Materials.Brick), Character.valueOf('m'), Blocks.field_150336_V);
        ModHandler.addShapelessRecipe("brick_to_dust", OreDictUnifier.get(OrePrefix.dustSmall, Materials.Brick), Character.valueOf('m'), Items.field_151118_aC);
        ModHandler.addShapelessRecipe("wheat_to_dust", OreDictUnifier.get(OrePrefix.dust, Materials.Wheat), Character.valueOf('m'), Items.field_151015_O);
        ModHandler.addShapelessRecipe("gravel_to_flint", new ItemStack(Items.field_151145_ak), Character.valueOf('m'), Blocks.field_150351_n);
        ModHandler.addShapelessRecipe("bone_to_bone_meal", new ItemStack(Items.field_151100_aR, 4, 15), Character.valueOf('m'), Items.field_151103_aS);
        ModHandler.addShapelessRecipe("blaze_rod_to_powder", new ItemStack(Items.field_151065_br, 3), Character.valueOf('m'), Items.field_151072_bj);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()))).outputs(OreDictUnifier.get(OrePrefix.dust, Materials.Cocoa, 1))).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151120_aE, 1))).outputs(new ItemStack(Items.field_151102_aT, 1))).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150440_ba, 1, 0))).outputs(new ItemStack(Items.field_151127_ba, 8, 0))).chancedOutput(new ItemStack(Items.field_151081_bc, 1), 8000, 500)).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150423_aK, 1, 0))).outputs(new ItemStack(Items.field_151080_bb, 4, 0))).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151127_ba, 1, 0))).outputs(new ItemStack(Items.field_151081_bc, 1, 0))).duration(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(GTRecipeOreInput.getOrCreate("wool", 1))).outputs(new ItemStack(Items.field_151007_F, 1))).chancedOutput(new ItemStack(Items.field_151007_F, 1), 9000, 0)).chancedOutput(new ItemStack(Items.field_151007_F, 1), 5000, 0)).chancedOutput(new ItemStack(Items.field_151007_F, 1), 2000, 0)).duration(200)).buildAndRegister();
    }

    private static void engraverRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150322_A, 1, 2))).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(new ItemStack(Blocks.field_150322_A, 1, 1))).duration(50)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_180395_cM, 1, 2))).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(new ItemStack(Blocks.field_180395_cM, 1, 1))).duration(50)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150348_b))).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(new ItemStack(Blocks.field_150417_aV, 1, 3))).duration(50)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150371_ca))).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(new ItemStack(Blocks.field_150371_ca, 1, 1))).duration(50)).EUt(16)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_185767_cT))).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).outputs(new ItemStack(Blocks.field_185768_cU, 1))).duration(50)).EUt(16)).buildAndRegister();
    }

    private static void woodRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(OrePrefix.log, Materials.Wood)).output(OrePrefix.dust, Materials.Wood, 6)).chancedOutput(OrePrefix.dust, Materials.Wood, 8000, 680)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood)).output(OrePrefix.stick, Materials.Wood, 2)).duration(10)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.log, Materials.Wood)).output(OrePrefix.stickLong, Materials.Wood, 4)).output(OrePrefix.dust, Materials.Wood, 2)).duration(160)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE))).outputs(new ItemStack(Items.field_151055_y))).output(OrePrefix.dustTiny, Materials.Wood)).duration(16)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150376_bx, 1, Short.MAX_VALUE))).outputs(new ItemStack(Items.field_151054_z))).output(OrePrefix.dustSmall, Materials.Wood)).duration(50)).EUt(GTValues.VA[0])).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood, 6)).inputs(new ItemStack(Items.field_151122_aG, 3))).outputs(new ItemStack(Blocks.field_150342_X))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood, 3)).circuitMeta(3).outputs(new ItemStack(Blocks.field_150415_aT, 2))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plank, Materials.Wood, 8)).outputs(new ItemStack((Block)Blocks.field_150486_ae))).duration(100)).EUt(4)).circuitMeta(8).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE))).input(OrePrefix.stick, Materials.Wood, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 4))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Coal)).input(OrePrefix.stick, Materials.Wood, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 4))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Charcoal)).input(OrePrefix.stick, Materials.Wood, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 4))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.gem, Materials.Coke)).input(OrePrefix.stick, Materials.Wood, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 8))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Coke)).input(OrePrefix.stick, Materials.Wood, 1)).outputs(new ItemStack(Blocks.field_150478_aa, 8))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 1, 0))).outputs(new ItemStack(Blocks.field_180407_aO))).circuitMeta(1).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 1, 1))).outputs(new ItemStack(Blocks.field_180408_aP))).circuitMeta(1).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 1, 2))).outputs(new ItemStack(Blocks.field_180404_aQ))).circuitMeta(1).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 1, 3))).outputs(new ItemStack(Blocks.field_180403_aR))).circuitMeta(1).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 1, 4))).outputs(new ItemStack(Blocks.field_180405_aT))).circuitMeta(1).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 1, 5))).outputs(new ItemStack(Blocks.field_180406_aS))).circuitMeta(1).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 2, 0))).input(OrePrefix.stick, Materials.Wood, 2)).outputs(new ItemStack(Blocks.field_180390_bo))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 2, 1))).input(OrePrefix.stick, Materials.Wood, 2)).outputs(new ItemStack(Blocks.field_180391_bp))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 2, 2))).input(OrePrefix.stick, Materials.Wood, 2)).outputs(new ItemStack(Blocks.field_180392_bq))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 2, 3))).input(OrePrefix.stick, Materials.Wood, 2)).outputs(new ItemStack(Blocks.field_180386_br))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 2, 4))).input(OrePrefix.stick, Materials.Wood, 2)).outputs(new ItemStack(Blocks.field_180387_bt))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150344_f, 2, 5))).input(OrePrefix.stick, Materials.Wood, 2)).outputs(new ItemStack(Blocks.field_180385_bs))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ModHandler.addShapedRecipe("sticky_resin_torch", new ItemStack(Blocks.field_150478_aa, 3), "X", "Y", Character.valueOf('X'), MetaItems.STICKY_RESIN, Character.valueOf('Y'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("torch_sulfur", new ItemStack(Blocks.field_150478_aa, 2), "C", "S", Character.valueOf('C'), new UnificationEntry(OrePrefix.dust, Materials.Sulfur), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("torch_phosphorus", new ItemStack(Blocks.field_150478_aa, 6), "C", "S", Character.valueOf('C'), new UnificationEntry(OrePrefix.dust, Materials.Phosphorus), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("torch_coal_dust", new ItemStack(Blocks.field_150478_aa, 4), "C", "S", Character.valueOf('C'), new UnificationEntry(OrePrefix.dust, Materials.Coal), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("torch_charcoal_dust", new ItemStack(Blocks.field_150478_aa, 4), "C", "S", Character.valueOf('C'), new UnificationEntry(OrePrefix.dust, Materials.Charcoal), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("torch_coke", new ItemStack(Blocks.field_150478_aa, 8), "C", "S", Character.valueOf('C'), new UnificationEntry(OrePrefix.gem, Materials.Coke), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("torch_coke_dust", new ItemStack(Blocks.field_150478_aa, 8), "C", "S", Character.valueOf('C'), new UnificationEntry(OrePrefix.dust, Materials.Coke), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        ModHandler.addShapedRecipe("torch_creosote", new ItemStack(Blocks.field_150478_aa, 16), "WB", "S ", Character.valueOf('W'), OreDictUnifier.get("wool"), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('B'), FluidUtil.getFilledBucket((FluidStack)Materials.Creosote.getFluid(1000)));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).input(OrePrefix.dust, Materials.Redstone)).input(OrePrefix.stick, Materials.Wood)).outputs(new ItemStack(Blocks.field_150429_aA, 1))).duration(100)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).input(OrePrefix.stick, Materials.Wood)).input(OrePrefix.dust, Materials.Sulfur)).outputs(new ItemStack(Blocks.field_150478_aa, 2))).duration(100)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).input(OrePrefix.stick, Materials.Wood)).input(OrePrefix.dust, Materials.Phosphorus)).outputs(new ItemStack(Blocks.field_150478_aa, 6))).duration(100)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150344_f, 6, 0))).outputs(new ItemStack(Blocks.field_150476_ad, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150344_f, 6, 1))).outputs(new ItemStack(Blocks.field_150485_bF, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150344_f, 6, 2))).outputs(new ItemStack(Blocks.field_150487_bG, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150344_f, 6, 3))).outputs(new ItemStack(Blocks.field_150481_bH, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150344_f, 6, 4))).outputs(new ItemStack(Blocks.field_150400_ck, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150344_f, 6, 5))).outputs(new ItemStack(Blocks.field_150401_cl, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(40)).circuitMeta(7).inputs(new ItemStack(Items.field_151055_y, 7))).outputs(new ItemStack(Blocks.field_150468_ap, 2))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).duration(100)).inputs(new ItemStack(Items.field_151143_au))).inputs(OreDictUnifier.get("chestWood"))).outputs(new ItemStack(Items.field_151108_aI))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).duration(100)).inputs(new ItemStack(Items.field_151143_au))).inputs(new ItemStack(Blocks.field_150460_al))).outputs(new ItemStack(Items.field_151109_aJ))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).duration(100)).inputs(new ItemStack(Items.field_151143_au))).inputs(new ItemStack(Blocks.field_150335_W))).outputs(new ItemStack(Items.field_151142_bV))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).duration(100)).inputs(new ItemStack(Items.field_151143_au))).inputs(new ItemStack((Block)Blocks.field_150438_bZ))).outputs(new ItemStack(Items.field_151140_bW))).buildAndRegister();
    }

    private static void cuttingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150348_b))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150322_A))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 1))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150347_e))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 3))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150336_V))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 4))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150417_aV))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 5))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150385_bj))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 6))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150371_ca, 1, 1))).outputs(new ItemStack((Block)Blocks.field_150333_U, 2, 7))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_180395_cM, 1, 0))).outputs(new ItemStack((Block)Blocks.field_180389_cP, 2, 0))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_185767_cT, 1, 0))).outputs(new ItemStack((Block)Blocks.field_185771_cX, 2, 0))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150433_aE, 1))).outputs(new ItemStack(Blocks.field_150431_aC, 16))).duration(25)).EUt(GTValues.VA[0])).buildAndRegister();
    }

    private static void dyingCleaningRecipes() {
        for (int i = 0; i < 16; ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().duration(200)).EUt(GTValues.VA[0])).inputs(new ItemStack((Block)Blocks.field_150354_m, 4))).inputs(new ItemStack(Blocks.field_150351_n, 4))).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(144))).outputs(new ItemStack(Blocks.field_192444_dS, 8, i))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_192444_dS, 1, i))).fluidInputs(Materials.Water.getFluid(1000))).outputs(new ItemStack(Blocks.field_192443_dR, 1, i))).buildAndRegister();
            if (i != 0) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_192443_dR))).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(18))).outputs(new ItemStack(Blocks.field_192443_dR, 1, i))).buildAndRegister();
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_150405_ch))).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(18))).outputs(new ItemStack(Blocks.field_150406_ce, 1, i))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_150359_w))).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(18))).outputs(new ItemStack((Block)Blocks.field_150399_cn, 1, i))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_150410_aZ))).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(18))).outputs(new ItemStack((Block)Blocks.field_150397_co, 1, i))).buildAndRegister();
            if (i != 0) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_150325_L))).fluidInputs(Materials.CHEMICAL_DYES[i].getFluid(144))).outputs(new ItemStack(Blocks.field_150325_L, 1, i))).buildAndRegister();
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).inputs(new ItemStack(Blocks.field_150325_L, 2, i))).outputs(new ItemStack(Blocks.field_150404_cg, 3, i))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(20)).EUt(GTValues.VA[0])).circuitMeta(6).inputs(new ItemStack(Items.field_151055_y))).inputs(new ItemStack(Blocks.field_150325_L, 6, i))).outputs(new ItemStack(Items.field_179564_cE, 1, 15 - i))).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().input(Blocks.field_150325_L, 1, true)).fluidInputs(Materials.Chlorine.getFluid(50))).output(Blocks.field_150325_L)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().input(Blocks.field_150404_cg, 1, true)).fluidInputs(Materials.Chlorine.getFluid(25))).output(Blocks.field_150404_cg)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().input(Blocks.field_150406_ce, 1, true)).fluidInputs(Materials.Chlorine.getFluid(50))).output(Blocks.field_150405_ch)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().input((Block)Blocks.field_150399_cn, 1, true)).fluidInputs(Materials.Chlorine.getFluid(50))).output(Blocks.field_150359_w)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().input((Block)Blocks.field_150397_co, 1, true)).fluidInputs(Materials.Chlorine.getFluid(20))).output(Blocks.field_150410_aZ)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().input(Blocks.field_192443_dR, 1, true)).fluidInputs(Materials.Chlorine.getFluid(20))).output(Blocks.field_192443_dR)).duration(400)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150320_F))).fluidInputs(Materials.Chlorine.getFluid(10))).outputs(new ItemStack((Block)Blocks.field_150331_J))).duration(30)).EUt(GTValues.VA[1])).buildAndRegister();
    }

    private static void redstoneRecipes() {
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(MetaItems.STICKY_RESIN.getStackForm())).inputs(new ItemStack((Block)Blocks.field_150331_J))).outputs(new ItemStack((Block)Blocks.field_150320_F))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input("slimeball", 1)).inputs(new ItemStack((Block)Blocks.field_150331_J))).outputs(new ItemStack((Block)Blocks.field_150320_F))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150331_J))).fluidInputs(Materials.Glue.getFluid(100))).outputs(new ItemStack((Block)Blocks.field_150320_F))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Wood, 2)).input(OrePrefix.ring, Materials.Iron, 2)).outputs(new ItemStack((Block)Blocks.field_150479_bC, 1))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Wood, 2)).input(OrePrefix.ring, Materials.WroughtIron, 2)).outputs(new ItemStack((Block)Blocks.field_150479_bC, 1))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Redstone, 4)).input(OrePrefix.dust, Materials.Glowstone, 4)).outputs(new ItemStack(Blocks.field_150379_bu))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150429_aA, 2))).input(OrePrefix.dust, Materials.Redstone)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(new ItemStack(Items.field_151107_aW))).duration(100)).EUt(10)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150429_aA, 3))).input(OrePrefix.gem, Materials.NetherQuartz)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(new ItemStack(Items.field_151132_bS))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150429_aA, 3))).input(OrePrefix.gem, Materials.CertusQuartz)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(new ItemStack(Items.field_151132_bS))).duration(100)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150429_aA, 3))).input(OrePrefix.gem, Materials.Quartzite)).fluidInputs(Materials.Concrete.getFluid(144))).outputs(new ItemStack(Items.field_151132_bS))).duration(100)).EUt(1)).buildAndRegister();
        if (ConfigHolder.recipes.hardRedstoneRecipes) {
            return;
        }
        ModHandler.addShapedRecipe("piston_bronze", new ItemStack((Block)Blocks.field_150331_J, 1), new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('R'), new UnificationEntry(OrePrefix.dust, Materials.Redstone), Character.valueOf('B'), new UnificationEntry(OrePrefix.ingot, Materials.Bronze)});
        ModHandler.addShapedRecipe("piston_steel", new ItemStack((Block)Blocks.field_150331_J, 2), new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('R'), new UnificationEntry(OrePrefix.dust, Materials.Redstone), Character.valueOf('B'), new UnificationEntry(OrePrefix.ingot, Materials.Steel)});
        ModHandler.addShapedRecipe("piston_aluminium", new ItemStack((Block)Blocks.field_150331_J, 4), new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('R'), new UnificationEntry(OrePrefix.dust, Materials.Redstone), Character.valueOf('B'), new UnificationEntry(OrePrefix.ingot, Materials.Aluminium)});
        ModHandler.addShapedRecipe("piston_titanium", new ItemStack((Block)Blocks.field_150331_J, 8), new Object[]{"WWW", "CBC", "CRC", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('C'), OreDictNames.stoneCobble, Character.valueOf('R'), new UnificationEntry(OrePrefix.dust, Materials.Redstone), Character.valueOf('B'), new UnificationEntry(OrePrefix.ingot, Materials.Titanium)});
        ModHandler.addShapedRecipe("sticky_piston_resin", new ItemStack((Block)Blocks.field_150320_F), "h", "R", "P", Character.valueOf('R'), MetaItems.STICKY_RESIN.getStackForm(), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(16)).input(OrePrefix.plate, Materials.Iron)).inputs(new ItemStack(Blocks.field_150344_f, 3, Short.MAX_VALUE))).inputs(new ItemStack(Blocks.field_150347_e, 4))).input(OrePrefix.dust, Materials.Redstone)).outputs(new ItemStack((Block)Blocks.field_150331_J))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(16)).input(OrePrefix.plate, Materials.Bronze)).inputs(new ItemStack(Blocks.field_150344_f, 3, Short.MAX_VALUE))).inputs(new ItemStack(Blocks.field_150347_e, 4))).input(OrePrefix.dust, Materials.Redstone)).outputs(new ItemStack((Block)Blocks.field_150331_J))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(16)).input(OrePrefix.plate, Materials.Steel)).inputs(new ItemStack(Blocks.field_150344_f, 3, Short.MAX_VALUE))).inputs(new ItemStack(Blocks.field_150347_e, 4))).input(OrePrefix.dust, Materials.Redstone)).outputs(new ItemStack((Block)Blocks.field_150331_J, 2))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(16)).input(OrePrefix.plate, Materials.Aluminium)).inputs(new ItemStack(Blocks.field_150344_f, 3, Short.MAX_VALUE))).inputs(new ItemStack(Blocks.field_150347_e, 4))).input(OrePrefix.dust, Materials.Redstone)).outputs(new ItemStack((Block)Blocks.field_150331_J, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(16)).input(OrePrefix.plate, Materials.Titanium)).inputs(new ItemStack(Blocks.field_150344_f, 3, Short.MAX_VALUE))).inputs(new ItemStack(Blocks.field_150347_e, 4))).input(OrePrefix.dust, Materials.Redstone)).outputs(new ItemStack((Block)Blocks.field_150331_J, 8))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Gold, 2)).outputs(new ItemStack(Blocks.field_150445_bS, 1))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron, 2)).outputs(new ItemStack(Blocks.field_150443_bT, 1))).circuitMeta(2).duration(100)).EUt(4)).buildAndRegister();
        ModHandler.addShapedRecipe("comparator_certus", new ItemStack(Items.field_151132_bS), " T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('Q'), new UnificationEntry(OrePrefix.gem, Materials.CertusQuartz), Character.valueOf('S'), new UnificationEntry(OrePrefix.stone));
        ModHandler.addShapedRecipe("comparator_quartzite", new ItemStack(Items.field_151132_bS), " T ", "TQT", "SSS", Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('Q'), new UnificationEntry(OrePrefix.gem, Materials.Quartzite), Character.valueOf('S'), new UnificationEntry(OrePrefix.stone));
        ModHandler.addShapedRecipe("daylight_detector_certus", new ItemStack((Block)Blocks.field_150453_bW), "GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE), Character.valueOf('C'), new UnificationEntry(OrePrefix.gem, Materials.CertusQuartz), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150376_bx, 1, Short.MAX_VALUE));
        ModHandler.addShapedRecipe("daylight_detector_quartzite", new ItemStack((Block)Blocks.field_150453_bW), "GGG", "CCC", "PPP", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE), Character.valueOf('C'), new UnificationEntry(OrePrefix.gem, Materials.Quartzite), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150376_bx, 1, Short.MAX_VALUE));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(16)).inputs(new ItemStack(Blocks.field_150344_f, 8, Short.MAX_VALUE))).input(OrePrefix.dust, Materials.Redstone)).circuitMeta(1).outputs(new ItemStack(Blocks.field_150323_B))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(16)).inputs(new ItemStack(Blocks.field_150344_f, 8, Short.MAX_VALUE))).input(OrePrefix.gem, Materials.Diamond)).outputs(new ItemStack(Blocks.field_150421_aI))).buildAndRegister();
    }

    private static void metalRecipes() {
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(12).input(OrePrefix.plate, Materials.Iron, 3)).outputs(new ItemStack(Items.field_151133_ar))).duration(100)).EUt(4)).buildAndRegister();
        if (!ConfigHolder.recipes.hardToolArmorRecipes) {
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Redstone)).input(OrePrefix.plate, Materials.Iron, 4)).circuitMeta(1).outputs(new ItemStack(Items.field_151111_aL))).duration(100)).EUt(4)).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Redstone)).input(OrePrefix.plate, Materials.Gold, 4)).outputs(new ItemStack(Items.field_151113_aN))).duration(100)).EUt(4)).buildAndRegister();
        }
        ModHandler.addShapedRecipe("iron_horse_armor", new ItemStack(Items.field_151138_bX), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((Item)Items.field_151028_Y), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Iron), Character.valueOf('C'), new ItemStack((Item)Items.field_151030_Z), Character.valueOf('L'), new ItemStack((Item)Items.field_151165_aa), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron));
        ModHandler.addShapedRecipe("golden_horse_armor", new ItemStack(Items.field_151136_bY), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((Item)Items.field_151169_ag), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Gold), Character.valueOf('C'), new ItemStack((Item)Items.field_151171_ah), Character.valueOf('L'), new ItemStack((Item)Items.field_151149_ai), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Gold));
        ModHandler.addShapedRecipe("diamond_horse_armor", new ItemStack(Items.field_151125_bZ), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((Item)Items.field_151161_ac), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Diamond), Character.valueOf('C'), new ItemStack((Item)Items.field_151163_ad), Character.valueOf('L'), new ItemStack((Item)Items.field_151173_ae), Character.valueOf('S'), new UnificationEntry(OrePrefix.bolt, Materials.Diamond));
        ModHandler.addShapedRecipe("chainmail_helmet", new ItemStack((Item)Items.field_151020_U), "PPP", "PhP", Character.valueOf('P'), new UnificationEntry(OrePrefix.ring, Materials.Iron));
        ModHandler.addShapedRecipe("chainmail_chestplate", new ItemStack((Item)Items.field_151023_V), "PhP", "PPP", "PPP", Character.valueOf('P'), new UnificationEntry(OrePrefix.ring, Materials.Iron));
        ModHandler.addShapedRecipe("chainmail_leggings", new ItemStack((Item)Items.field_151022_W), "PPP", "PhP", "P P", Character.valueOf('P'), new UnificationEntry(OrePrefix.ring, Materials.Iron));
        ModHandler.addShapedRecipe("chainmail_boots", new ItemStack((Item)Items.field_151029_X), "P P", "PhP", Character.valueOf('P'), new UnificationEntry(OrePrefix.ring, Materials.Iron));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron, 7)).outputs(new ItemStack(Items.field_151066_bu, 1))).circuitMeta(7).duration(700)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Iron, 3)).outputs(new ItemStack(Blocks.field_150411_aY, 4))).circuitMeta(3).duration(300)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron, 4)).circuitMeta(4).outputs(new ItemStack(Blocks.field_180400_cw))).duration(100)).EUt(16)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron, 6)).circuitMeta(6).outputs(new ItemStack(Items.field_151139_aw))).duration(100)).EUt(16)).buildAndRegister();
    }

    private static void miscRecipes() {
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151121_aF, 3))).inputs(new ItemStack(Items.field_151116_aA))).fluidInputs(Materials.Glue.getFluid(20))).outputs(new ItemStack(Items.field_151122_aG))).duration(32)).EUt(GTValues.VA[0])).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151121_aF, 3))).input(OrePrefix.foil, Materials.PolyvinylChloride)).fluidInputs(Materials.Glue.getFluid(20))).outputs(new ItemStack(Items.field_151122_aG))).duration(20)).EUt(16)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151121_aF, 8))).inputs(new ItemStack(Items.field_151111_aL))).outputs(new ItemStack((Item)Items.field_151148_bJ))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Netherrack)).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).outputs(new ItemStack(Items.field_151130_bT))).duration(200)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151119_aD))).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).outputs(new ItemStack(Items.field_151118_aC))).duration(200)).EUt(2)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151007_F, 4, Short.MAX_VALUE))).inputs(new ItemStack(Items.field_151123_aH, 1, Short.MAX_VALUE))).outputs(new ItemStack(Items.field_151058_ca, 2))).duration(100)).EUt(2)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151116_aA))).inputs(new ItemStack(Items.field_151058_ca))).fluidInputs(Materials.Glue.getFluid(100))).outputs(new ItemStack(Items.field_151057_cb))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151007_F, 3, Short.MAX_VALUE))).input(OrePrefix.stick, Materials.Wood, 3)).outputs(new ItemStack((Item)Items.field_151031_f, 1))).duration(100)).EUt(4)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(128)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BALL)).fluidInputs(Materials.Water.getFluid(250))).outputs(new ItemStack(Items.field_151126_ay))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(128)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BALL)).fluidInputs(Materials.DistilledWater.getFluid(250))).outputs(new ItemStack(Items.field_151126_ay))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(512)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).fluidInputs(Materials.Water.getFluid(1000))).outputs(new ItemStack(Blocks.field_150433_aE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(512)).EUt(4)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).fluidInputs(Materials.DistilledWater.getFluid(1000))).outputs(new ItemStack(Blocks.field_150433_aE))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(1024)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).fluidInputs(Materials.Lava.getFluid(1000))).outputs(new ItemStack(Blocks.field_150343_Z))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().duration(1680)).EUt(16)).notConsumable(MetaItems.SHAPE_MOLD_ANVIL)).fluidInputs(Materials.Iron.getFluid(4464))).outputs(new ItemStack(Blocks.field_150467_bQ))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, Materials.Iron, 31)).notConsumable(MetaItems.SHAPE_MOLD_ANVIL)).outputs(new ItemStack(Blocks.field_150467_bQ))).duration(1680)).EUt(16)).buildAndRegister();
        ModHandler.addSmeltingRecipe(new ItemStack(Items.field_151123_aH), MetaItems.STICKY_RESIN.getStackForm(), 0.3f);
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151007_F, 4))).notConsumable(new IntCircuitIngredient(4))).outputs(new ItemStack(Blocks.field_150325_L, 1, 0))).duration(100)).EUt(4)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OreDictNames.cobblestone.name(), 1)).inputs(new ItemStack(Blocks.field_150395_bd))).outputs(new ItemStack(Blocks.field_150341_Y))).duration(40)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150417_aV, 1, 0))).inputs(new ItemStack(Blocks.field_150395_bd))).outputs(new ItemStack(Blocks.field_150417_aV, 1, 1))).duration(40)).EUt(1)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).input(OreDictNames.stoneCobble.name(), 6)).outputs(new ItemStack(Blocks.field_150446_ar, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150336_V, 6))).outputs(new ItemStack(Blocks.field_150389_bf, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150417_aV, 6, Short.MAX_VALUE))).outputs(new ItemStack(Blocks.field_150390_bg, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150385_bj, 6))).outputs(new ItemStack(Blocks.field_150387_bl, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150322_A, 6))).outputs(new ItemStack(Blocks.field_150372_bz, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_150371_ca, 6))).outputs(new ItemStack(Blocks.field_150370_cb, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(7).inputs(new ItemStack(Blocks.field_185767_cT, 6))).outputs(new ItemStack(Blocks.field_185769_cV, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(1)).duration(100)).circuitMeta(2).inputs(new ItemStack(Blocks.field_150371_ca, 1, 0))).outputs(new ItemStack(Blocks.field_150371_ca, 1, 2))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150348_b))).outputs(new ItemStack(Blocks.field_150417_aV, 1, 0))).circuitMeta(4).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150377_bs))).outputs(new ItemStack(Blocks.field_185772_cY, 1, 0))).circuitMeta(4).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150322_A))).outputs(new ItemStack(Blocks.field_150322_A, 1, 2))).circuitMeta(1).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_180395_cM))).outputs(new ItemStack(Blocks.field_180395_cM, 1, 2))).circuitMeta(1).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_150322_A, 1, 2))).outputs(new ItemStack(Blocks.field_150322_A, 1, 0))).circuitMeta(1).duration(50)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).inputs(new ItemStack(Blocks.field_180395_cM, 1, 2))).outputs(new ItemStack(Blocks.field_180395_cM, 1, 0))).circuitMeta(1).duration(50)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder().EUt(4)).duration(100)).inputs(new ItemStack(Blocks.field_150423_aK))).inputs(new ItemStack(Blocks.field_150478_aa))).outputs(new ItemStack(Blocks.field_150428_aP))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().EUt(4)).duration(40)).inputs(new ItemStack(Items.field_179563_cD, 5))).inputs(new ItemStack(Items.field_179562_cC, 4))).outputs(new ItemStack(Blocks.field_180398_cJ))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().EUt(4)).duration(40)).inputs(new ItemStack(Items.field_151130_bT, 2))).inputs(new ItemStack(Items.field_151075_bm, 2))).outputs(new ItemStack(Blocks.field_189879_dh))).buildAndRegister();
        if (!ConfigHolder.recipes.hardMiscRecipes) {
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(80)).EUt(6)).circuitMeta(4).input("plankWood", 4)).outputs(new ItemStack(Blocks.field_150462_ai))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().circuitMeta(8).input(OreDictNames.stoneCobble.name(), 8)).outputs(new ItemStack(Blocks.field_150460_al))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150343_Z, 4))).input(OrePrefix.gem, Materials.Diamond, 2)).inputs(new ItemStack(Items.field_151122_aG))).outputs(new ItemStack(Blocks.field_150381_bn))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[1])).circuitMeta(1).inputs(new ItemStack(Blocks.field_150347_e, 7))).inputs(new ItemStack((Item)Items.field_151031_f))).input(OrePrefix.dust, Materials.Redstone)).outputs(new ItemStack(Blocks.field_150367_z))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[1])).circuitMeta(2).inputs(new ItemStack(Blocks.field_150347_e, 7))).input(OrePrefix.dust, Materials.Redstone)).outputs(new ItemStack(Blocks.field_150409_cd))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[1])).inputs(new ItemStack(Blocks.field_150347_e, 6))).input(OrePrefix.dust, Materials.Redstone, 2)).input(OrePrefix.plate, Materials.NetherQuartz)).outputs(new ItemStack(Blocks.field_190976_dk))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[1])).inputs(new ItemStack(Blocks.field_150347_e, 6))).input(OrePrefix.dust, Materials.Redstone, 2)).input(OrePrefix.plate, Materials.CertusQuartz)).outputs(new ItemStack(Blocks.field_190976_dk))).buildAndRegister();
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[1])).inputs(new ItemStack(Blocks.field_150347_e, 6))).input(OrePrefix.dust, Materials.Redstone, 2)).input(OrePrefix.plate, Materials.Quartzite)).outputs(new ItemStack(Blocks.field_190976_dk))).buildAndRegister();
        }
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(4)).circuitMeta(3).inputs(new ItemStack(Blocks.field_150385_bj))).outputs(new ItemStack(Blocks.field_150386_bk))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(4)).inputs(new ItemStack(Blocks.field_150343_Z, 8))).inputs(new ItemStack(Items.field_151061_bv))).outputs(new ItemStack(Blocks.field_150477_bB))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[0])).circuitMeta(6).inputs(new ItemStack(Blocks.field_150347_e, 1, 0))).outputs(new ItemStack(Blocks.field_150463_bK, 1, 0))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[0])).circuitMeta(6).inputs(new ItemStack(Blocks.field_150341_Y, 1, 0))).outputs(new ItemStack(Blocks.field_150463_bK, 1, 1))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(4)).inputs(new ItemStack(Items.field_185162_cT))).inputs(new ItemStack(Items.field_151072_bj))).outputs(new ItemStack(Blocks.field_185764_cQ, 4))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(GTValues.VA[0])).input("chestWood", 1)).inputs(new ItemStack(Items.field_190930_cZ, 2))).outputs(new ItemStack(Blocks.field_190987_dv))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(4)).circuitMeta(1).input("wool", 1)).inputs(new ItemStack(Items.field_151055_y, 8))).outputs(new ItemStack(Items.field_151159_an))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(4)).inputs(new ItemStack(Items.field_151116_aA))).inputs(new ItemStack(Items.field_151055_y, 8))).outputs(new ItemStack(Items.field_151160_bD))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(100)).EUt(4)).input("plankWood", 6)).inputs(new ItemStack(Items.field_151055_y))).circuitMeta(1).outputs(new ItemStack(Items.field_151155_ap, 3))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(10)).EUt(2)).inputs(new ItemStack(Items.field_151118_aC, 3))).outputs(new ItemStack(Items.field_151162_bE))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(30)).EUt(GTValues.VA[0])).inputs(new ItemStack((Block)Blocks.field_150333_U, 1, 0))).inputs(new ItemStack(Items.field_151055_y, 6))).outputs(new ItemStack((Item)Items.field_179565_cj))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().duration(30)).EUt(16)).inputs(new ItemStack(Items.field_151073_bk))).inputs(new ItemStack(Items.field_151061_bv))).outputs(new ItemStack(Items.field_185158_cP))).fluidInputs(Materials.Glass.getFluid(1008))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Iron, 12)).input(OrePrefix.stick, Materials.Wood)).circuitMeta(1).outputs(new ItemStack(Blocks.field_150448_aq, 32))).duration(100)).EUt(GTValues.VA[1])).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Gold, 12)).input(OrePrefix.stick, Materials.Wood)).input(OrePrefix.dust, Materials.Redstone)).circuitMeta(1).outputs(new ItemStack(Blocks.field_150318_D, 12))).duration(100)).EUt(GTValues.VA[1])).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Iron, 12)).input(OrePrefix.stick, Materials.Wood)).input(OrePrefix.dust, Materials.Redstone)).circuitMeta(4).outputs(new ItemStack(Blocks.field_150319_E, 12))).duration(100)).EUt(GTValues.VA[1])).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, Materials.Iron, 12)).input(OrePrefix.stick, Materials.Wood, 2)).inputs(new ItemStack(Blocks.field_150429_aA))).circuitMeta(4).outputs(new ItemStack(Blocks.field_150408_cc, 12))).duration(100)).EUt(GTValues.VA[1])).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, Materials.Iron, 3)).input(OrePrefix.ring, Materials.Iron, 4)).outputs(new ItemStack(Items.field_151143_au))).duration(100)).EUt(4)).buildAndRegister();
        ModHandler.addShapedRecipe("saddle", new ItemStack(Items.field_151141_av), "LLL", "LCL", "RSR", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('C'), new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('S'), new ItemStack(Items.field_151007_F));
        for (FluidStack fluidStack : new FluidStack[]{Materials.Water.getFluid(200), Materials.DistilledWater.getFluid(36)}) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150348_b, 1, 1))).fluidInputs(fluidStack)).outputs(new ItemStack(Blocks.field_150348_b, 1, 2))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150348_b, 1, 3))).fluidInputs(fluidStack)).outputs(new ItemStack(Blocks.field_150348_b, 1, 4))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150348_b, 1, 5))).fluidInputs(fluidStack)).outputs(new ItemStack(Blocks.field_150348_b, 1, 6))).duration(100)).EUt(GTValues.VA[0])).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Clay)).fluidInputs(Materials.Water.getFluid(250))).outputs(new ItemStack(Items.field_151119_aD))).duration(600)).EUt(24)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Redstone, 9)).output(OrePrefix.block, Materials.Redstone)).duration(300)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Bone, 9)).output(OrePrefix.block, Materials.Bone)).duration(300)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_185162_cT, 4))).outputs(new ItemStack(Blocks.field_185767_cT, 4))).duration(300)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151064_bs, 4))).outputs(new ItemStack(Blocks.field_189877_df))).duration(300)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151123_aH, 9))).outputs(new ItemStack(Blocks.field_180399_cE))).duration(300)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_151075_bm, 9))).notConsumable(new IntCircuitIngredient(9))).outputs(new ItemStack(Blocks.field_189878_dg))).duration(200)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_179562_cC, 4))).notConsumable(new IntCircuitIngredient(4))).outputs(new ItemStack(Blocks.field_180397_cI))).duration(100)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_179562_cC, 9))).notConsumable(new IntCircuitIngredient(9))).outputs(new ItemStack(Blocks.field_180397_cI, 1, 1))).duration(200)).EUt(2)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().fluidInputs(Materials.Blaze.getFluid(144))).input(OrePrefix.gem, Materials.EnderPearl)).outputs(new ItemStack(Items.field_151061_bv))).duration(50)).EUt(GTValues.VA[3])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Blaze, 4)).output(OrePrefix.stick, Materials.Blaze)).buildAndRegister();
    }

    private static void mixingRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().input(OrePrefix.dust, Materials.Coal)).input(OrePrefix.dust, Materials.Gunpowder)).input(OrePrefix.dust, Materials.Blaze)).outputs(new ItemStack(Items.field_151059_bz, 3))).duration(100)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150351_n))).inputs(new ItemStack(Blocks.field_150346_d))).outputs(new ItemStack(Blocks.field_150346_d, 2, 1))).duration(100)).EUt(4)).buildAndRegister();
    }

    private static void dyeRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 0))).outputs(new ItemStack(Items.field_151100_aR, 2, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 1))).outputs(new ItemStack(Items.field_151100_aR, 2, 12))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 2))).outputs(new ItemStack(Items.field_151100_aR, 2, 13))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 3))).outputs(new ItemStack(Items.field_151100_aR, 2, 7))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 4))).outputs(new ItemStack(Items.field_151100_aR, 2, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 5))).outputs(new ItemStack(Items.field_151100_aR, 2, 14))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 6))).outputs(new ItemStack(Items.field_151100_aR, 2, 7))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 7))).outputs(new ItemStack(Items.field_151100_aR, 2, 9))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150328_O, 1, 8))).outputs(new ItemStack(Items.field_151100_aR, 2, 7))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150327_N, 1, 0))).outputs(new ItemStack(Items.field_151100_aR, 2, 11))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150398_cm, 1, 0))).outputs(new ItemStack(Items.field_151100_aR, 3, 11))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150398_cm, 1, 1))).outputs(new ItemStack(Items.field_151100_aR, 3, 13))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150398_cm, 1, 4))).outputs(new ItemStack(Items.field_151100_aR, 3, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack((Block)Blocks.field_150398_cm, 1, 5))).outputs(new ItemStack(Items.field_151100_aR, 3, 9))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_185164_cV, 1))).outputs(new ItemStack(Items.field_151100_aR, 2, 1))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().inputs(new ItemStack(Items.field_179562_cC, 8))).fluidInputs(Materials.DyeBlack.getFluid(144))).outputs(new ItemStack(Blocks.field_180397_cI, 1, 2))).duration(20)).EUt(GTValues.VA[0])).buildAndRegister();
    }
}

