/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.compat.baubles;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import fi.dy.masa.justenoughdimensions.util.PlayerInventoryHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class BaublesCompat {
    @CapabilityInject(value=IBaublesItemHandler.class)
    public static <T> void initBaubles(Capability<T> capability) {
        PlayerInventoryHandler.INSTANCE.addHandler(new PlayerInventoryHandler.InventoryHandler("baubles", InventoryViewBaubles::new));
    }

    public static class InventoryViewBaubles
    implements PlayerInventoryHandler.IInventoryView {
        private final IBaublesItemHandler inv;

        public InventoryViewBaubles(EntityPlayer player) {
            this.inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        }

        @Override
        public int getSlotCount() {
            return this.inv != null ? this.inv.getSlots() : 0;
        }

        @Override
        public ItemStack getStack(int slot) {
            return this.inv.getStackInSlot(slot);
        }

        @Override
        public void setStack(int slot, ItemStack stack) {
            this.inv.setStackInSlot(slot, stack);
        }
    }
}

