/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.morelibs.register;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import panszelescik.morelibs.MoreLibs;
import panszelescik.morelibs.register.Register;

@Mod.EventBusSubscriber(modid="morelibs")
public class Registerer {
    private static HashMap<String, List<Class>> registryClasses = new HashMap();
    private static List<Item> registeredItems = new ArrayList<Item>();
    private static List<Block> registeredBlocks = new ArrayList<Block>();

    public static void addRegistryClasses(ASMDataTable dataTable) {
        for (ASMDataTable.ASMData data : dataTable.getAll(Register.class.getName())) {
            try {
                String modid = (String)data.getAnnotationInfo().get("modid");
                if (!registryClasses.containsKey(modid)) {
                    registryClasses.put(modid, new ArrayList());
                }
                registryClasses.get(modid).add(Class.forName(data.getClassName()));
                MoreLibs.logger.info("Found registerer class: " + data.getClassName());
            }
            catch (Exception e) {
                MoreLibs.logger.error("Unable to add registerer class: " + data.getClassName() + "! An error occurred:");
                MoreLibs.logger.catching(Level.ERROR, (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        MoreLibs.logger.info("Searching for items to register");
        for (Map.Entry<String, List<Class>> entry : registryClasses.entrySet()) {
            Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get(entry.getKey()));
            for (Class clazz : entry.getValue()) {
                for (Method method : clazz.getMethods()) {
                    if (!method.isAnnotationPresent(Register.RegisterItemInit.class)) continue;
                    try {
                        method.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        MoreLibs.logger.error("Unable to initialise items using init method: " + method.getName() + "! The following error was thrown:");
                        MoreLibs.logger.catching(Level.ERROR, (Throwable)e);
                    }
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                    ItemBlock item;
                    Block block;
                    Annotation details;
                    if (accessibleObject.isAnnotationPresent(Register.RegisterItem.class)) {
                        try {
                            details = ((Field)accessibleObject).getAnnotation(Register.RegisterItem.class);
                            Item item2 = (Item)((Field)accessibleObject).get(null);
                            if (item2 == null) {
                                item2 = (Item)((Field)accessibleObject).getType().newInstance();
                                ((Field)accessibleObject).set(null, item2);
                            }
                            if (item2.getRegistryName() == null) {
                                item2.setRegistryName(new ResourceLocation(entry.getKey(), details.registryName()));
                            }
                            if (details.setTranslationKey()) {
                                if (!details.translationKey().isEmpty()) {
                                    item2.func_77655_b(details.translationKey());
                                } else {
                                    item2.func_77655_b(details.registryName());
                                }
                            }
                            event.getRegistry().register((IForgeRegistryEntry)item2);
                            registeredItems.add(item2);
                        }
                        catch (Exception e) {
                            MoreLibs.logger.error("Unable to register item: " + ((Field)accessibleObject).getName() + "! The following error was thrown:");
                            MoreLibs.logger.catching(Level.ERROR, (Throwable)e);
                        }
                    }
                    if (accessibleObject.isAnnotationPresent(Register.RegisterBlock.class)) {
                        try {
                            details = ((Field)accessibleObject).getAnnotation(Register.RegisterBlock.class);
                            if (details.registerItemBlock()) {
                                block = (Block)((Field)accessibleObject).get(null);
                                if (block == null) {
                                    block = (Block)((Field)accessibleObject).getType().newInstance();
                                    ((Field)accessibleObject).set(null, block);
                                }
                                if ((item = new ItemBlock(block)).getRegistryName() == null) {
                                    item.setRegistryName(new ResourceLocation(entry.getKey(), details.registryName()));
                                }
                                if (details.setTranslationKey()) {
                                    if (!details.translationKey().isEmpty()) {
                                        item.func_77655_b(details.translationKey());
                                    } else {
                                        item.func_77655_b(details.registryName());
                                    }
                                }
                                event.getRegistry().register((IForgeRegistryEntry)item);
                                registeredItems.add((Item)item);
                            }
                        }
                        catch (Exception e) {
                            MoreLibs.logger.error("Unable to register item block: " + ((Field)accessibleObject).getName() + "! The following error was thrown:");
                            MoreLibs.logger.catching(Level.ERROR, (Throwable)e);
                        }
                    }
                    if (!accessibleObject.isAnnotationPresent(Register.RegisterItemBlock.class)) continue;
                    try {
                        details = ((Field)accessibleObject).getAnnotation(Register.RegisterItemBlock.class);
                        block = (Block)((Field)accessibleObject).get(null);
                        if (block == null) {
                            block = (Block)((Field)accessibleObject).getType().newInstance();
                            ((Field)accessibleObject).set(null, block);
                        }
                        if ((item = new ItemBlock(block)).getRegistryName() == null) {
                            item.setRegistryName(new ResourceLocation(entry.getKey(), details.registryName()));
                        }
                        if (details.setTranslationKey()) {
                            if (!details.translationKey().isEmpty()) {
                                item.func_77655_b(details.translationKey());
                            } else {
                                item.func_77655_b(details.registryName());
                            }
                        }
                        event.getRegistry().register((IForgeRegistryEntry)item);
                        registeredItems.add((Item)item);
                    }
                    catch (Exception e) {
                        MoreLibs.logger.error("Unable to register item block: " + ((Field)accessibleObject).getName() + "! The following error was thrown:");
                        MoreLibs.logger.catching(Level.ERROR, (Throwable)e);
                    }
                }
            }
        }
        Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get("morelibs"));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        MoreLibs.logger.info("Searching for blocks and tiles to register");
        for (Map.Entry<String, List<Class>> entry : registryClasses.entrySet()) {
            Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get(entry.getKey()));
            for (Class clazz : entry.getValue()) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(Register.RegisterBlockInit.class)) continue;
                    try {
                        method.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        MoreLibs.logger.error("Unable to initialise items using init method: " + method.getName() + "! The following error was thrown:");
                        MoreLibs.logger.catching(Level.ERROR, (Throwable)e);
                    }
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                    if (!accessibleObject.isAnnotationPresent(Register.RegisterBlock.class)) continue;
                    try {
                        Register.RegisterBlock details = ((Field)accessibleObject).getAnnotation(Register.RegisterBlock.class);
                        Block block = (Block)((Field)accessibleObject).get(null);
                        if (block == null) {
                            block = (Block)((Field)accessibleObject).getType().newInstance();
                            ((Field)accessibleObject).set(null, block);
                        }
                        if (block.getRegistryName() == null) {
                            block.setRegistryName(new ResourceLocation(entry.getKey(), details.registryName()));
                        }
                        if (details.setTranslationKey()) {
                            if (!details.translationKey().isEmpty()) {
                                block.func_149663_c(details.translationKey());
                            } else {
                                block.func_149663_c(details.registryName());
                            }
                        }
                        event.getRegistry().register((IForgeRegistryEntry)block);
                        registeredBlocks.add(block);
                    }
                    catch (Exception e) {
                        MoreLibs.logger.error("Unable to register block: " + ((Field)accessibleObject).getName() + "! The following error was thrown:");
                        MoreLibs.logger.catching(Level.ERROR, (Throwable)e);
                    }
                }
            }
        }
        Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getIndexedModList().get("morelibs"));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        for (Item item : registeredItems) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (Block block : registeredBlocks) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
    }
}

