/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.construction;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import eutros.multiblocktweaker.crafttweaker.CustomMultiblock;
import eutros.multiblocktweaker.crafttweaker.MultiblockRegistry;
import eutros.multiblocktweaker.crafttweaker.functions.IPatternBuilderFunction;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IICubeRenderer;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IMultiblockShapeInfo;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.renderer.ICubeRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.multiblock.Builder")
@ZenRegister
public class MultiblockBuilder {
    public ResourceLocation loc;
    public int metaId;
    public ICubeRenderer baseTexture;
    public RecipeMap<?> recipeMap;
    public IPatternBuilderFunction pattern;
    public List<MultiblockShapeInfo> designs;
    private static int AUTO_ID = 32000;

    private MultiblockBuilder(ResourceLocation loc, int metaId) {
        this.loc = loc;
        this.metaId = metaId;
    }

    @ZenMethod
    public static MultiblockBuilder start(@NotNull String location, int metaId) {
        ResourceLocation loc = new ResourceLocation(location);
        if (loc.func_110624_b().equals("minecraft")) {
            loc = new ResourceLocation("multiblocktweaker", loc.func_110623_a());
        }
        return new MultiblockBuilder(loc, metaId);
    }

    @ZenMethod
    public static MultiblockBuilder start(@NotNull String location) {
        while (MultiblockRegistry.get(AUTO_ID) != null) {
            ++AUTO_ID;
        }
        return MultiblockBuilder.start(location, AUTO_ID++);
    }

    @ZenMethod
    public MultiblockBuilder withPattern(@NotNull IPatternBuilderFunction pattern) {
        this.pattern = pattern;
        return this;
    }

    @ZenMethod
    public MultiblockBuilder withRecipeMap(@NotNull RecipeMap<?> map) {
        this.recipeMap = map;
        return this;
    }

    @ZenMethod
    public MultiblockBuilder withBaseTexture(@NotNull IICubeRenderer texture) {
        this.baseTexture = texture;
        return this;
    }

    @ZenMethod
    public MultiblockBuilder addDesign(IMultiblockShapeInfo ... designs) {
        if (this.designs == null) {
            this.designs = new ArrayList<MultiblockShapeInfo>();
        }
        for (IMultiblockShapeInfo design : designs) {
            this.designs.add(design.getInternal());
        }
        return this;
    }

    @ZenMethod
    @Nullable
    public CustomMultiblock build() {
        if (this.pattern == null) {
            CraftTweakerAPI.logError((String)String.format("No pattern defined for multiblock \"%s\"", this.loc));
            return null;
        }
        if (this.recipeMap == null) {
            CraftTweakerAPI.logError((String)String.format("No recipeMap defined for multiblock \"%s\"", this.loc));
            return null;
        }
        if (this.baseTexture == null) {
            CraftTweakerAPI.logError((String)String.format("No baseTexture defined for multiblock \"%s\"", this.loc));
            return null;
        }
        return new CustomMultiblock(this);
    }

    @Nullable
    @ZenMethod
    public CustomMultiblock buildAndRegister() {
        return Optional.ofNullable(this.build()).map(CustomMultiblock::register).orElse(null);
    }
}

