/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.gregtech.recipes;

import eutros.multiblocktweaker.gregtech.recipes.CustomRecipeProperty;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.ValidationResult;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CustomRecipeBuilder
extends RecipeBuilder<CustomRecipeBuilder> {
    Map<CustomRecipeProperty, Object> properties;

    private CustomRecipeBuilder(CustomRecipeBuilder builder, Map<CustomRecipeProperty, Object> recipeProperties) {
        super((RecipeBuilder)builder);
        this.properties = recipeProperties;
    }

    public CustomRecipeBuilder(CustomRecipeProperty[] recipeProperties) {
        if (recipeProperties.length > 0) {
            this.properties = new HashMap<CustomRecipeProperty, Object>();
            for (CustomRecipeProperty recipeProperty : recipeProperties) {
                this.properties.put(recipeProperty, null);
            }
        }
    }

    @NotNull
    public CustomRecipeBuilder copy() {
        return new CustomRecipeBuilder(this, this.properties);
    }

    @NotNull
    public ValidationResult<Recipe> build() {
        Recipe recipe = new Recipe(this.inputs, this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, this.duration, this.EUt, this.hidden, this.isCTRecipe, this.recipePropertyStorage);
        return ValidationResult.newResult((EnumValidationResult)this.finalizeAndValidate(), (Object)recipe);
    }

    public boolean applyProperty(String key, Object value) {
        if (this.properties == null) {
            return false;
        }
        CustomRecipeProperty property = this.properties.keySet().stream().filter(p -> p.getKey().equals(key)).findFirst().orElse(null);
        if (property == null) {
            return false;
        }
        this.properties.put(property, value);
        return true;
    }
}

