/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.xz.rangecoder;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import me.lucko.spark.lib.xz.CorruptedInputException;
import me.lucko.spark.lib.xz.rangecoder.RangeDecoder;

public final class RangeDecoderFromStream
extends RangeDecoder {
    private final DataInputStream inData;

    public RangeDecoderFromStream(InputStream inputStream) throws IOException {
        this.inData = new DataInputStream(inputStream);
        if (this.inData.readUnsignedByte() != 0) {
            throw new CorruptedInputException();
        }
        this.code = this.inData.readInt();
        this.range = -1;
    }

    public boolean isFinished() {
        return this.code == 0;
    }

    public void normalize() throws IOException {
        if ((this.range & 0xFF000000) == 0) {
            this.code = this.code << 8 | this.inData.readUnsignedByte();
            this.range <<= 8;
        }
    }
}

