/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.network.internet;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.thedragonteam.thedragonlib.network.internet.POSTResponse;

public class POSTRequest {
    public String target;
    public String params;
    public String useragent;

    public POSTRequest() {
        this.target = "";
        this.params = "";
        this.useragent = "";
    }

    public POSTRequest(String tar) {
        this.target = tar;
        this.params = "";
        this.useragent = "TheDragonLib";
    }

    public POSTRequest(String tar, String par) {
        this.target = tar;
        this.params = par;
        this.useragent = "TheDragonLib";
    }

    public POSTRequest(String tar, String par, String agent) {
        this.target = tar;
        this.params = par;
        this.useragent = agent;
    }

    public void setTarget(String tar) {
        this.target = tar;
    }

    public void setParameters(String par) {
        this.params = par;
    }

    public void addParameter(String par) {
        this.params = this.params + "&" + par;
    }

    public void setUserAgent(String agent) {
        this.useragent = agent;
    }

    public POSTResponse execute() throws IOException {
        String inputLine;
        URL obj = new URL(this.target);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", this.useragent);
        con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        String urlParameters = this.params;
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(urlParameters);
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return new POSTResponse(responseCode, response.toString(), this.target, this.params, this.useragent);
    }
}

