/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.ad_astra.common.item.OxygenTankItem;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class OxygenChargerUtils {
    public static void distributeToItems(LivingEntity living) {
        OxygenChargerUtils.streamExtractable(living, FluidHooks2.MILLI_BUCKET).forEach(c -> OxygenChargerUtils.distributeToItems(living, c));
    }

    public static void distributeToItems(LivingEntity living, IOxygenCharger oxygenCharger) {
        FluidHolder moved;
        UniveralFluidHandler itemFluidHandler;
        ItemStackReference itemRef;
        Item item;
        UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
        List<ItemStackReference> items = oxygenCharger.getChargeMode().getItems(living);
        long transfer = oxygenCharger.getTransferAmount();
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && (!((item = (itemRef = (ItemStackReference)((Object)iterator.next())).getStack().m_41720_()) instanceof SpaceSuit) && !(item instanceof OxygenTankItem) || (itemFluidHandler = (UniveralFluidHandler)UniveralFluidHandler.fromSafe(itemRef).orElse(null)) == null || (moved = FluidHooks2.moveFluidAny(fluidHandler, itemFluidHandler, FluidPredicates::isOxygen, transfer, false)).isEmpty() || (transfer -= moved.getFluidAmount()) > 0L)) {
        }
    }

    public static OptionalDouble getExtractableStoredRatio(LivingEntity living) {
        List<ItemStackReference> items = LivingHelper.getInventoryItems(living);
        long stored = 0L;
        long capacity = 0L;
        int temperature = (int)ModUtils.getWorldTemperature((Level)living.m_9236_());
        for (ItemStackReference item : items) {
            IOxygenCharger oxygenCharger = OxygenChargerUtils.get(item);
            if (oxygenCharger == null || !oxygenCharger.getTemperatureThreshold().contains((Object)temperature)) continue;
            stored += oxygenCharger.getTotalAmount();
            capacity += oxygenCharger.getTotalCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenCharger firstExtractable(LivingEntity living, long extracting) {
        return OxygenChargerUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<IOxygenCharger> streamExtractable(LivingEntity living, long extracting) {
        int temperature = (int)ModUtils.getWorldTemperature((Level)living.m_9236_());
        return LivingHelper.getInventoryItems(living).stream().map(OxygenChargerUtils::get).filter(oxygenCharger -> {
            FluidHolder extract;
            return oxygenCharger != null && oxygenCharger.getTemperatureThreshold().contains((Object)temperature) && !(extract = FluidHooks2.extractFluid(oxygenCharger.getFluidHandler(), FluidPredicates::isOxygen, extracting, true)).isEmpty() && extract.getFluidAmount() >= extracting;
        });
    }

    @Nullable
    public static IOxygenCharger get(ItemStackHolder item) {
        Item item2 = item.getStack().m_41720_();
        if (item2 instanceof IOxygenChargerItem) {
            IOxygenChargerItem oxygenChargerItem = (IOxygenChargerItem)item2;
            return oxygenChargerItem.getOxygenCharger(item);
        }
        return null;
    }

    private OxygenChargerUtils() {
    }
}

