/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.Parsers;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.level.block.state.BlockState;

public class Replacements
extends AbstractParsableList {
    protected final Parsers.UnitId_OptInteger oreParser = new Parsers.UnitId_OptInteger(IntBounds.INTEGER_POSITIVE, ",");
    protected final Function<UnitId, Optional<BlockState>> oreMapper;
    protected final BlockStatesMap<CommonCollect.WeightedList<WeightedOre>> replacements;
    protected final Set<BlockState> ores;

    public static Replacements custom(UnitConfig config, String category, String[] defaultValues, Function<UnitId, Optional<BlockState>> replacementMapper) {
        Replacements replacements = new Replacements(config, category, "customReplacements", defaultValues, replacementMapper);
        replacements.loadData();
        return replacements;
    }

    public Replacements(UnitConfig config, String category, String key, String[] defaultValues) {
        this(config, category, key, defaultValues, id -> Optional.ofNullable(id.getFirstMatchedState()));
    }

    public Replacements(UnitConfig config, String category, String key, String[] defaultValues, Function<UnitId, Optional<BlockState>> oreMapper) {
        super(config, category, key, defaultValues);
        this.oreMapper = oreMapper;
        this.replacements = new BlockStatesMap();
        this.ores = new HashSet<BlockState>();
    }

    public boolean haveReplacementFor(BlockState state) {
        return this.replacements.containsKey((Object)state);
    }

    public boolean containOreWith(BlockState state) {
        return this.ores.contains(state);
    }

    public Set<BlockState> getOres() {
        return Collections.unmodifiableSet(this.ores);
    }

    public Optional<WeightedOre> pickOreFor(BlockState replaceableBlock, Random random) {
        return Optional.ofNullable((CommonCollect.WeightedList)this.replacements.get((Object)replaceableBlock)).flatMap(ores -> ores.getRandom(random));
    }

    public boolean isEmpty() {
        return this.replacements.isEmpty();
    }

    protected String getComment() {
        return "Syntax: targetId -> replacementId\nWith weight: targetId -> replacementId, weight";
    }

    protected void parseConfigValues() {
        this.replacements.clear();
        for (String string : this.configValues) {
            List split = this.split(string, "->");
            try {
                if (split.size() != 2) {
                    throw new Exception("Invalid format");
                }
                UnitId targetId = Optional.of((String)split.get(0)).map(UnitId::from).filter(UnitId::notEmpty).orElseThrow(() -> new Exception("Invalid targetId"));
                UnitId replacementId = this.oreParser.getId((CharSequence)split.get(1));
                int weight = this.oreParser.getInteger((CharSequence)split.get(1)).orElse(1);
                BlockStatesSet replaceableBlocks = targetId.getAllMatchedBlockStates();
                BlockState replacement = this.oreMapper.apply(replacementId).orElse(null);
                if (replaceableBlocks == null || replacement == null) continue;
                this.add(replaceableBlocks, new WeightedOre(replacement, weight));
            }
            catch (Exception e) {
                this.oreParser.logError(AdLods.getInstance(), "replacement", string, e);
            }
        }
    }

    public void add(BlockStatesSet replaceableBlocks, WeightedOre ore) {
        this.ores.add(ore.getBlockState());
        replaceableBlocks.getBlocksWithAllStates().stream().map(block -> this.replacements.getBlocksWithAllStates().computeIfAbsent(block, b -> new CommonCollect.WeightedList())).forEach(list -> list.add((CommonCollect.IWeighted)ore));
        replaceableBlocks.stream().map(state -> (CommonCollect.WeightedList)this.replacements.computeIfAbsent(state, s -> new CommonCollect.WeightedList())).forEach(list -> list.add((CommonCollect.IWeighted)ore));
    }
}

