/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureEvents;
import shadows.apotheosis.adventure.AdventureGeneration;
import shadows.apotheosis.adventure.affix.AffixManager;
import shadows.apotheosis.adventure.affix.reforging.ReforgingMenu;
import shadows.apotheosis.adventure.affix.reforging.ReforgingRecipe;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableBlock;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import shadows.apotheosis.adventure.affix.salvaging.SalvageItem;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingMenu;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingTableBlock;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingTableTile;
import shadows.apotheosis.adventure.affix.socket.AddSocketsRecipe;
import shadows.apotheosis.adventure.affix.socket.ExpulsionRecipe;
import shadows.apotheosis.adventure.affix.socket.ExtractionRecipe;
import shadows.apotheosis.adventure.affix.socket.SocketingRecipe;
import shadows.apotheosis.adventure.affix.socket.UnnamingRecipe;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.affix.socket.gem.cutting.GemCuttingBlock;
import shadows.apotheosis.adventure.affix.socket.gem.cutting.GemCuttingMenu;
import shadows.apotheosis.adventure.boss.BossArmorManager;
import shadows.apotheosis.adventure.boss.BossEvents;
import shadows.apotheosis.adventure.boss.BossItemManager;
import shadows.apotheosis.adventure.boss.BossSpawnerBlock;
import shadows.apotheosis.adventure.boss.BossSummonerItem;
import shadows.apotheosis.adventure.boss.Exclusion;
import shadows.apotheosis.adventure.boss.MinibossManager;
import shadows.apotheosis.adventure.client.AdventureModuleClient;
import shadows.apotheosis.adventure.compat.AdventureTOPPlugin;
import shadows.apotheosis.adventure.compat.AdventureTwilightCompat;
import shadows.apotheosis.adventure.compat.GatewaysCompat;
import shadows.apotheosis.adventure.gen.BossDungeonFeature;
import shadows.apotheosis.adventure.gen.BossDungeonFeature2;
import shadows.apotheosis.adventure.gen.ItemFrameGemsProcessor;
import shadows.apotheosis.adventure.gen.RogueSpawnerFeature;
import shadows.apotheosis.adventure.loot.AffixConvertLootModifier;
import shadows.apotheosis.adventure.loot.AffixHookLootModifier;
import shadows.apotheosis.adventure.loot.AffixLootManager;
import shadows.apotheosis.adventure.loot.AffixLootModifier;
import shadows.apotheosis.adventure.loot.AffixLootPoolEntry;
import shadows.apotheosis.adventure.loot.GemLootModifier;
import shadows.apotheosis.adventure.loot.GemLootPoolEntry;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.adventure.loot.LootRarityManager;
import shadows.apotheosis.adventure.spawner.RandomSpawnerManager;
import shadows.apotheosis.ench.objects.GlowyBlockItem;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.block_entity.TickingBlockEntityType;
import shadows.placebo.config.Configuration;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.util.RegistryEvent;

public class AdventureModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Adventure");
    public static final BiMap<LootRarity, Item> RARITY_MATERIALS = HashBiMap.create();
    public static final boolean STAGES_LOADED = ModList.get().isLoaded("gamestages");
    public static final StructureProcessorType<ItemFrameGemsProcessor> ITEM_FRAME_LOOT = () -> ItemFrameGemsProcessor.CODEC;
    public static final boolean DEBUG = false;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22284_), (Object)200.0, (String)"f_22308_");
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22285_), (Object)100.0, (String)"f_22308_");
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        MinecraftForge.EVENT_BUS.register((Object)new AdventureEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BossEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        AffixManager.INSTANCE.registerToBus();
        GemManager.INSTANCE.registerToBus();
        AffixLootManager.INSTANCE.registerToBus();
        BossArmorManager.INSTANCE.registerToBus();
        BossItemManager.INSTANCE.registerToBus();
        RandomSpawnerManager.INSTANCE.registerToBus();
        LootRarityManager.INSTANCE.registerToBus();
        MinibossManager.INSTANCE.registerToBus();
        Apotheosis.HELPER.registerProvider(f -> {
            f.addRecipe((Recipe)new SocketingRecipe());
            f.addRecipe((Recipe)new ExpulsionRecipe());
            f.addRecipe((Recipe)new ExtractionRecipe());
            f.addRecipe((Recipe)new UnnamingRecipe());
        });
        e.enqueueWork(() -> {
            if (ModList.get().isLoaded("gateways")) {
                GatewaysCompat.register();
            }
            if (ModList.get().isLoaded("theoneprobe")) {
                AdventureTOPPlugin.register();
            }
            if (ModList.get().isLoaded("twilightforest")) {
                AdventureTwilightCompat.register();
            }
            LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.SIMPLE_REFORGING_TABLE.get()));
            LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.REFORGING_TABLE.get()));
            LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.SALVAGING_TABLE.get()));
            LootSystem.defaultBlockTable((Block)((Block)Apoth.Blocks.GEM_CUTTING_TABLE.get()));
            AdventureGeneration.init();
            Registry.m_122965_((Registry)Registry.f_122875_, (ResourceLocation)new ResourceLocation("apotheosis", "random_affix_item"), (Object)AffixLootPoolEntry.TYPE);
            Registry.m_122965_((Registry)Registry.f_122875_, (ResourceLocation)new ResourceLocation("apotheosis", "random_gem"), (Object)GemLootPoolEntry.TYPE);
            Exclusion.initSerializers();
            GemBonus.initCodecs();
            MobEffects.f_19610_.m_19472_(Attributes.f_22277_, "f8c3de3d-1fea-4d7c-a8b0-22f63c4c3454", -0.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
        });
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Feature<?>> e) {
        e.getRegistry().register((Object)BossDungeonFeature.INSTANCE, "boss_dng");
        e.getRegistry().register((Object)BossDungeonFeature2.INSTANCE, "boss_dng_2");
        e.getRegistry().register((Object)RogueSpawnerFeature.INSTANCE, "rogue_spawner");
        MinecraftForge.EVENT_BUS.register(AdventureGeneration.class);
        Registry.m_122961_((Registry)Registry.f_122891_, (String)"apotheosis:item_frame_gems", ITEM_FRAME_LOOT);
        Registry.m_122961_((Registry)BuiltinRegistries.f_123863_, (String)"apotheosis:item_frame_gems", (Object)new StructureProcessorList((List)ImmutableList.of((Object)((Object)new ItemFrameGemsProcessor(new ResourceLocation("a"))))));
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((Object)new GemItem(new Item.Properties()), "gem");
        e.getRegistry().register((Object)new BossSummonerItem(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "boss_summoner");
        e.getRegistry().register((Object)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "gem_dust");
        e.getRegistry().register((Object)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "vial_of_extraction");
        e.getRegistry().register((Object)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "vial_of_expulsion");
        e.getRegistry().register((Object)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "vial_of_unnaming");
        for (LootRarity r : LootRarity.values()) {
            SalvageItem material = new SalvageItem(r, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP));
            e.getRegistry().register((Object)material, r.id() + "_material");
            RARITY_MATERIALS.put((Object)r, (Object)material);
        }
        e.getRegistry().register((Object)new BlockItem((Block)Apoth.Blocks.SIMPLE_REFORGING_TABLE.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "simple_reforging_table");
        e.getRegistry().register((Object)new BlockItem((Block)Apoth.Blocks.REFORGING_TABLE.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "reforging_table");
        e.getRegistry().register((Object)new BlockItem((Block)Apoth.Blocks.SALVAGING_TABLE.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "salvaging_table");
        e.getRegistry().register((Object)new BlockItem((Block)Apoth.Blocks.GEM_CUTTING_TABLE.get(), new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "gem_cutting_table");
        e.getRegistry().register((Object)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "sigil_of_socketing");
        e.getRegistry().register((Object)new GlowyBlockItem.GlowyItem(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "superior_sigil_of_socketing");
        e.getRegistry().register((Object)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "sigil_of_enhancement");
        e.getRegistry().register((Object)new GlowyBlockItem.GlowyItem(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)), "superior_sigil_of_enhancement");
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((Object)new BossSpawnerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_222994_()), "boss_spawner");
        e.getRegistry().register((Object)new ReforgingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(2.0f, 20.0f), LootRarity.RARE), "simple_reforging_table");
        e.getRegistry().register((Object)new ReforgingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(4.0f, 1000.0f), LootRarity.MYTHIC), "reforging_table");
        e.getRegistry().register((Object)new SalvagingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.5f)), "salvaging_table");
        e.getRegistry().register((Object)new GemCuttingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.5f)), "gem_cutting_table");
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((Object)new TickingBlockEntityType(BossSpawnerBlock.BossSpawnerTile::new, (Set)ImmutableSet.of((Object)((Block)Apoth.Blocks.BOSS_SPAWNER.get())), false, true), "boss_spawner");
        e.getRegistry().register((Object)new TickingBlockEntityType(ReforgingTableTile::new, (Set)ImmutableSet.of((Object)((Block)Apoth.Blocks.SIMPLE_REFORGING_TABLE.get()), (Object)((Block)Apoth.Blocks.REFORGING_TABLE.get())), true, false), "reforging_table");
        e.getRegistry().register((Object)new BlockEntityType(SalvagingTableTile::new, (Set)ImmutableSet.of((Object)((Block)Apoth.Blocks.SALVAGING_TABLE.get())), null), "salvaging_table");
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((Object)SocketingRecipe.Serializer.INSTANCE, "socketing");
        e.getRegistry().register((Object)ExpulsionRecipe.Serializer.INSTANCE, "expulsion");
        e.getRegistry().register((Object)ExtractionRecipe.Serializer.INSTANCE, "extraction");
        e.getRegistry().register((Object)UnnamingRecipe.Serializer.INSTANCE, "unnaming");
        e.getRegistry().register((Object)AddSocketsRecipe.Serializer.INSTANCE, "add_sockets");
        e.getRegistry().register((Object)SalvagingRecipe.Serializer.INSTANCE, "salvaging");
        e.getRegistry().register((Object)ReforgingRecipe.Serializer.INSTANCE, "reforging");
    }

    @SubscribeEvent
    public void miscRegistration(RegisterEvent e) {
        if (e.getForgeRegistry() == ForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()) {
            e.getForgeRegistry().register("gems", GemLootModifier.CODEC);
            e.getForgeRegistry().register("affix_loot", AffixLootModifier.CODEC);
            e.getForgeRegistry().register("affix_conversion", AffixConvertLootModifier.CODEC);
            e.getForgeRegistry().register("affix_hook", AffixHookLootModifier.CODEC);
        }
        if (e.getForgeRegistry() == ForgeRegistries.BIOME_MODIFIER_SERIALIZERS.get()) {
            e.getForgeRegistry().register("blacklist", AdventureGeneration.BlacklistModifier.CODEC);
        }
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((Object)ContainerUtil.makeType(ReforgingMenu::new), "reforging");
        e.getRegistry().register((Object)ContainerUtil.makeType(SalvagingMenu::new), "salvage");
        e.getRegistry().register((Object)new MenuType(GemCuttingMenu::new), "gem_cutting");
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        e.enqueueWork(AdventureModuleClient::init);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new AdventureModuleClient());
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration mainConfig = new Configuration(new File(Apotheosis.configDir, "adventure.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        AdventureConfig.load(mainConfig);
        NameHelper.load(nameConfig);
        if (e == null && mainConfig.hasChanged()) {
            mainConfig.save();
        }
        if (e == null && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }

    public static class ApothUpgradeRecipe
    extends UpgradeRecipe {
        public ApothUpgradeRecipe(ResourceLocation pId, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
            super(pId, pBase, pAddition, pResult);
        }
    }
}

