/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.socket.gem.GemClass;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class MageSlayerBonus
extends GemBonus {
    public static Codec<MageSlayerBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, MageSlayerBonus::new));
    protected final Map<LootRarity, StepFunction> values;

    public MageSlayerBonus(Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("mageslayer"), new GemClass("helmet", (Set<LootCategory>)ImmutableSet.of((Object)LootCategory.HELMET)));
        this.values = values;
    }

    @Override
    public float onHurt(ItemStack gem, LootRarity rarity, DamageSource src, LivingEntity user, float amount) {
        float value = this.values.get(rarity).min();
        if (src.m_19387_()) {
            user.m_5634_(amount * (1.0f - value));
            return amount * (1.0f - value);
        }
        return super.onHurt(gem, rarity, src, user, amount);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        float value = this.values.get(rarity).min();
        return Component.m_237110_((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(value * 100.0f)}).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public MageSlayerBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }
}

