/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2.stack;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.util.BlockApiCache;
import java.util.Map;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.util.ChemicalBridge;
import mekanism.api.Action;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MekanismStackExportStrategy
implements StackExportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MekanismStackExportStrategy.class);
    private final Map<Byte, BlockApiCache<? extends IChemicalHandler>> lookups;
    private final Direction fromSide;

    public MekanismStackExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.lookups = Map.of((byte)0, BlockApiCache.create(MekCapabilities.GAS_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), (byte)1, BlockApiCache.create(MekCapabilities.INFUSION_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), (byte)2, BlockApiCache.create(MekCapabilities.PIGMENT_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), (byte)3, BlockApiCache.create(MekCapabilities.SLURRY_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos));
        this.fromSide = fromSide;
    }

    public long transfer(StackTransferContext context, AEKey what, long amount) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey mekanismKey = (MekanismKey)what;
        IChemicalHandler storage = (IChemicalHandler)this.lookups.get(mekanismKey.getForm()).find(this.fromSide);
        if (storage == null) {
            return 0L;
        }
        IStorageService inv = context.getInternalStorage();
        long extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE);
        long wasInserted = extracted - storage.insertChemical(ChemicalBridge.withAmount(mekanismKey.getStack(), extracted), Action.SIMULATE).getAmount();
        if (wasInserted > 0L) {
            extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)wasInserted, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE);
            wasInserted = extracted - storage.insertChemical(ChemicalBridge.withAmount(mekanismKey.getStack(), extracted), Action.EXECUTE).getAmount();
            if (wasInserted < extracted) {
                LOGGER.error("Storage export issue, voided {}x{}", (Object)(extracted - wasInserted), (Object)what);
            }
            return wasInserted;
        }
        return 0L;
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey mekanismKey = (MekanismKey)what;
        IChemicalHandler storage = (IChemicalHandler)this.lookups.get(mekanismKey.getForm()).find(this.fromSide);
        if (storage == null) {
            return 0L;
        }
        return amount - storage.insertChemical(ChemicalBridge.withAmount(mekanismKey.getStack(), amount), Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
    }
}

