/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.util;

import architectspalette.core.registry.APBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public interface APWeatheringCopper
extends ChangeOverTimeBlock<WeatheringCopper.WeatherState> {
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)((Block)APBlocks.COPPER_NUB.get()), (Object)((Block)APBlocks.EXPOSED_COPPER_NUB.get()));
        builder.put((Object)((Block)APBlocks.EXPOSED_COPPER_NUB.get()), (Object)((Block)APBlocks.WEATHERED_COPPER_NUB.get()));
        builder.put((Object)((Block)APBlocks.WEATHERED_COPPER_NUB.get()), (Object)((Block)APBlocks.OXIDIZED_COPPER_NUB.get()));
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());
    public static final Supplier<BiMap<Block, Block>> WAXED_BY_BLOCK = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)((Block)APBlocks.COPPER_NUB.get()), (Object)((Block)APBlocks.WAXED_COPPER_NUB.get()));
        builder.put((Object)((Block)APBlocks.EXPOSED_COPPER_NUB.get()), (Object)((Block)APBlocks.WAXED_EXPOSED_COPPER_NUB.get()));
        builder.put((Object)((Block)APBlocks.WEATHERED_COPPER_NUB.get()), (Object)((Block)APBlocks.WAXED_WEATHERED_COPPER_NUB.get()));
        builder.put((Object)((Block)APBlocks.OXIDIZED_COPPER_NUB.get()), (Object)((Block)APBlocks.WAXED_OXIDIZED_COPPER_NUB.get()));
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> UNWAXED_BY_BLOCK = Suppliers.memoize(() -> WAXED_BY_BLOCK.get().inverse());

    public static Optional<Block> getPrevious(Block block) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getPrevious(BlockState stateIn) {
        return APWeatheringCopper.getPrevious(stateIn.m_60734_()).map(block -> block.m_152465_(stateIn));
    }

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)block));
    }

    default public Optional<BlockState> m_142123_(BlockState state) {
        return APWeatheringCopper.getNext(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getWaxed(Block block) {
        return Optional.ofNullable((Block)WAXED_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getWaxed(BlockState state) {
        return APWeatheringCopper.getWaxed(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getUnWaxed(Block block) {
        return Optional.ofNullable((Block)UNWAXED_BY_BLOCK.get().get((Object)block));
    }

    public static Optional<BlockState> getUnWaxed(BlockState state) {
        return APWeatheringCopper.getUnWaxed(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Block getFirst(Block baseBlock) {
        Block block = baseBlock;
        Block block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)block);
        while (block1 != null) {
            block = block1;
            block1 = (Block)PREVIOUS_BY_BLOCK.get().get((Object)block1);
        }
        return block;
    }

    default public float m_142377_() {
        return this.m_142297_() == WeatheringCopper.WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static BlockState getToolModifiedState(ToolAction toolAction, BlockState state) {
        if (ToolActions.AXE_SCRAPE == toolAction) {
            return APWeatheringCopper.getPrevious(state).orElse(null);
        }
        if (ToolActions.AXE_WAX_OFF == toolAction) {
            return APWeatheringCopper.getUnWaxed(state).orElse(null);
        }
        return null;
    }

    public static InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        Optional<BlockState> waxed;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof HoneycombItem && (waxed = APWeatheringCopper.getWaxed(state)).isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, stack);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            world.m_7731_(pos, waxed.get(), 11);
            world.m_5898_(player, 3003, pos, 0);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

