/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core;

import architectspalette.core.config.APConfig;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.datagen.GatherData;
import architectspalette.core.integration.APCriterion;
import architectspalette.core.integration.APTrades;
import architectspalette.core.integration.APVerticalSlabsCondition;
import architectspalette.core.loot.WitheredBoneLootModifier;
import architectspalette.core.registry.APBiomeModifiers;
import architectspalette.core.registry.APBlockProperties;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APFeatures;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.APPlacedFeatures;
import architectspalette.core.registry.APSounds;
import architectspalette.core.registry.MiscRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="architects_palette")
public class ArchitectsPalette {
    public static final String MOD_ID = "architects_palette";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static ArchitectsPalette instance;

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public ArchitectsPalette() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)APConfig.COMMON_CONFIG);
        MiscRegistry.PARTICLE_TYPES.register(modEventBus);
        APSounds.SOUNDS.register(modEventBus);
        APBlocks.BLOCKS.register(modEventBus);
        APItems.ITEMS.register(modEventBus);
        APFeatures.FEATURES.register(modEventBus);
        modEventBus.addListener(EventPriority.LOWEST, this::setupCommon);
        modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
        this.registerRecipeSerializers(modEventBus);
        this.registerLootSerializers(modEventBus);
        this.registerBiomeSerializers(modEventBus);
        this.registerPlacedFeatures(modEventBus);
        CraftingHelper.register((IConditionSerializer)new APVerticalSlabsCondition.Serializer());
        GatherData.load();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    void setupCommon(FMLCommonSetupEvent event) {
        APBlockProperties.registerFlammables();
        APTrades.registerTrades();
        APCriterion.register();
    }

    void registerRecipeSerializers(IEventBus bus) {
        DeferredRegister RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registry.f_122914_, (String)MOD_ID);
        RegistryObject WARPING = RECIPE_TYPES.register(WarpingRecipe.TYPE.toString(), () -> new RecipeType<WarpingRecipe>(){});
        DeferredRegister RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MOD_ID);
        RegistryObject WARPING_S = RECIPE_SERIALIZERS.register(WarpingRecipe.TYPE.toString(), () -> WarpingRecipe.SERIALIZER);
        RECIPE_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
    }

    void registerLootSerializers(IEventBus bus) {
        DeferredRegister LOOT = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)MOD_ID);
        RegistryObject WITHER_SKELETON_DROPS = LOOT.register("wither_skeleton_bones", WitheredBoneLootModifier.CODEC);
        LOOT.register(bus);
    }

    void registerBiomeSerializers(IEventBus bus) {
        APBiomeModifiers.BIOME_MODIFIER_SERIALIZER.register(bus);
    }

    void registerPlacedFeatures(IEventBus bus) {
        APPlacedFeatures.PLACED_FEATURES.register(bus);
    }

    void setupClient(FMLClientSetupEvent event) {
        APBlockProperties.setupRenderLayers();
    }
}

