/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.core.registry.util.BlockNode;
import architectspalette.core.registry.util.StoneBlockSet;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class APLootTables
extends LootTableProvider {
    public APLootTables(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return List.of(Pair.of(APBlockLoot::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((location, lootTable) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)location, (LootTable)lootTable));
    }

    private static class APBlockLoot
    extends BlockLoot {
        private APBlockLoot() {
        }

        protected Iterable<Block> getKnownBlocks() {
            LinkedList<Block> blocks = new LinkedList<Block>();
            BlockNode.forAllBaseNodes(node -> node.forEach(n -> blocks.add(n.get())));
            return blocks;
        }

        protected void addTables() {
            BlockNode.forAllBaseNodes(this::processBlockNode);
        }

        private void slab(Block block) {
            this.m_124175_(block, x$0 -> BlockLoot.m_124290_((Block)x$0));
        }

        private void processStoneBlockSet(StoneBlockSet set) {
            set.forEachPart((part, block) -> {
                if (part == StoneBlockSet.SetComponent.SLAB) {
                    this.slab((Block)block);
                } else if (part == StoneBlockSet.SetComponent.VERTICAL_SLAB) {
                    this.slab((Block)block);
                } else {
                    this.m_124288_((Block)block);
                }
            });
        }

        private void processBlockNode(BlockNode node) {
            node.forEach(n -> {
                Block block = n.get();
                switch (n.type) {
                    case SLAB: 
                    case VERTICAL_SLAB: {
                        this.slab(block);
                        break;
                    }
                    default: {
                        this.m_124288_(block);
                    }
                }
            });
        }
    }
}

