/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.core.crafting.WarpingRecipe;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WarpingRecipeBuilder
implements RecipeBuilder {
    private final ResourceKey<Level> dimension;
    private final Item result;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public WarpingRecipeBuilder(Item result, ResourceKey<Level> dimension, Ingredient ... ingredients) {
        this.dimension = dimension;
        this.result = result;
        this.ingredients.addAll(Arrays.asList(ingredients));
    }

    public RecipeBuilder m_126132_(String p_176496_, CriterionTriggerInstance p_176497_) {
        this.advancement.m_138386_(p_176496_, p_176497_);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String p_176495_) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation name) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)name)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)name)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(name, this.result, this.ingredients, this.dimension, this.advancement, new ResourceLocation(name.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + name.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation name;
        private final Item result;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementName;
        private final ResourceKey<Level> dimension;

        public Result(ResourceLocation name, Item result, List<Ingredient> ingredients, ResourceKey<Level> dimension, Advancement.Builder advancement, ResourceLocation advancementName) {
            this.name = name;
            this.result = result;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementName = advancementName;
            this.dimension = dimension;
        }

        public void m_7917_(JsonObject json) {
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            json.add("ingredient", (JsonElement)jsonarray);
            JsonObject item = new JsonObject();
            item.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            json.add("result", (JsonElement)item);
            json.addProperty("dimension", this.dimension.m_135782_().toString());
        }

        public ResourceLocation m_6445_() {
            return this.name;
        }

        public RecipeSerializer<?> m_6637_() {
            return WarpingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementName;
        }
    }
}

