/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model;

import architectspalette.core.model.util.BakedModelWrapperWithData;
import architectspalette.core.model.util.QuadHelper;
import architectspalette.core.model.util.SpriteShift;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class BoardModel
extends BakedModelWrapperWithData {
    private static final ModelProperty<BoardData> BOARD_PROPERTY = new ModelProperty();
    private final SpriteShift spriteShift;

    public BoardModel(BakedModel originalModel, SpriteShift boardShift) {
        super(originalModel);
        this.spriteShift = boardShift;
    }

    @Override
    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return builder.with(BOARD_PROPERTY, (Object)new BoardData(pos));
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(BOARD_PROPERTY)) {
            return quads;
        }
        BoardData data = (BoardData)extraData.get(BOARD_PROPERTY);
        if (data == null) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            boolean shift;
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (quad.m_111306_().m_122411_() >= 2) {
                shift = data.getHorizontal();
                if (quad.m_111306_().m_122411_() < 4) {
                    shift = !shift;
                }
            } else {
                shift = data.getVertical();
                if (quad.m_111306_().m_122411_() == 0) {
                    boolean bl = shift = !shift;
                }
            }
            if (!shift) continue;
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            float uShift = this.spriteShift.getUShift();
            float vShift = this.spriteShift.getVShift();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = QuadHelper.getU(vertexData, vertex);
                float v = QuadHelper.getV(vertexData, vertex);
                QuadHelper.setU(vertexData, vertex, u + uShift);
                QuadHelper.setV(vertexData, vertex, v + vShift);
            }
            quads.set(i, newQuad);
        }
        return quads;
    }

    private static class BoardData {
        private final boolean isXOdd;
        private final boolean isZOdd;

        public BoardData(BlockPos pos) {
            this(BoardData.isOdd(pos.m_123341_()), BoardData.isOdd(pos.m_123343_()));
        }

        public BoardData(boolean isOddX, boolean isOddZ) {
            this.isXOdd = isOddX;
            this.isZOdd = isOddZ;
        }

        public boolean getHorizontal() {
            return this.isZOdd ^ this.isXOdd;
        }

        public boolean getVertical() {
            return this.isXOdd;
        }

        private static boolean isOdd(int num) {
            return Math.abs(num) % 2 == 1;
        }
    }
}

