/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.AvatarBlockEntity;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.block.mana.ManaPrismBlock;
import vazkii.botania.xplat.XplatAbstractions;

public class AvatarBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape X_AABB = AvatarBlock.m_49796_((double)5.0, (double)0.0, (double)3.5, (double)11.0, (double)17.0, (double)12.5);
    private static final VoxelShape Z_AABB = AvatarBlock.m_49796_((double)3.5, (double)0.0, (double)5.0, (double)12.5, (double)17.0, (double)11.0);

    protected AvatarBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() == Direction.Axis.X) {
            return X_AABB;
        }
        return Z_AABB;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AvatarBlockEntity avatar = (AvatarBlockEntity)world.m_7702_(pos);
        ItemStack stackOnAvatar = avatar.getItemHandler().m_8020_(0);
        ItemStack stackOnPlayer = player.m_21120_(hand);
        if (!stackOnAvatar.m_41619_()) {
            avatar.getItemHandler().m_6836_(0, ItemStack.f_41583_);
            player.m_150109_().m_150079_(stackOnAvatar);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (!stackOnPlayer.m_41619_() && XplatAbstractions.INSTANCE.findAvatarWieldable(stackOnPlayer) != null) {
            avatar.getItemHandler().m_6836_(0, stackOnPlayer.m_41620_(1));
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newstate, boolean isMoving) {
        if (!state.m_60713_(newstate.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newstate, isMoving);
        }
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AvatarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AvatarBlock.createTickerHelper(type, BotaniaBlockEntities.AVATAR, AvatarBlockEntity::commonTick);
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (world.m_46753_(pos)) {
            ManaPrismBlock.redstoneParticlesInShape(state, world, pos, rand);
        }
    }
}

