/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;

public class SplitLensRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<SplitLensRecipe> SERIALIZER = new SimpleRecipeSerializer(SplitLensRecipe::new);

    public SplitLensRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level worldIn) {
        return !this.assemble(inv).m_41619_();
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv) {
        ItemStack found = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack candidate = inv.m_8020_(i);
            if (candidate.m_41619_() || found.m_41619_() && !(found = this.getComposite(candidate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        if (!found.m_41619_()) {
            found = found.m_41777_();
            found.m_41764_(1);
        }
        return found;
    }

    private ItemStack getComposite(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BasicLensItem)) {
            return ItemStack.f_41583_;
        }
        BasicLensItem basicLens = (BasicLensItem)item;
        return basicLens.getCompositeLens(stack);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack candidate = inv.m_8020_(i);
            Item item = candidate.m_41720_();
            if (!(item instanceof BasicLensItem)) continue;
            BasicLensItem basicLensItem = (BasicLensItem)item;
            ItemStack newLens = candidate.m_41777_();
            newLens.m_41764_(1);
            basicLensItem.setCompositeLens(newLens, ItemStack.f_41583_);
            remaining.set(i, (Object)newLens);
        }
        return remaining;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

