/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.client.particle.lightning;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.zeith.botanicadds.client.particle.lightning.ThVector3;

public class BoltCore {
    ArrayList<Segment> segments = new ArrayList();
    ThVector3 start;
    ThVector3 end;
    HashMap splitparents = new HashMap();
    public float multiplier;
    public float length;
    public int numsegments0;
    public int increment;
    private int numsplits;
    private boolean finalized;
    private boolean canhittarget = true;
    private Random rand;
    public long seed;
    public int particleAge;
    public int particleMaxAge;
    private AABB boundingBox;
    public static final float speed = 3.0f;
    public static final int fadetime = 20;

    public BoltCore(ThVector3 jammervec, ThVector3 targetvec, long seed) {
        this.start = jammervec;
        this.end = targetvec;
        this.seed = seed;
        this.rand = new Random(seed);
        this.numsegments0 = 1;
        this.increment = 1;
        this.length = this.end.copy().sub(this.start).length();
        this.particleMaxAge = 3 + this.rand.nextInt(3) - 1;
        this.multiplier = 1.0f;
        this.particleAge = -((int)(this.length * 3.0f));
        this.boundingBox = new AABB((double)Math.min(this.start.x, this.end.x), (double)Math.min(this.start.y, this.end.y), (double)Math.min(this.start.z, this.end.z), (double)Math.max(this.start.x, this.end.x), (double)Math.max(this.start.y, this.end.y), (double)Math.max(this.start.z, this.end.z)).m_82386_((double)(this.length / 2.0f), (double)(this.length / 2.0f), (double)(this.length / 2.0f));
        this.segments.add(new Segment(this.start, this.end));
    }

    public BoltCore(Entity detonator, Entity target, long seed) {
        this(new ThVector3(detonator), new ThVector3(target), seed);
    }

    public BoltCore(Entity detonator, Entity target, long seed, int speed) {
        this(new ThVector3(detonator), new ThVector3(target.m_20185_(), target.m_20186_() + (double)target.m_20192_() - (double)0.7f, target.m_20189_()), seed);
        this.increment = speed;
        this.multiplier = 0.4f;
    }

    public BoltCore(double x1, double y1, double z1, double x, double y, double z, long seed, int duration, float multi, int speed) {
        this(new ThVector3(x1, y1, z1), new ThVector3(x, y, z), seed);
        this.particleMaxAge = duration + this.rand.nextInt(duration) - duration / 2;
        this.multiplier = multi;
        this.increment = speed;
    }

    public void setMultiplier(float m) {
        this.multiplier = m;
    }

    public void fractal(int splits, float amount, float splitchance, float splitlength, float splitangle) {
        if (this.finalized) {
            return;
        }
        ArrayList<Segment> oldsegments = this.segments;
        this.segments = new ArrayList();
        Segment prev = null;
        for (Segment segment : oldsegments) {
            int i;
            prev = segment.prev;
            ThVector3 subsegment = segment.diff.copy().scale(1.0f / (float)splits);
            BoltPoint[] newpoints = new BoltPoint[splits + 1];
            ThVector3 startpoint = segment.startpoint.point;
            newpoints[0] = segment.startpoint;
            newpoints[splits] = segment.endpoint;
            for (i = 1; i < splits; ++i) {
                ThVector3 randoff = ThVector3.getPerpendicular(segment.diff).rotate(this.rand.nextFloat() * 360.0f, segment.diff);
                randoff.scale((this.rand.nextFloat() - 0.5f) * amount);
                ThVector3 basepoint = startpoint.copy().add(subsegment.copy().scale(i));
                newpoints[i] = new BoltPoint(basepoint, randoff);
            }
            for (i = 0; i < splits; ++i) {
                Segment next = new Segment(newpoints[i], newpoints[i + 1], segment.light, segment.segmentno * splits + i, segment.splitno);
                next.prev = prev;
                if (next.prev != null) {
                    prev.next = next;
                }
                if (i != 0 && this.rand.nextFloat() < splitchance) {
                    ThVector3 splitrot = ThVector3.xCrossProduct(next.diff).rotate(this.rand.nextFloat() * 360.0f, next.diff);
                    ThVector3 diff = next.diff.copy().rotate((this.rand.nextFloat() * 0.66f + 0.33f) * splitangle, splitrot).scale(splitlength);
                    ++this.numsplits;
                    this.splitparents.put(this.numsplits, next.splitno);
                    Segment split = new Segment(newpoints[i], new BoltPoint(newpoints[i + 1].basepoint, newpoints[i + 1].offsetvec.copy().add(diff)), segment.light / 2.0f, next.segmentno, this.numsplits);
                    split.prev = prev;
                    this.segments.add(split);
                }
                prev = next;
                this.segments.add(next);
            }
            if (segment.next == null) continue;
            segment.next.prev = prev;
        }
        this.numsegments0 *= splits;
    }

    public void defaultFractal() {
        this.fractal(2, this.length * this.multiplier / 8.0f, 0.7f, 0.1f, 45.0f);
        this.fractal(2, this.length * this.multiplier / 12.0f, 0.5f, 0.1f, 50.0f);
        this.fractal(2, this.length * this.multiplier / 17.0f, 0.5f, 0.1f, 55.0f);
        this.fractal(2, this.length * this.multiplier / 23.0f, 0.5f, 0.1f, 60.0f);
        this.fractal(2, this.length * this.multiplier / 30.0f, 0.0f, 0.0f, 0.0f);
        this.fractal(2, this.length * this.multiplier / 34.0f, 0.0f, 0.0f, 0.0f);
        this.fractal(2, this.length * this.multiplier / 40.0f, 0.0f, 0.0f, 0.0f);
    }

    public void defaultFractal(int splits, float baseAngle) {
        this.fractal(splits, this.length * this.multiplier / 8.0f, 0.7f, 0.1f, baseAngle);
        this.fractal(splits, this.length * this.multiplier / 12.0f, 0.5f, 0.1f, baseAngle + 5.0f);
        this.fractal(splits, this.length * this.multiplier / 17.0f, 0.5f, 0.1f, baseAngle + 10.0f);
        this.fractal(splits, this.length * this.multiplier / 23.0f, 0.5f, 0.1f, baseAngle + 15.0f);
        this.fractal(splits, this.length * this.multiplier / 30.0f, 0.0f, 0.0f, baseAngle - 45.0f);
        this.fractal(splits, this.length * this.multiplier / 34.0f, 0.0f, 0.0f, baseAngle - 45.0f);
        this.fractal(splits, this.length * this.multiplier / 40.0f, 0.0f, 0.0f, baseAngle - 45.0f);
    }

    private void calculateCollisionAndDiffs() {
        HashMap<Integer, Integer> lastactivesegment = new HashMap<Integer, Integer>();
        this.segments.sort(new SegmentSorter());
        int lastsplitcalc = 0;
        int lastactiveseg = 0;
        float splitresistance = 0.0f;
        for (Segment segment : this.segments) {
            if (segment.splitno > lastsplitcalc) {
                lastactivesegment.put(lastsplitcalc, lastactiveseg);
                lastsplitcalc = segment.splitno;
                lastactiveseg = (Integer)lastactivesegment.get(this.splitparents.get(segment.splitno));
                float f = splitresistance = lastactiveseg >= segment.segmentno ? 0.0f : 50.0f;
            }
            if (!(splitresistance < 40.0f * segment.light)) continue;
            lastactiveseg = segment.segmentno;
        }
        lastactivesegment.put(lastsplitcalc, lastactiveseg);
        lastsplitcalc = 0;
        lastactiveseg = (Integer)lastactivesegment.get(0);
        Iterator<Segment> iterator2 = this.segments.iterator();
        while (iterator2.hasNext()) {
            Segment segment2 = iterator2.next();
            if (lastsplitcalc != segment2.splitno) {
                lastsplitcalc = segment2.splitno;
                lastactiveseg = (Integer)lastactivesegment.get(segment2.splitno);
            }
            if (segment2.segmentno > lastactiveseg) {
                iterator2.remove();
            }
            segment2.calcEndDiffs();
        }
        if ((Integer)lastactivesegment.get(0) + 1 < this.numsegments0) {
            this.canhittarget = false;
        }
    }

    public void finalizeBolt() {
        if (this.finalized) {
            return;
        }
        this.finalized = true;
        this.calculateCollisionAndDiffs();
        this.segments.sort(new SegmentLightSorter());
    }

    public void onUpdate() {
        this.particleAge += this.increment;
        if (this.particleAge > this.particleMaxAge) {
            this.particleAge = this.particleMaxAge;
        }
    }

    public AABB getBoundingBox() {
        return this.boundingBox;
    }

    public class Segment {
        public BoltPoint startpoint;
        public BoltPoint endpoint;
        public ThVector3 diff;
        public Segment prev;
        public Segment next;
        public ThVector3 nextdiff;
        public ThVector3 prevdiff;
        public float sinprev;
        public float sinnext;
        public float light;
        public int segmentno;
        public int splitno;
        final BoltCore this$0;

        public void calcDiff() {
            this.diff = this.endpoint.point.copy().sub(this.startpoint.point);
        }

        public void calcEndDiffs() {
            ThVector3 thisdiffnorm;
            if (this.prev != null) {
                ThVector3 prevdiffnorm = this.prev.diff.copy().normalize();
                thisdiffnorm = this.diff.copy().normalize();
                this.prevdiff = thisdiffnorm.add(prevdiffnorm).normalize();
                this.sinprev = (float)Math.sin(ThVector3.anglePreNorm(thisdiffnorm, prevdiffnorm.scale(-1.0f)) / 2.0f);
            } else {
                this.prevdiff = this.diff.copy().normalize();
                this.sinprev = 1.0f;
            }
            if (this.next != null) {
                ThVector3 nextdiffnorm = this.next.diff.copy().normalize();
                thisdiffnorm = this.diff.copy().normalize();
                this.nextdiff = thisdiffnorm.add(nextdiffnorm).normalize();
                this.sinnext = (float)Math.sin(ThVector3.anglePreNorm(thisdiffnorm, nextdiffnorm.scale(-1.0f)) / 2.0f);
            } else {
                this.nextdiff = this.diff.copy().normalize();
                this.sinnext = 1.0f;
            }
        }

        public String toString() {
            return String.valueOf(this.startpoint.point.toString()) + " " + this.endpoint.point.toString();
        }

        public Segment(BoltPoint start, BoltPoint end, float light, int segmentnumber, int splitnumber) {
            this.this$0 = BoltCore.this;
            this.startpoint = start;
            this.endpoint = end;
            this.light = light;
            this.segmentno = segmentnumber;
            this.splitno = splitnumber;
            this.calcDiff();
        }

        public Segment(ThVector3 start, ThVector3 end) {
            this(this$0.new BoltPoint(start, new ThVector3(0.0, 0.0, 0.0)), this$0.new BoltPoint(end, new ThVector3(0.0, 0.0, 0.0)), 1.0f, 0, 0);
        }
    }

    public class BoltPoint {
        ThVector3 point;
        ThVector3 basepoint;
        ThVector3 offsetvec;
        final BoltCore this$0;

        public BoltPoint(ThVector3 basepoint, ThVector3 offsetvec) {
            this.this$0 = BoltCore.this;
            this.point = basepoint.copy().add(offsetvec);
            this.basepoint = basepoint;
            this.offsetvec = offsetvec;
        }
    }

    public class SegmentSorter
    implements Comparator {
        final BoltCore this$0;

        public int compare(Segment o1, Segment o2) {
            int comp = Integer.valueOf(o1.splitno).compareTo(o2.splitno);
            if (comp == 0) {
                return Integer.valueOf(o1.segmentno).compareTo(o2.segmentno);
            }
            return comp;
        }

        public int compare(Object obj, Object obj1) {
            return this.compare((Segment)obj, (Segment)obj1);
        }

        public SegmentSorter() {
            this.this$0 = BoltCore.this;
        }
    }

    public class SegmentLightSorter
    implements Comparator {
        final BoltCore this$0;

        public int compare(Segment o1, Segment o2) {
            return Float.compare(o2.light, o1.light);
        }

        public int compare(Object obj, Object obj1) {
            return this.compare((Segment)obj, (Segment)obj1);
        }

        public SegmentLightSorter() {
            this.this$0 = BoltCore.this;
        }
    }
}

